import numpy as np 
import matplotlib.pyplot as plt 
from scipy import stats 
import netCDF4 as nc 
from scipy.stats.stats import pearsonr

'-----------------------------------------------------------------------------------------------------------------------'
#LISTS DATA
'-----------------------------------------------------------------------------------------------------------------------'
list_triff5 = ['teikc',  'tebnn',  'tebnt',  'tebnl',  'tebnp',  'tebnr',  'teii91', 'tebnj',  'teii81', 'tebni',  'teii71', 'tebnh',  'teii61', 'tebng',  'teii51', 'tebnf',  'teii41', 'tebne',  'teii31', 'tebnd',  'teii21', 'tebnc',  'teii11', 'tebnb',  'teii01', 'tebna',  'teiiZ1', 'teiiY1', 'teiiX1', 'teiiW1', 'teiiV1', 'teiiU1', 'teiiT1', 'teiiS1', 'teiiR1', 'teiiQ1', 'teiiP1', 'teiiO1', 'teiiN1', 'teiiM1', 'teiiL1', 'teiiK1', 'teiiJ1', 'teiiI1', 'teiiH1', 'teiiG1', 'teiiF1', 'teiiE1', 'teiiD1', 'teiiC1', 'teiiB1', 'teiiA1', 'teiiz1', 'teiiy1', 'teiix1', 'teiiw1', 'teiiv1', 'teiiu1', 'teiit1', 'teiis1', 'teiir1', 'teiiq1', 'teiip1', 'teiio1', 'teiin1', 'teiim1', 'teiil1', 'teiik1', 'teiij1', 'teiii1', 'teiih1', 'teiig1', 'teiif1', 'teiie1', 'teiid1', 'teiic1', 'teiib1', 'teiia1']

list_timetriff = [140,     130,    128,    126,    124,    122,    120,    118,    116,    114,    112,    110,    108,    106,    104,    102,    100,    98,     96,     94,     92,     90,     88,     86,     84,     82,     80,     78,     76,     74,     72,     70,     68,     66,     64,     62,     60,     58,     56,     54,     52,     50,     48,     46,     44,     42,     40,     38,     36,     34,     32,     30,     28,     26,     24,     22,     21,     20,     19,     18,     17,     16,     15,    14,     13,     12,     11,     10,     9,      8,     7,      6,      5,      4,      3,      2,      1,      0]


list_simu_03 = ['teIXG', 'teIXF', 'teIXE', 'teIXD', 'teIXC', 'teIXB', 'teIXA', 'teIXz', 'teIXy', 'teIXx', 'teIXw', 'teIXv', 'teIXu',
 'teIXt', 'teIXs', 'teIXr', 'teIXq', 'teIXp', 'teIXo', 'teIXn' ,'teIXm', 'teIXl', 'teIXk' ,'teIXj' ,'teIXi', 'teIXh', 'teIXg', 'teIXf',
  'teIXe', 'teIXd', 'teIXc' ,'teIXb' ,'teIXa' ,'teIx9', 'teIx8', 'teIx7' ,'teIx6', 'teIx5', 'teIx4' ,'teIx3', 'teIx2', 'teIx1', 'teIx0',
  'teIxZ', 'teIxY', 'teIxX', 'teIxW', 'teIxV' ,'teIxU' ,'teIxT', 'teIxS', 'teIxR' ,'teIxQ' ,'teIxP', 'teIxO', 'teIxN' ,'teIxM', 'teIxL',
  'teIxK', 'teIxJ' ,'teIxI', 'teIxH' ,'teIxG', 'teIxF', 'teIxE', 'teIxD', 'teIxC' ,'teIxB', 'teIxA' ,'teIxz', 'teIxy', 'teIxx', 'teIxw', 
  'teIxv', 'teIxu', 'teIxt' ,'teIxs', 'teIxr', 'teIxq', 'teIxp', 'teIxo', 'teIxn', 'teIxm', 'teIxl' ,'teIxk' ,'teIxj' ,'teIxi', 'teIxh', 'teIxg',
  'teIxf', 'teIxe', 'teIxd', 'teIxc', 'teIxb' ,'teIxa' ,'teiX9', 'teiX8' ,'teiX7', 'teiX6', 'teiX5' ,'teiX4' ,'teiX3' ,'teiX2', 'teiX1', 'teiX0',
  'teiXZ', 'teiXY', 'teiXX', 'teiXW' ,'teiXV' ,'teiXU', 'teiXT', 'teiXS', 'teiXR', 'teiXQ', 'teiXP', 'teiXO', 'teiXN', 'teiXM', 'teiXL', 'teiXK',
  'teiXJ', 'teiXI', 'teiXH' ,'teiXG', 'teiXF' ,'teiXE', 'teiXD', 'teiXC', 'teiXB', 'teiXA', 'teiXz' ,'teiXy', 'teiXx', 'teiXw', 'teiXv' ,'teiXu',
  'teiXt', 'teiXs' ,'teiXr', 'teiXq', 'teiXp', 'teiXo', 'teiXn', 'teiXm', 'teiXl', 'teiXk', 'teiXj', 'teiXi', 'teiXh', 'teiXg', 'teiXf', 'teiXe',
  'teiXd', 'teiXc', 'teiXb', 'teiXa', 'teix9' ,'teix8' ,'teix7' ,'teix6', 'teix5', 'teix4', 'teix3', 'teix2', 'teix1', 'teix0', 'teixZ', 'teixY',
  'teixX', 'teixW', 'teixV', 'teixU' ,'teixT', 'teixS', 'teixR', 'teixQ', 'teixP' ,'teixO', 'teixN', 'teixM', 'teixL', 'teixK', 'teixJ', 'teixI',
  'teixH', 'teixG', 'teixF' ,'teixE' ,'teixD' ,'teixC', 'teixB', 'teixA', 'teixz' ,'teixy' ,'teixx', 'teixw', 'teixv', 'teixu', 'teixt', 'teixs',
  'teixr', 'teixq' ,'teixp' ,'teixo', 'teixn' ,'teixm', 'teixl', 'teixk', 'teixj', 'teixi', 'teixh', 'teixg', 'teixf', 'teixe', 'teixd', 'teixc',
   'teixb', 'teixa']


list_simu_04 = ['teVTG1', 'teVTF1', 'teVTE1', 'teVTD1', 'teVTC1', 'teVTB1', 'teVTA1', 'teVTz1', 'teVTy1','teVTx1','teVTw1', 
 'teVTv1', 'teVTu1', 'teVTt1', 'teVTs1', 'teVTr1', 'teVTq1', 'teVTp1', 'teVTo1', 'teVTn1', 'teVTm1',
'teVTl1', 'teVTk1', 'teVTj1', 'teVTi1', 'teVTh1', 'teVTg1', 'teVTf1', 'teVTe1', 'teVTd1', 'teVTc1', 'teVTb1', 'teVTa1', 
'teVt91', 'teVt81', 'teVt71', 'teVt61', 'teVt51',  'teVt41', 'teVt31', 'teVt21', 'teVt11', 'teVt01', 'teVtZ1',
 'teVtY1', 'teVtX1', 'teVtW1', 'teVtV1', 'teVtU1', 'teVtT1', 'teVtS1', 'teVtR1', 'teVtQ1', 'teVtP1', 'teVtO1', 'teVtN1', 
 'teVtM1', 'teVtL1', 'teVtK1', 'teVtJ1', 'teVtI1', 'teVtH1', 'teVtG1', 'teVtF1', 'teVtE1', 'teVtD1', 'teVtC1',
 'teVtB1', 'teVtA1', 'teVtz1', 'teVty1', 'teVtx1', 'teVtw1', 'teVtv1', 'teVtu1', 'teVtt1', 'teVts1', 'teVtr1',
'teVtq1', 'teVtp1', 'teVto1', 'teVtn1', 'teVtm1', 'teVtl1', 'teVtk1', 'teVtj1', 'teVti1', 'teVth1', 'teVtg1', 'teVtf1',
 'teVte1', 'teVtd1', 'teVtc1', 'teVtb1', 'teVta1', 'tevT91', 'tevT81', 'tevT71', 'tevT61', 'tevT51', 'tevT41',
'tevT31', 'tevT21', 'tevT11', 'tevT01', 'tevTZ1', 'tevTY1', 'tevTX1', 'tevTW1', 'tevTV1', 'tevTU1', 'tevTT1', 'tevTS1',
 'tevTR1', 'tevTQ1', 'tevTP1', 'tevTO1', 'tevTN1', 'tevTM1', 'tevTL1', 'tevTK1', 'tevTJ1', 'tevTI1', 'tevTH1',
 'tevTG1', 'tevTF1', 'tevTE1', 'tevTD1', 'tevTC1', 'tevTB1', 'tevTA1', 'tevTz1', 'tevTy1', 'tevTx1', 'tevTw1', 'tevTv1',
 'tevTu1', 'tevTt1', 'tevTs1', 'tevTr1', 'tevTq1', 'tevTp1', 'tevTo1', 'tevTn1', 'tevTm1', 'tevTl1', 'tevTk1',
 'tevTj1', 'tevTi1', 'tevTh1', 'tevTg1', 'tevTf1', 'tevTe1', 'tevTd1', 'tevTc1', 'tevTb1', 'tevTa1', 'tevt91', 
'tevt81', 'tevt71', 'tevt61', 'tevt51', 'tevt41', 'tevt31', 'tevt21', 'tevt11', 'tevt01', 'tevtZ1', 'tevtY1', 'tevtX1',
 'tevtW1','tevtV1', 'tevtU1', 'tevtT1', 'tevtS1', 'tevtR1', 'tevtQ1', 'tevtP1', 'tevtO1', 'tevtN1', 'tevtM1',
'tevtL1', 'tevtK1', 'tevtJ1', 'tevtI1', 'tevtH1', 'tevtG1', 'tevtF1', 'tevtE1', 'tevtD1', 'tevtC1', 'tevtB1', 'tevtA1',
 'tevtz1', 'tevty1', 'tevtx1', 'tevtw1', 'tevtv1', 'tevtu1', 'tevtt1', 'tevts1', 'tevtr1', 'tevtq1', 'tevtp1',
 'tevto1', 'tevtn1', 'tevtm1', 'tevtl1', 'tevtk1', 'tevtj1', 'tevti1', 'tevth1', 'tevtg1', 'tevtf1', 'tevte1', 'tevtd1',
 'tevtc1', 'tevtb1', 'tevta1']
 
 
list_simu_05 = ['teVUG', 'teVUF', 'teVUE', 'teVUD', 'teVUC', 'teVUB', 'teVUA', 'teVUz', 'teVUy', 'teVUx', 'teVUw', 'teVUv', 'teVUu', 'teVUt', 'teVUs', 'teVUr', 'teVUq',
 'teVUp', 'teVUo', 'teVUn', 'teVUm', 'teVUl', 'teVUk', 'teVUj', 'teVUi', 'teVUh', 'teVUg', 'teVUf', 'teVUe', 'teVUd', 'teVUc', 'teVUb', 'teVUa', 'teVu9', 'teVu8', 'teVu7',
 'teVu6', 'teVu5', 'teVu4', 'teVu3', 'teVu2', 'teVu1', 'teVu0', 'teVuZ', 'teVuY', 'teVuX', 'teVuW', 'teVuV', 'teVuU', 'teVuT', 'teVuS', 'teVuR', 'teVuQ', 'teVuP', 'teVuO',
 'teVuN', 'teVuM', 'teVuL', 'teVuK', 'teVuJ', 'teVuI', 'teVuH', 'teVuG', 'teVuF', 'teVuE', 'teVuD', 'teVuC', 'teVuB', 'teVuA', 'teVuz', 'teVuy', 'teVux', 'teVuw', 'teVuv',
 'teVuu', 'teVut', 'teVus', 'teVur', 'teVuq', 'teVup', 'teVuo', 'teVun', 'teVum', 'teVul', 'teVuk', 'teVuj', 'teVui', 'teVuh', 'teVug', 'teVuf', 'teVue', 'teVud', 'teVuc',
 'teVub', 'teVua', 'tevU9', 'tevU8', 'tevU7', 'tevU6', 'tevU5', 'tevU4', 'tevU3', 'tevU2', 'tevU1', 'tevU0', 'tevUZ', 'tevUY', 'tevUX', 'tevUW', 'tevUV', 'tevUU', 'tevUT',
 'tevUS', 'tevUR', 'tevUQ', 'tevUP', 'tevUO', 'tevUN', 'tevUM', 'tevUL', 'tevUK', 'tevUJ', 'tevUI', 'tevUH', 'tevUG', 'tevUF', 'tevUE', 'tevUD', 'tevUC', 'tevUB', 'tevUA',
 'tevUz', 'tevUy', 'tevUx', 'tevUw', 'tevUv', 'tevUu', 'tevUt', 'tevUs', 'tevUr', 'tevUq', 'tevUp', 'tevUo', 'tevUn', 'tevUm', 'tevUl', 'tevUk', 'tevUj', 'tevUi', 'tevUh',
 'tevUg', 'tevUf', 'tevUe', 'tevUd', 'tevUc','tevUb', 'tevUa', 'tevu9', 'tevu8', 'tevu7', 'tevu6', 'tevu5', 'tevu4', 'tevu3', 'tevu2', 'tevu1', 'tevu0', 'tevuZ', 'tevuY',
 'tevuX', 'tevuW', 'tevuV', 'tevuU', 'tevuT', 'tevuS', 'tevuR', 'tevuQ', 'tevuP', 'tevuO', 'tevuN', 'tevuM', 'tevuL', 'tevuK', 'tevuJ', 'tevuI', 'tevuH', 'tevuG', 'tevuF',
 'tevuE', 'tevuD', 'tevuC', 'tevuB', 'tevuA', 'tevuz', 'tevuy', 'tevux', 'tevuw', 'tevuv', 'tevuu', 'tevut', 'tevus', 'tevur', 'tevuq', 'tevup', 'tevuo', 'tevun', 'tevum',
 'tevul', 'tevuk', 'tevuj', 'tevui', 'tevuh', 'tevug', 'tevuf', 'tevue', 'tevud', 'tevuc', 'tevub', 'tevua']
 
 
list_simu_06 = ['teVVG', 'teVVF', 'teVVE', 'teVVD', 'teVVC', 'teVVB', 'teVVA' ,'teVVz', 'teVVy', 'teVVx', 'teVVw', 'teVVv', 'teVVu', 'teVVt', 'teVVs' ,'teVVr', 'teVVq', 
'teVVp' ,'teVVo', 'teVVn' ,'teVVm', 'teVVl' ,'teVVk' ,'teVVj', 'teVVi' ,'teVVh' ,'teVVg' ,'teVVf', 'teVVe', 'teVVd' ,'teVVc' ,'teVVb' ,'teVVa', 'teVv9', 'teVv8', 'teVv7',
 'teVv6' ,'teVv5', 'teVv4', 'teVv3', 'teVv2' ,'teVv1', 'teVv0' ,'teVvZ' ,'teVvY', 'teVvX', 'teVvW', 'teVvV' ,'teVvU' ,'teVvT' ,'teVvS', 'teVvR', 'teVvQ', 'teVvP', 'teVvO' ,
'teVvN' ,'teVvM' ,'teVvL' ,'teVvK' ,'teVvJ' ,'teVvI' ,'teVvH', 'teVvG' ,'teVvF' ,'teVvE', 'teVvD', 'teVvC' ,'teVvB' ,'teVvA', 'teVvz', 'teVvy', 'teVvx' ,'teVvw' ,'teVvv', 
'teVvu' ,'teVvt', 'teVvs', 'teVvr', 'teVvq' ,'teVvp' ,'teVvo' ,'teVvn' ,'teVvm', 'teVvl' ,'teVvk' ,'teVvj' ,'teVvi' ,'teVvh' ,'teVvg' ,'teVvf' ,'teVve' ,'teVvd',
'teVvc' ,'teVvb' ,'teVva' ,'tevV9', 'tevV8', 'tevV7', 'tevV6', 'tevV5', 'tevV4' ,'tevV3' ,'tevV2', 'tevV1' ,'tevV0' ,'tevVZ', 'tevVY' ,'tevVX', 'tevVW', 'tevVV' ,'tevVU',
 'tevVT' ,'tevVS', 'tevVR' ,'tevVQ', 'tevVP' ,'tevVO', 'tevVN' ,'tevVM', 'tevVL' ,'tevVK' ,'tevVJ' ,'tevVI', 'tevVH', 'tevVG' ,'tevVF', 'tevVE' ,'tevVD', 'tevVC' ,'tevVB', 
'tevVA', 'tevVz', 'tevVy', 'tevVx', 'tevVw', 'tevVv', 'tevVu', 'tevVt' ,'tevVs', 'tevVr', 'tevVq', 'tevVp', 'tevVo', 'tevVn', 'tevVm', 'tevVl', 'tevVk', 'tevVj', 'tevVi', 
'tevVh' ,'tevVg', 'tevVf', 'tevVe' ,'tevVd' ,'tevVc', 'tevVb', 'tevVa', 'tevv9', 'tevv8', 'tevv7', 'tevv6', 'tevv5', 'tevv4', 'tevv3', 'tevv2', 'tevv1', 'tevv0',
 'tevvZ' ,'tevvY', 'tevvX' ,'tevvW' ,'tevvV' ,'tevvU', 'tevvT', 'tevvS', 'tevvR', 'tevvQ', 'tevvP', 'tevvO', 'tevvN', 'tevvM', 'tevvL', 'tevvK', 'tevvJ', 'tevvI', 'tevvH', 'tevvG', 
'tevvF' ,'tevvE', 'tevvD', 'tevvC' ,'tevvB' ,'tevvA', 'tevvz', 'tevvy', 'tevvx', 'tevvw', 'tevvv' ,'tevvu', 'tevvt' ,'tevvs' ,'tevvr' ,'tevvq' ,'tevvp', 'tevvo',
'tevvn' ,'tevvm', 'tevvl' ,'tevvk' ,'tevvj', 'tevvi', 'tevvh', 'tevvg', 'tevvf' ,'tevve' ,'tevvd' ,'tevvc' ,'tevvb' ,'tevva']

list_simu_07 = ["tEWtY", 'tEWtX', 'tEWtW', 'tEWtV', 'tEWtU', 'tEWtT', 'tEWtS' ,'tEWtR' ,'tEWtQ', 'tEWtP', 'tEWtO', 'tEWtN', 'tEWtM', 'tEWtL', 'tEWtK', 'tEWtJ', 'tEWtI',
'tEWtH', 'tEWtG', 'tEWtF' ,'tEWtE' ,'tEWtD', 'tEWtC' ,'tEWtB', 'tEWtA', 'tEWtz' ,'tEWty', 'tEWtx', 'tEWtw' ,'tEWtv', 'tEWtu' ,'tEWtt' ,'tEWts' ,'tEWtr' ,'tEWtq' ,'tEWtp',
 'tEWto' ,'tEWtn', 'tEWtm', 'tEWtl', 'tEWtk' ,'tEWtj' ,'tEWti', 'tEWth' ,'tEWtg' ,'tEWtf' ,'tEWte' ,'tEWtd', 'tEWtc', 'tEWtb', 'tEWta', 'tEwT9' ,'tEwT8' ,'tEwT7' ,'tEwT6', 
 'tEwT5', 'tEwT4' ,'tEwT3' ,'tEwT2', 'tEwT1', 'tEwT0' ,'tEwTZ' ,'tEwTY' ,'tEwTX' ,'tEwTW', 'tEwTV', 'tEwTU', 'tEwTT' ,'tEwTS' ,'tEwTR' ,'tEwTQ' ,'tEwTP', 'tEwTO', 'tEwTN',
 'tEwTM', 'tEwTL' ,'tEwTK' ,'tEwTJ' ,'tEwTI' ,'tEwTH' ,'tEwTG' ,'tEwTF' ,'tEwTE' ,'tEwTD', 'tEwTC' ,'tEwTB' ,'tEwTA' ,'tEwTz', 'tEwTy' ,'tEwTx' ,'tEwTw', 'tEwTv' ,'tEwTu',
  'tEwTt', 'tEwTs', 'tEwTr' ,'tEwTq', 'tEwTp', 'tEwTo', 'tEwTn' ,'tEwTm' ,'tEwTl' ,'tEwTk', 'tEwTj', 'tEwTi' ,'tEwTh', 'tEwTg', 'tEwTf' ,'tEwTe' ,'tEwTd', 'tEwTc' ,'tEwTb',
   'tEwTa', 'tEwt9', 'tEwt8', 'tEwt7', 'tEwt6', 'tEwt5', 'tEwt4' ,'tEwt3' ,'tEwt2', 'tEwt1', 'tEwt0' ,'tEwtZ', 'tEwtY' ,'tEwtX', 'tEwtW' ,'tEwtV' ,'tEwtU' ,'tEwtT' ,'tEwtS',
   'tEwtR', 'tEwtQ' ,'tEwtP', 'tEwtO' ,'tEwtN' ,'tEwtM', 'tEwtL', 'tEwtK', 'tEwtJ', 'tEwtI' ,'tEwtH', 'tEwtG', 'tEwtF', 'tEwtE' ,'tEwtD' ,'tEwtC', 'tEwtB' ,'tEwtA' ,'tEwtz',
   'tEwty', 'tEwtx', 'tEwtw' ,'tEwtv' ,'tEwtu', 'tEwtt' ,'tEwts', 'tEwtr' ,'tEwtq' ,'tEwtp' ,'tEwto', 'tEwtn' ,'tEwtm' ,'tEwtl' ,'tEwtk', 'tEwtj' ,'tEwti' ,'tEwth', 'tEwtg',
  'tEwtf', 'tEwte' ,'tEwtd' ,'tEwtc' ,'tEwtb', 'tEwta', 'teWT9', 'teWT8' ,'teWT7', 'teWT6', 'teWT5' ,'teWT4' ,'teWT3' ,'teWT2', 'teWT1', 'teWT0', 'teWTZ', 'teWTY', 'teWTX',
  'teWTW', 'teWTV', 'teWTU', 'teWTT' ,'teWTS', 'teWTR' ,'teWTQ', 'teWTP', 'teWTO' ,'teWTN', 'teWTM' ,'teWTL' ,'teWTK' ,'teWTJ', 'teWTI', 'teWTH', 'teWTG', 'teWTF' ,'teWTE',
   'teWTD' ,'teWTC' ,'teWTB' ,'teWTA' ,'teWTz' ,'teWTy' ,'teWTx', 'teWTw', 'teWTv' ,'teWTu', 'teWTt', 'teWTs' ,'teWTr' ,'teWTq', 'teWTp', 'teWTo', 'teWTn', 'teWTm' ,'teWTl',
    'teWTk', 'teWTj' ,'teWTi', 'teWTh', 'teWTg', 'teWTf', 'teWTe', 'teWTd' ,'teWTc', 'teWTb' ,'teWTa', 'teWt9', 'teWt8' ,'teWt7', 'teWt6', 'teWt5' ,'teWt4', 'teWt3', 'teWt2',
    'teWt1', 'teWt0', 'teWtZ' ,'teWtY' ,'teWtX' ,'teWtW', 'teWtV' ,'teWtU', 'teWtT' ,'teWtS', 'teWtR', 'teWtQ', 'teWtP', 'teWtO', 'teWtN' ,'teWtM', 'teWtL', 'teWtK' ,'teWtJ',
    'teWtI', 'teWtH', 'teWtG', 'teWtF', 'teWtE', 'teWtD' ,'teWtC', 'teWtB', 'teWtA', 'teWtz', 'teWty', 'teWtx', 'teWtw' ,'teWtv', 'teWtu' ,'teWtt' ,'teWts', 'teWtr' ,'teWtq',
     'teWtp', 'teWto', 'teWtn', 'teWtm' ,'teWtl' ,'teWtk' ,'teWtj', 'teWti', 'teWth', 'teWtg' ,'teWtf', 'teWte', 'teWtd', 'teWtc', 'teWtb' ,'teWta', 'tewT9', 'tewT8' ,'tewT7',
      'tewT6', 'tewT5', 'tewT4', 'tewT3', 'tewT2', 'tewT1', 'tewT0' ,'tewTZ' ,'tewTY', 'tewTX', 'tewTW', 'tewTV', 'tewTU', 'tewTT', 'tewTS', 'tewTR' ,'tewTQ' ,'tewTP', 'tewTO',
     'tewTN', 'tewTM', 'tewTL', 'tewTK', 'tewTJ', 'tewTI', 'tewTH', 'tewTG' ,'tewTF' ,'tewTE', 'tewTD' ,'tewTC', 'tewTB', 'tewTA', 'tewTz', 'tewTy', 'tewTx' ,'tewTw' ,'tewTv',     
     'tewTu' ,'tewTt' ,'tewTs' ,'tewTr' ,'tewTq' ,'tewTp' ,'tewTo' ,'tewTn' ,'tewTm', 'tewTl' ,'tewTk' ,'tewTj' ,'tewTi' ,'tewTh' ,'tewTg', 'tewTf' ,'tewTe', 'tewTd', 'tewTc', 
     'tewTb', 'tewTa', 'tewt9' ,'tewt8', 'tewt7', 'tewt6', 'tewt5', 'tewt4' ,'tewt3', 'tewt2' ,'tewt1', 'tewt0' ,'tewtZ' ,'tewtY', 'tewtX', 'tewtW' ,'tewtV' ,'tewtU' ,'tewtT',
      'tewtS' ,'tewtR', 'tewtQ' ,'tewtP' ,'tewtO' ,'tewtN', 'tewtM', 'tewtL', 'tewtK', 'tewtJ', 'tewtI', 'tewtH' ,'tewtG', 'tewtF', 'tewtE', 'tewtD', 'tewtC', 'tewtB', 'tewtA',
     'tewtz', 'tewty', 'tewtx', 'tewtw', 'tewtv' ,'tewtu', 'tewtt', 'tewts', 'tewtr' ,'tewtq' ,'tewtp', 'tewto' ,'tewtn', 'tewtm', 'tewtl' ,'tewtk' ,'tewtj' ,'tewti', 'tewth',
      'tewtg', 'tewtf', 'tewte', 'tewtd', 'tewtc', 'tewtb', 'tewta', 'tEVT9', 'tEVT8' ,'tEVT7', 'tEVT6', 'tEVT5', 'tEVT4', 'tEVT3', 'tEVT2', 'tEVT1', 'tEVT0', 'tEVTZ', 'tEVTY', 
     'tEVTX', 'tEVTW' ,'tEVTV' ,'tEVTU' ,'tEVTT' ,'tEVTS' ,'tEVTR', 'tEVTQ', 'tEVTP', 'tEVTO', 'tEVTN', 'tEVTM', 'tEVTL', 'tEVTK', 'tEVTJ' ,'tEVTI', 'tEVTH', 'tEVTG', 'tEVTF',
     'tEVTE', 'tEVTD', 'tEVTC', 'tEVTB', 'tEVTA', 'tEVTz', 'tEVTy' ,'tEVTx' ,'tEVTw', 'tEVTv', 'tEVTu' ,'tEVTt', 'tEVTs' ,'tEVTr' ,'tEVTq', 'tEVTp', 'tEVTo', 'tEVTn', 'tEVTm',
      'tEVTl', 'tEVTk' ,'tEVTj', 'tEVTi', 'tEVTh', 'tEVTg' ,'tEVTf' ,'tEVTe', 'tEVTd' ,'tEVTc', 'tEVTb', 'tEVTa', 'tEVt9' ,'tEVt8' ,'tEVt7' ,'tEVt6', 'tEVt5', 'tEVt4' ,'tEVt3',
     'tEVt2', 'tEVt1' ,'tEVt0', 'tEVtZ', 'tEVtY', 'tEVtX', 'tEVtW', 'tEVtV', 'tEVtU', 'tEVtT', 'tEVtS', 'tEVtR', 'tEVtQ' ,'tEVtP', 'tEVtO', 'tEVtN', 'tEVtM' ,'tEVtL', 'tEVtK',
      'tEVtJ', 'tEVtI' ,'tEVtH', 'tEVtG', 'tEVtF', 'tEVtE', 'tEVtD' ,'tEVtC' ,'tEVtB' ,'tEVtA' ,'tEVtz', 'tEVty' ,'tEVtx', 'tEVtw', 'tEVtv', 'tEVtu', 'tEVtt' ,'tEVts', 'tEVtr',
     'tEVtq', 'tEVtp', 'tEVto', 'tEVtn', 'tEVtm' ,'tEVtl', 'tEVtk' ,'tEVtj' ,'tEVti' ,'tEVth' ,'tEVtg' ,'tEVtf', 'tEVte', 'tEVtd', 'tEVtc', 'tEVtb', 'tEVta' ,'tEvT9', 'tEvT8',
     'tEvT7', 'tEvT6', 'tEvT5', 'tEvT4', 'tEvT3', 'tEvT2', 'tEvT1', 'tEvT0', 'tEvTZ', 'tEvTY', 'tEvTX', 'tEvTW' ,'tEvTV', 'tEvTU', 'tEvTT', 'tEvTS', 'tEvTR', 'tEvTQ', 'tEvTP',
     'tEvTO', 'tEvTN', 'tEvTM', 'tEvTL', 'tEvTK', 'tEvTJ', 'tEvTI' ,'tEvTH', 'tEvTG', 'tEvTF', 'tEvTE', 'tEvTD' ,'tEvTC', 'tEvTB' ,'tEvTA', 'tEvTz' ,'tEvTy', 'tEvTx', 'tEvTw',
     'tEvTv', 'tEvTu', 'tEvTt' ,'tEvTs', 'tEvTr', 'tEvTq', 'tEvTp', 'tEvTo', 'tEvTn', 'tEvTm', 'tEvTl' ,'tEvTk' ,'tEvTj', 'tEvTi' ,'tEvTh' ,'tEvTg' ,'tEvTf', 'tEvTe', 'tEvTd',
    'tEvTc', 'tEvTb', 'tEvTa', 'tEvt9', 'tEvt8', 'tEvt7', 'tEvt6', 'tEvt5', 'tEvt4', 'tEvt3', 'tEvt2', 'tEvt1', 'tEvt0', 'tEvtZ' ,'tEvtY' ,'tEvtX', 'tEvtW' ,'tEvtV', 'tEvtU', 
    'tEvtT', 'tEvtS', 'tEvtR', 'tEvtQ', 'tEvtP' ,'tEvtO' ,'tEvtN', 'tEvtM', 'tEvtL', 'tEvtK', 'tEvtJ' ,'tEvtI', 'tEvtH', 'tEvtG' ,'tEvtF', 'tEvtE', 'tEvtD', 'tEvtC', 'tEvtB',
     'tEvtA', 'tEvtz' ,'tEvty', 'tEvtx', 'tEvtw', 'tEvtv', 'tEvtu', 'tEvtt' ,'tEvts', 'tEvtr', 'tEvtq', 'tEvtp', 'tEvto', 'tEvtn', 'tEvtm', 'tEvtl', 'tEvtk', 'tEvtj', 'tEvti',
      'tEvth', 'tEvtg', 'tEvtf' ,'tEvte' ,'tEvtd', 'tEvtc', 'tEvtb', 'tEvta' ,'teVT9', 'teVT8', 'teVT7', 'teVT6', 'teVT5', 'teVT4', 'teVT3', 'teVT2', 'teVT1', 'teVT0', 'teVTZ',
     'teVTY', 'teVTX', 'teVTW', 'teVTV', 'teVTU', 'teVTT', 'teVTS', 'teVTR', 'teVTQ', 'teVTP', 'teVTO', 'teVTN', 'teVTM', 'teVTL', 'teVTK', 'teVTJ', 'teVTI', 'teVTH', 'teVTG',
      'teVTF', 'teVTE', 'teVTD', 'teVTC', 'teVTB', 'teVTA', 'teVTz', 'teVTy', 'teVTx', 'teVTw' ,'teVTv', 'teVTu', 'teVTt', 'teVTs' ,'teVTr', 'teVTq' ,'teVTp', 'teVTo', 'teVTn' ,
      'teVTm', 'teVTl', 'teVTk', 'teVTj', 'teVTi', 'teVTh', 'teVTg', 'teVTf' ,'teVTe', 'teVTd' ,'teVTc', 'teVTb', 'teVTa', 'teVt9', 'teVt8' ,'teVt7' ,'teVt6', 'teVt5' ,'teVt4',
       'teVt3' ,'teVt2' ,'teVt1', 'teVt0', 'teVtZ' ,'teVtY', 'teVtX' ,'teVtW', 'teVtV' ,'teVtU', 'teVtT', 'teVtS' ,'teVtR' ,'teVtQ', 'teVtP', 'teVtO' ,'teVtN' ,'teVtM' ,'teVtL', 
       'teVtK', 'teVtJ', 'teVtI', 'teVtH', 'teVtG', 'teVtF', 'teVtE', 'teVtD' ,'teVtC', 'teVtB', 'teVtA', 'teVtz', 'teVty', 'teVtx', 'teVtw', 'teVtv' ,'teVtu' ,'teVtt' ,'teVts',
       'teVtr', 'teVtq' ,'teVtp', 'teVto' ,'teVtn', 'teVtm', 'teVtl', 'teVtk' ,'teVtj', 'teVti', 'teVth', 'teVtg', 'teVtf' ,'teVte', 'teVtd', 'teVtc' ,'teVtb', 'teVta', 'tevT9',
       'tevT8', 'tevT7', 'tevT6', 'tevT5', 'tevT4', 'tevT3', 'tevT2' ,'tevT1', 'tevT0', 'tevTZ' ,'tevTY', 'tevTX', 'tevTW', 'tevTV', 'tevTU', 'tevTT', 'tevTS', 'tevTR', 'tevTQ',
       'tevTP', 'tevTO', 'tevTN', 'tevTM', 'tevTL' ,'tevTK', 'tevTJ', 'tevTI', 'tevTH' ,'tevTG', 'tevTF', 'tevTE', 'tevTD' ,'tevTC', 'tevTB', 'tevTA' ,'tevTz', 'tevTy', 'tevTx',
       'tevTw', 'tevTv', 'tevTu', 'tevTt' ,'tevTs' ,'tevTr', 'tevTq' ,'tevTp', 'tevTo', 'tevTn', 'tevTm', 'tevTl', 'tevTk', 'tevTj', 'tevTi', 'tevTh', 'tevTg', 'tevTf', 'tevTe',       
       'tevTd' ,'tevTc', 'tevTb' ,'tevTa', 'tevt9', 'tevt8', 'tevt7' ,'tevt6' ,'tevt5', 'tevt4' ,'tevt3', 'tevt2' ,'tevt1', 'tevt0' ,'tevtZ', 'tevtY', 'tevtX', 'tevtW' ,'tevtV',
       'tevtU', 'tevtT' ,'tevtS' ,'tevtR', 'tevtQ' ,'tevtP', 'tevtO', 'tevtN', 'tevtM' ,'tevtL', 'tevtK', 'tevtJ', 'tevtI', 'tevtH' ,'tevtG', 'tevtF', 'tevtE', 'tevtD', 'tevtC',      
        'tevtB' ,'tevtA', 'tevtz' ,'tevty' ,'tevtx', 'tevtw', 'tevtv' ,'tevtu' ,'tevtt' ,'tevts', 'tevtr' ,'tevtq', 'tevtp', 'tevto', 'tevtn' ,'tevtm', 'tevtl', 'tevtk' ,'tevtj',
        'tevti', 'tevth', 'tevtg', 'tevtf', 'tevte' ,'tevtd', 'tevtc' ,'tevtb' ,"tevta"]
 

list_simu_08 = ["tfMCG", "tfMCF", "tfMCE", "tfMCD", "tfMCC", "tfMCB", "tfMCA", "tfMCz", "tfMCy", "tfMCx", "tfMCw", "tfMCv", "tfMCu", "tfMCt", "tfMCs", "tfMCr", "tfMCq", "tfMCp", "tfMCo", "tfMCn", "tfMCm", "tfMCl", "tfMCk", "tfMCj", "tfMCi", "tfMCh", "tfMCg", "tfMCf", "tfMCe", "tfMCd", "tfMCc", "tfMCb", "tfMCa", "tfMc9", "tfMc8", "tfMc7", "tfMc6", "tfMc5", "tfMc4", "tfMc3", "tfMc2", "tfMc1", "tfMc0", "tfMcZ", "tfMcY", "tfMcX", "tfMcW", "tfMcV", "tfMcU", "tfMcT", "tfMcS", "tfMcR", "tfMcQ", "tfMcP", "tfMcO", "tfMcN", "tfMcM", "tfMcL", "tfMcK", "tfMcJ", "tfMcI", "tfMcH", "tfMcG", "tfMcF", "tfMcE", "tfMcD", "tfMcC", "tfMcB", "tfMcA", "tfMcz", "tfMcy", "tfMcx", "tfMcw", "tfMcv", "tfMcu", "tfMct", "tfMcs", "tfMcr", "tfMcq", "tfMcp", "tfMco", "tfMcn", "tfMcm", "tfMcl", "tfMck", "tfMcj", "tfMci", "tfMch", "tfMcg", "tfMcf", "tfMce", "tfMcd", "tfMcc", "tfMcb", "tfMca", "tfmC9", "tfmC8", "tfmC7", "tfmC6", "tfmC5", "tfmC4", "tfmC3", "tfmC2", "tfmC1", "tfmC0", "tfmCZ", "tfmCY", "tfmCX", "tfmCW", "tfmCV", "tfmCU", "tfmCT", "tfmCS", "tfmCR", "tfmCQ", "tfmCP", "tfmCO", "tfmCN", "tfmCM", "tfmCL", "tfmCK", "tfmCJ", "tfmCI", "tfmCH", "tfmCG", "tfmCF", "tfmCE", "tfmCD", "tfmCC", "tfmCB", "tfmCA", "tfmCz", "tfmCy", "tfmCx", "tfmCw", "tfmCv", "tfmCu", "tfmCt", "tfmCs", "tfmCr", "tfmCq", "tfmCp", "tfmCo", "tfmCn", "tfmCm", "tfmCl", "tfmCk", "tfmCj", "tfmCi", "tfmCh", "tfmCg", "tfmCf", "tfmCe", "tfmCd", "tfmCc", "tfmCb", "tfmCa", "tfmc9", "tfmc8", "tfmc7", "tfmc6", "tfmc5", "tfmc4", "tfmc3", "tfmc2", "tfmc1", "tfmc0", "tfmcZ", "tfmcY", "tfmcX", "tfmcW", "tfmcV", "tfmcU", "tfmcT", "tfmcS", "tfmcR", "tfmcQ", "tfmcP", "tfmcO", "tfmcN", "tfmcM", "tfmcL", "tfmcK", "tfmcJ", "tfmcI", "tfmcH", "tfmcG", "tfmcF", "tfmcE", "tfmcD", "tfmcC", "tfmcB", "tfmcA", "tfmcz", "tfmcy", "tfmcx", "tfmcw", "tfmcv", "tfmcu", "tfmct", "tfmcs", "tfmcr", "tfmcq", "tfmcp", "tfmco", "tfmcn", "tfmcm", "tfmcl", "tfmck", "tfmcj", "tfmci", "tfmch", "tfmcg", "tfmcf", "tfmce", "tfmcd", "tfmcc", "tfmcb", "tfmca"]


list_simu_09 = ["tfMEG", "tfMEF", "tfMEE", "tfMED", "tfMEC", "tfMEB", "tfMEA", "tfMEz", "tfMEy", "tfMEx", "tfMEw", "tfMEv", "tfMEu", "tfMEt", "tfMEs", "tfMEr", "tfMEq", "tfMEp", "tfMEo", "tfMEn", "tfMEm", "tfMEl", "tfMEk", "tfMEj", "tfMEi", "tfMEh", "tfMEg", "tfMEf", "tfMEe", "tfMEd", "tfMEc", "tfMEb", "tfMEa", "tfMe9", "tfMe8", "tfMe7", "tfMe6", "tfMe5", "tfMe4", "tfMe3", "tfMe2", "tfMe1", "tfMe0", "tfMeZ", "tfMeY", "tfMeX", "tfMeW", "tfMeV", "tfMeU", "tfMeT", "tfMeS", "tfMeR", "tfMeQ", "tfMeP", "tfMeO", "tfMeN", "tfMeM", "tfMeL", "tfMeK", "tfMeJ", "tfMeI", "tfMeH", "tfMeG", "tfMeF", "tfMeE", "tfMeD", "tfMeC", "tfMeB", "tfMeA", "tfMez", "tfMey", "tfMex", "tfMew", "tfMev", "tfMeu", "tfMet", "tfMes", "tfMer", "tfMeq", "tfMep", "tfMeo", "tfMen", "tfMem", "tfMel", "tfMek", "tfMej", "tfMei", "tfMeh", "tfMeg", "tfMef", "tfMee", "tfMed", "tfMec", "tfMeb", "tfMea", "tfmE9", "tfmE8", "tfmE7", "tfmE6", "tfmE5", "tfmE4", "tfmE3", "tfmE2", "tfmE1", "tfmE0", "tfmEZ", "tfmEY", "tfmEX", "tfmEW", "tfmEV", "tfmEU", "tfmET", "tfmES", "tfmER", "tfmEQ", "tfmEP", "tfmEO", "tfmEN", "tfmEM", "tfmEL", "tfmEK", "tfmEJ", "tfmEI", "tfmEH", "tfmEG", "tfmEF", "tfmEE", "tfmED", "tfmEC", "tfmEB", "tfmEA", "tfmEz", "tfmEy", "tfmEx", "tfmEw", "tfmEv", "tfmEu", "tfmEt", "tfmEs", "tfmEr", "tfmEq", "tfmEp", "tfmEo", "tfmEn", "tfmEm", "tfmEl", "tfmEk", "tfmEj", "tfmEi", "tfmEh", "tfmEg", "tfmEf", "tfmEe", "tfmEd", "tfmEc", "tfmEb", "tfmEa", "tfme9", "tfme8", "tfme7", "tfme6", "tfme5", "tfme4", "tfme3", "tfme2", "tfme1", "tfme0", "tfmeZ", "tfmeY", "tfmeX", "tfmeW", "tfmeV", "tfmeU", "tfmeT", "tfmeS", "tfmeR", "tfmeQ", "tfmeP", "tfmeO", "tfmeN", "tfmeM", "tfmeL", "tfmeK", "tfmeJ", "tfmeI", "tfmeH", "tfmeG", "tfmeF", "tfmeE", "tfmeD", "tfmeC", "tfmeB", "tfmeA", "tfmez", "tfmey", "tfmex", "tfmew", "tfmev", "tfmeu", "tfmet", "tfmes", "tfmer", "tfmeq", "tfmep", "tfmeo", "tfmen", "tfmem", "tfmel", "tfmek", "tfmej", "tfmei", "tfmeh", "tfmeg", "tfmef", "tfmee", "tfmed", "tfmec", "tfmeb", "tfmea"]


list_simu_10 = ["tfMGG", "tfMGF", "tfMGE", "tfMGD", "tfMGC", "tfMGB", "tfMGA", "tfMGz", "tfMGy", "tfMGx", "tfMGw", "tfMGv", "tfMGu", "tfMGt", "tfMGs", "tfMGr", "tfMGq", "tfMGp", "tfMGo", "tfMGn", "tfMGm", "tfMGl", "tfMGk", "tfMGj", "tfMGi", "tfMGh", "tfMGg", "tfMGf", "tfMGe", "tfMGd", "tfMGc", "tfMGb", "tfMGa", "tfMg9", "tfMg8", "tfMg7", "tfMg6", "tfMg5", "tfMg4", "tfMg3", "tfMg2", "tfMg1", "tfMg0", "tfMgZ", "tfMgY", "tfMgX", "tfMgW", "tfMgV", "tfMgU", "tfMgT", "tfMgS", "tfMgR", "tfMgQ", "tfMgP", "tfMgO", "tfMgN", "tfMgM", "tfMgL", "tfMgK", "tfMgJ", "tfMgI", "tfMgH", "tfMgG", "tfMgF", "tfMgE", "tfMgD", "tfMgC", "tfMgB", "tfMgA", "tfMgz", "tfMgy", "tfMgx", "tfMgw", "tfMgv", "tfMgu", "tfMgt", "tfMgs", "tfMgr", "tfMgq", "tfMgp", "tfMgo", "tfMgn", "tfMgm", "tfMgl", "tfMgk", "tfMgj", "tfMgi", "tfMgh", "tfMgg", "tfMgf", "tfMge", "tfMgd", "tfMgc", "tfMgb", "tfMga", "tfmG9", "tfmG8", "tfmG7", "tfmG6", "tfmG5", "tfmG4", "tfmG3", "tfmG2", "tfmG1", "tfmG0", "tfmGZ", "tfmGY", "tfmGX", "tfmGW", "tfmGV", "tfmGU", "tfmGT", "tfmGS", "tfmGR", "tfmGQ", "tfmGP", "tfmGO", "tfmGN", "tfmGM", "tfmGL", "tfmGK", "tfmGJ", "tfmGI", "tfmGH", "tfmGG", "tfmGF", "tfmGE", "tfmGD", "tfmGC", "tfmGB", "tfmGA", "tfmGz", "tfmGy", "tfmGx", "tfmGw", "tfmGv", "tfmGu", "tfmGt", "tfmGs", "tfmGr", "tfmGq", "tfmGp", "tfmGo", "tfmGn", "tfmGm", "tfmGl", "tfmGk", "tfmGj", "tfmGi", "tfmGh", "tfmGg", "tfmGf", "tfmGe", "tfmGd", "tfmGc", "tfmGb", "tfmGa", "tfmg9", "tfmg8", "tfmg7", "tfmg6", "tfmg5", "tfmg4", "tfmg3", "tfmg2", "tfmg1", "tfmg0", "tfmgZ", "tfmgY", "tfmgX", "tfmgW", "tfmgV", "tfmgU", "tfmgT", "tfmgS", "tfmgR", "tfmgQ", "tfmgP", "tfmgO", "tfmgN", "tfmgM", "tfmgL", "tfmgK", "tfmgJ", "tfmgI", "tfmgH", "tfmgG", "tfmgF", "tfmgE", "tfmgD", "tfmgC", "tfmgB", "tfmgA", "tfmgz", "tfmgy", "tfmgx", "tfmgw", "tfmgv", "tfmgu", "tfmgt", "tfmgs", "tfmgr", "tfmgq", "tfmgp", "tfmgo", "tfmgn", "tfmgm", "tfmgl", "tfmgk", "tfmgj", "tfmgi", "tfmgh", "tfmgg", "tfmgf", "tfmge", "tfmgd", "tfmgc", "tfmgb", "tfmga"]


list_time = [800 ,  796,   792,   788,   784,   780,   776,   772,   768,   764,  760,   756,   752,   748,  744,   740,   736,   732,
 728,   724,   720,   716,   712,   708,   704,   700,   696,   692,   688,   684,   680,   676,   672,   668,   664,   660,   656,
 652,   648,   644 ,  640 ,  636  , 632  , 628 ,  624  , 620  , 616 ,  612  , 608 ,  604 ,  600  , 596 ,  592 ,  588,   584 ,  580,   576,
 572,   568,   564  , 560  , 556  , 552   ,548,   544 ,  540  , 536  , 532   ,528,   524 ,  520 ,  516 ,  512  , 508  , 504 ,  500,
  496,   492,   488 ,  484,   480 ,  476 ,  472  , 468   ,464  , 460,   456,   452  , 448,   444  , 440   ,436,   432 ,  428,   424 ,  420,
 416 ,  412 ,  408 ,  404 ,  400  , 396 ,  392  , 388 ,  384  , 380  , 376,   372 ,  368  , 364  , 360 ,  356  , 352  , 348  , 344,
 340 ,  336  , 332  , 328 ,  324  , 320 ,  316 ,  312 ,  308 ,  304 ,  300 ,  296 ,  292 ,  288  , 284  , 280  , 276 ,  272 ,  268,   264,
  260 ,  256 ,  252 ,  248 ,  244 ,  240 ,  236,   232 ,  228  , 224 ,  220  , 216 ,  212 ,  208  , 204 ,  200 ,  196 ,  192  , 188,
 184  , 180 ,  176 ,  172 ,  168  , 164 ,  160  , 156,   152 ,  148  , 144  , 140 ,  136  , 132  , 128,   124 ,  120 ,  116  , 112,   108,
104,   100,   96,    92 ,   88  ,  84 ,   80  ,  76   , 72  ,  68  ,  64  ,  60   , 56   , 52,    48,    44,    40,    36,    32,
 28,    24 ,   23  ,  22  ,  21  ,  20  ,  19   , 18   , 17 ,   16  ,  15   , 14 ,   13  ,  12 ,   11  ,  10 ,   9 ,    8   ,  7 ,    6,
    5,     4,     3 ,    2  ,   1  , 0]
    
list_time07 = [3600, 3596, 3592, 3588, 3584, 3580, 3576, 3572, 3568, 3564, 3560, 3556, 3552, 3548, 3544, 3540, 3536, 3532, 3528, 3524, 3520,
3516, 3512, 3508, 3504, 3500, 3496, 3492, 3488, 3484, 3480, 3476, 3472, 3468, 3464, 3460, 3456, 3452, 3448, 3444, 3440, 3436, 3432, 3428, 3424,
3420, 3416, 3412, 3408, 3404, 3400, 3396, 3392, 3388, 3384, 3380, 3376, 3372, 3368, 3364, 3360, 3356, 3352, 3348, 3344, 3340, 3336, 3332, 3328,
3324, 3320, 3316, 3312, 3308, 3304, 3300, 3296, 3292, 3288, 3284, 3280, 3276, 3272, 3268, 3264, 3260, 3256, 3252, 3248, 3244, 3240, 3236, 3232,
3228, 3224, 3220, 3216, 3212, 3208, 3204, 3200, 3196, 3192, 3188, 3184, 3180, 3176, 3172, 3168, 3164, 3160, 3156, 3152, 3148, 3144, 3140, 3136,
3132, 3128, 3124, 3120, 3116, 3112, 3108, 3104, 3100, 3096, 3092, 3088, 3084, 3080, 3076, 3072, 3068, 3064, 3060, 3056, 3052, 3048, 3044, 3040, 3036,
3032, 3028, 3024, 3020, 3016, 3012, 3008, 3004, 3000, 2996, 2992, 2988, 2984, 2980, 2976, 2972, 2968, 2964, 2960, 2956, 2952 ,2948 ,2944, 2940 ,2936,
2932, 2928, 2924, 2920, 2916, 2912, 2908, 2904, 2900, 2896, 2892, 2888, 2884, 2880, 2876, 2872, 2868 ,2864, 2860, 2856 ,2852, 2848, 2844, 2840, 2836,
2832, 2828, 2824, 2820, 2816, 2812, 2808, 2804, 2800, 2796, 2792, 2788, 2784, 2780, 2776, 2772, 2768, 2764, 2760, 2756, 2752, 2748, 2744, 2740, 2736,
2732, 2728, 2724, 2720, 2716, 2712, 2708, 2704, 2700, 2696, 2692, 2688, 2684, 2680, 2676, 2672, 2668, 2664, 2660, 2656, 2652, 2648 ,2644, 2640, 2636,
2632, 2628, 2624, 2620, 2616, 2612, 2608, 2604, 2600, 2596, 2592, 2588, 2584, 2580, 2576, 2572, 2568, 2564, 2560, 2556, 2552, 2548, 2544, 2540, 2536,
2532, 2528, 2524, 2520, 2516, 2512, 2508, 2504, 2500, 2496, 2492, 2488, 2484, 2480, 2476, 2472, 2468, 2464, 2460, 2456, 2452, 2448, 2444 ,2440, 2436,
2432, 2428, 2424, 2420, 2416, 2412, 2408, 2404, 2400, 2396, 2392, 2388, 2384, 2380, 2376, 2372, 2368, 2364, 2360, 2356, 2352, 2348, 2344 ,2340, 2336,
2332, 2328, 2324, 2320, 2316, 2312, 2308, 2304, 2300, 2296, 2292, 2288, 2284, 2280, 2276, 2272, 2268, 2264, 2260, 2256, 2252, 2248, 2244, 2240, 2236,
2232, 2228, 2224, 2220, 2216, 2212, 2208, 2204, 2200, 2196, 2192, 2188, 2184, 2180, 2176, 2172, 2168, 2164 ,2160, 2156 ,2152, 2148, 2144, 2140, 2136,
2132, 2128, 2124, 2120, 2116, 2112, 2108, 2104, 2100, 2096, 2092, 2088, 2084, 2080, 2076, 2072, 2068, 2064, 2060, 2056, 2052, 2048, 2044 ,2040, 2036 ,
2032, 2028, 2024, 2020, 2016, 2012, 2008, 2004, 2000, 1996, 1992, 1988, 1984, 1980, 1976, 1972, 1968, 1964, 1960, 1956, 1952, 1948, 1944, 1940, 1936,
1932, 1928, 1924, 1920, 1916, 1912, 1908, 1904 ,1900, 1896, 1892, 1888, 1884, 1880, 1876, 1872, 1868, 1864, 1860, 1856, 1852, 1848, 1844, 1840, 1836,
1832, 1828, 1824, 1820, 1816, 1812, 1808, 1804, 1800, 1796, 1792, 1788, 1784, 1780, 1776, 1772, 1768, 1764, 1760, 1756, 1752, 1748 ,1744 ,1740, 1736,
1732, 1728, 1724, 1720, 1716, 1712, 1708, 1704, 1700, 1696, 1692, 1688, 1684, 1680, 1676, 1672, 1668 ,1664 ,1660, 1656, 1652, 1648 ,1644 ,1640, 1636,
1632, 1628, 1624, 1620, 1616, 1612, 1608, 1604, 1600, 1596, 1592, 1588, 1584, 1580, 1576, 1572 ,1568, 1564, 1560, 1556, 1552 ,1548, 1544 ,1540 ,1536,
1532, 1528, 1524, 1520, 1516, 1512, 1508, 1504, 1500, 1496, 1492, 1488, 1484 ,1480 ,1476 ,1472, 1468, 1464, 1460, 1456, 1452, 1448, 1444 ,1440, 1436,
1432, 1428, 1424, 1420, 1416 ,1412, 1408, 1404, 1400 ,1396, 1392, 1388, 1384, 1380, 1376, 1372, 1368 ,1364, 1360, 1356, 1352, 1348, 1344 ,1340 ,1336 ,
1332, 1328, 1324 ,1320, 1316, 1312, 1308, 1304 ,1300, 1296, 1292, 1288, 1284 ,1280, 1276, 1272, 1268 ,1264 ,1260, 1256, 1252, 1248, 1244, 1240, 1236,
1232, 1228, 1224, 1220, 1216, 1212, 1208, 1204, 1200, 1196, 1192, 1188, 1184, 1180 ,1176 ,1172, 1168, 1164, 1160, 1156 ,1152 ,1148, 1144, 1140, 1136,
1132, 1128, 1124, 1120, 1116, 1112, 1108, 1104, 1100, 1096, 1092, 1088 ,1084, 1080, 1076, 1072, 1068, 1064, 1060, 1056, 1052, 1048, 1044, 1040, 1036,
1032, 1028, 1024, 1020, 1016, 1012, 1008, 1004, 1000, 996, 992, 988, 984, 980, 976, 972, 968, 964, 960, 956, 952, 948, 944, 940, 936, 932 ,928 ,924 ,
920, 916, 912, 908 ,904 ,900, 896, 892 ,888, 884, 880, 876 ,872, 868, 864, 860, 856, 852, 848, 844, 840, 836, 832, 828 ,824 ,820, 816, 812, 808, 804, 
800,  796,   792,   788,   784,   780,   776,   772,   768,   764,  760,   756,   752,   748,  744,   740,   736,   732,
 728,   724,   720,   716,   712,   708,   704,   700,   696,   692,   688,   684,   680,   676,   672,   668,   664,   660,   656,
 652,   648,   644 ,  640 ,  636  , 632  , 628 ,  624  , 620  , 616 ,  612  , 608 ,  604 ,  600  , 596 ,  592 ,  588,   584 ,  580,   576,
 572,   568,   564  , 560  , 556  , 552   ,548,   544 ,  540  , 536  , 532   ,528,   524 ,  520 ,  516 ,  512  , 508  , 504 ,  500,
  496,   492,   488 ,  484,   480 ,  476 ,  472  , 468   ,464  , 460,   456,   452  , 448,   444  , 440   ,436,   432 ,  428,   424 ,  420,
 416 ,  412 ,  408 ,  404 ,  400  , 396 ,  392  , 388 ,  384  , 380  , 376,   372 ,  368  , 364  , 360 ,  356  , 352  , 348  , 344,
 340 ,  336  , 332  , 328 ,  324  , 320 ,  316 ,  312 ,  308 ,  304 ,  300 ,  296 ,  292 ,  288  , 284  , 280  , 276 ,  272 ,  268,   264,
  260 ,  256 ,  252 ,  248 ,  244 ,  240 ,  236,   232 ,  228  , 224 ,  220  , 216 ,  212 ,  208  , 204 ,  200 ,  196 ,  192  , 188,
 184  , 180 ,  176 ,  172 ,  168  , 164 ,  160  , 156,   152 ,  148  , 144  , 140 ,  136  , 132  , 128,   124 ,  120 ,  116  , 112,   108,
104,   100,   96,    92 ,   88  ,  84 ,   80  ,  76   , 72  ,  68  ,  64  ,  60   , 56   , 52,    48,    44,    40,    36,    32,
 28,    24 ,   23  ,  22  ,  21  ,  20  ,  19   , 18   , 17 ,   16  ,  15   , 14 ,   13  ,  12 ,   11  ,  10 ,   9 ,    8   ,  7 ,    6,
    5,     4,     3 ,    2  ,   1  , 0]
 

#lats = nc.Dataset('/home/bridge/xk22684/ummodel/data/teVTG1/climate/teVTG1a.pdcljjs.nc').variables['latitude'  ][:]
#lons = nc.Dataset('/home/bridge/xk22684/ummodel/data/teVTG1/climate/teVTG1a.pdcljjs.nc').variables['longitude' ][:]

#latso = nc.Dataset('/home/bridge/xk22684/ummodel/data/teVTG1/climate/teVTG1o.pfcljjs.nc').variables['latitude'  ][:]
#lonso = nc.Dataset('/home/bridge/xk22684/ummodel/data/teVTG1/climate/teVTG1o.pfcljjs.nc').variables['longitude' ][:]


'-----------------------------------------------------------------------------------------------------------------------'
#FONCTIONS
'-----------------------------------------------------------------------------------------------------------------------'
def find_nearest(tab, point):

	"""
	Find in an array 'tab' the closest element to the scalar value 'point'
	tab = array 1D
	point = scalar
	"""
	
	idx = np.abs(tab-point).argmin()
	
	return idx 
	

def select_domain(lat, lon, lat_min, lat_max, lon_min, lon_max): 
	
	"""
	lat & lon : array 
	lat_min, lat_max, lon_min, lon_max : scalar
	
	Return : int (index) 
	"""
	
	id_lat_min = find_nearest(lat, lat_min)
	id_lat_max = find_nearest(lat, lat_max)	
	id_lon_min = find_nearest(lon, lon_min)
	id_lon_max = find_nearest(lon, lon_max)
	
	return id_lat_min, id_lat_max, id_lon_min, id_lon_max


def get_var_list(list_nc_files, var_name):

	var_list = []
	
	for f in list_nc_files:
	
		var_list.append(f.variables[var_name][:])
		
	return var_list 



def get_var_bbc_long(list_simu, var_name, month):
	
	nc_files = []
	
	for simu in list_simu :
	
		nc_files.append(nc.Dataset('./ummodel/data/' + simu + '/climate/' + simu + 'a.pdcl' + month + '.nc'))
	
	var = []
	
	for i in range(len(nc_files)):
	
		var.append(nc_files[i].variables[var_name][:])
	
	return var


def get_varo_bbc_long(list_simu, var_name, month):
	
	nc_files = []
	
	for simu in list_simu :
	
		nc_files.append(nc.Dataset('./ummodel/data/' + simu + '/climate/' + simu + 'o.pfcl' + month + '.nc'))
	
	var = []
	
	for i in range(len(nc_files)):
	
		var.append(nc_files[i].variables[var_name][:])
	
	return var



def get_msk_bbc_long(list_simu):

	msk_files = []
	
	for simu in list_simu :
	
		msk_files.append(nc.Dataset('./ummodel/data/' + simu + '/inidata/' + simu + '.qrparm.mask.nc'))
		
	
	mask = []
		
	for msk in msk_files :
		
		mask.append(msk.variables['lsm'][:])
	
	return mask
		
	


def plot (x, y, style, xlabel, ylabel, title, savefig):
    
    fig = plt.figure()
    plt.plot(x, y, style)
    plt.grid()
    plt.xlabel(xlabel)
    plt.ylabel(ylabel)
    #plt.gca().invert_yaxis()
    plt.title(title)
    fig.set_size_inches(11, 6)
    plt.tight_layout()
    plt.savefig('./fig/' + savefig)
    plt.show()
    plt.close()

def cut (data, id_lat_min, id_lat_max, id_lon_min, id_lon_max):

	'''
	data : list[array] 
	list of each simulation of an array where spatial data are saved 
	id_lat_min, id_lat_max, id_lon_min, id_lon_max: int 
	domain's demarcation index
	
	Return : data_dom = list[array]
	'''

	data_dom = []
	
	for simu in range(len(data)):
	
		data_dom.append(data[simu][0, 0, id_lat_min:id_lat_max+1, id_lon_min:id_lon_max+1])
	
	return data_dom
	
	
def cut_per_month (data, id_lat_min, id_lat_max, id_lon_min, id_lon_max):

	'''
	data : list[list[array]] 
	list of each simulation of an array where spatial data are saved 
	id_lat_min, id_lat_max, id_lon_min, id_lon_max: int 
	domain's demarcation index
	
	Return : data_dom = list[array]
	'''

	data_dom = []
	
	for simu in range(len(data)):
		
		dom_month = []
		
		for month in range(len(data[0])):
		
			dom_month.append(data[simu][month][0, 0, id_lat_min:id_lat_max+1, id_lon_min:id_lon_max+1]) 
	
		data_dom.append(dom_month)
	
	return data_dom
	

def cut_3d (data, id_lat_min, id_lat_max, id_lon_min, id_lon_max):
	
	data_dom = []
	
	for simu in range(len(data)):
	
		data_dom.append(data[simu][0, :, id_lat_min:id_lat_max+1, id_lon_min:id_lon_max+1])
	
	return data_dom
	

def mask_application (data, masks, config):

	'''
	data   : list[array] 
	list of each simulation of an array where spatial data are saved 
	masks  : list[array] 
	lists of mask for each simulation 
	config : str ('sea' or 'land')
	
	
	Return : data_masked (same as data but sea or land masked)
	
	'''
	
	if config == 'sea' :
		
		option = 1
		
	elif config == 'land' :
		
		option = 0
		
	data_masked = []
	
	for simu in range(len(data)):
		
		data_masked.append(np.ma.masked_array(data[simu], mask = (masks[simu] == option)))
		
	return data_masked
	

def mask_app_per_month(data_m, masks, config):

	
	if config == 'sea' :
		
		option = 1
		
	elif config == 'land' :
		
		option = 0
		
	data_masked = []
	
	for simu in range(len(data_m)):
	
		data_m_m = []
	
		for m in range(len(data_m[0])):
		
			data_m_m.append(np.ma.masked_array(data_m[simu][m], mask = (masks[simu] == option)))
			
		data_masked.append(data_m_m)
		
	return data_masked
	

def averages (data, conv_1 = 1, conv_2 = 0):

	'''
	data : list[array] 
	list of each simulation of an array where spatial data are saved 
	conversion : scalar 
	number with which data must be multiplicated 
	
	Return : data_mean (list of scalar)
	'''

	data_mean = []
	
	for simu in range(len(data)):
		
		moy = np.ma.mean(data[simu])
		#moy = data[simu].mean()
		data_mean.append(moy * conv_1 + conv_2)
		
	return data_mean


def somme (data, conv_1 = 1, conv_2 = 0):

	'''
	data : list[array] 
	list of each simulation of an array where spatial data are saved 
	conversion : scalar 
	number with which data must be multiplicated 
	
	Return : data_sum (list of scalar)
	'''

	data_sum = []
	
	for simu in range(len(data)):
	
		moy = data[simu].sum()
		data_sum.append(moy * conv_1 + conv_2)
		
	return data_sum


def get_data(namefile):

    data = np.loadtxt('./data/' + namefile, delimiter = ',', skiprows = 1)
    
    return data 


def agemodel(depths, age_model):

     
    ages = []

    for depth in depths:
        
        idx = np.abs(age_model[:, 0]-depth).argmin()
        ages.append(age_model[idx, 1])

    return ages 


def double_axisPlot(x, y1, y2, xlabel, y1label, y2label, title, save_as):
	
	fig, ax1 = plt.subplots()
	
	ax1.set_xlabel(xlabel)
	ax1.set_ylabel(y1label)
	ax1.plot(x, y1, '-ob')
	ax1.grid(True)
	ax1.tick_params(axis = 'y', labelcolor = 'blue')
	
	ax2 = ax1.twinx()
	ax2.invert_yaxis()
	ax2.set_ylabel(y2label)
	ax2.plot(x, y2, color = 'darkslategray')
	ax2.tick_params(axis = 'y', labelcolor = 'seagreen')
	
	plt.subtitle(title)
	fig.set_size_inches(11, 6)
	plt.tight_layout()
	plt.savefig('./fig/' + save_as)
	plt.show()
	plt.close()

	
def sub2plots (x1, y1, x_label, y_label1, title1, x2, y2, y_label2, title2, suptitle, savefig):
    
    fig_a, ax_a = plt.subplots(2, 1)
    
    ax_a[0].plot(x1, y1, '-o') # for sst 
    #ax_a[0].plot(x1, y1, '-o', color = 'darkslategray') # for sss
    ax_a[0].set_ylabel(y_label1)
    ax_a[0].grid(True)
    ax_a[0].set_title(title1)

    ax_a[1].plot(x2, y2, 'seagreen') #for proxy
    #ax_a[1].plot(x2, y2, 'teal')     #for salinity from proxy
    #ax_a[1].plot(x2, y2, 'black')    #for orbital parameters
    ax_a[1].set_xlabel(x_label)
    ax_a[1].set_ylabel(y_label2)
    ax_a[1].invert_yaxis()
    ax_a[1].grid(True)
    ax_a[1].set_title(title2)
    
    fig_a.set_size_inches(11, 6)


    plt.suptitle(suptitle)
    plt.tight_layout()
    plt.savefig('./fig/' + savefig)
    plt.show()
    plt.close()	
    
    
    
def sub3plots(x1, y1, x_label, y_label1, title1, x2, y2, y_label2, title2, x3, y3, y3bis, y_label3, title3, suptitle, savefig):
	
    fig_a, ax_a = plt.subplots(3, 1)
    
    ax_a[0].plot(x1, y1, '-o') # for sst 
    ax_a[0].set_ylabel(y_label1)
    ax_a[0].grid(True)
    ax_a[0].set_title(title1)

    #ax_a[1].plot(x2, y2, '-o') 
    ax_a[1].plot(x2, y2, 'seagreen')
    ax_a[1].set_ylabel(y_label2)
    ax_a[1].grid(True)
    ax_a[1].set_title(title2)
    
    #ax_a[2].plot(x3, y3, 'black') 
    ax_a[2].plot(x3, y3, 'seagreen') 
    #ax_a[2].plot(x3, y3bis, 'slategray')
    ax_a[2].set_xlabel(x_label)
    ax_a[2].set_ylabel(y_label3)
    ax_a[2].invert_yaxis()
    ax_a[2].grid(True)
    ax_a[2].set_title(title3)
    
    
    fig_a.set_size_inches(11, 7)


    plt.suptitle(suptitle)
    plt.tight_layout()
    plt.savefig('./fig/' + savefig)
    plt.show()
    plt.close()	


def sub3plots_orb (x1, y1, x_label, y_label1, title1, x2, y2, y3, y_label2, title2, suptitle, savefig):

	
    fig_a, ax_a = plt.subplots(2, 1)
    
    ax_a[0].plot(x1, y1, '-o') # for sst 
    ax_a[0].set_ylabel(y_label1)
    ax_a[0].grid(True)
    ax_a[0].set_title(title1)

    ax_a[1].plot(x2, y2, 'black')    #for orbital parameters
    ax_a[1].plot(x2, y3, 'slategray')
    ax_a[1].set_xlabel(x_label)
    ax_a[1].set_ylabel(y_label2)
    ax_a[1].invert_yaxis()
    ax_a[1].grid(True)
    ax_a[1].set_title(title2)
    
    fig_a.set_size_inches(11, 6)


    plt.suptitle(suptitle)
    plt.tight_layout()
    plt.savefig('./fig/' + savefig)
    plt.show()
    plt.close()	



def reconstruct (short_tabyrs, long_tabyrs, tab):

	tab_bis = []
	
	for age in short_tabyrs :
			
			idx = np.abs(long_tabyrs - age).argmin()
			tab_bis.append(tab[idx])
	
	return tab_bis




def correlation_test (data_prox, data_model):
	
	print('Pearson Test Result = ' , stats.pearsonr(data_prox, data_model))
	print(stats.spearmanr(data_prox, data_model))
	


def corr_prox (age_prox, list_time, prox_data, model_data):

	if len(age_prox) < len(list_time):
	
		model_data2 = reconstruct(age_prox, np.asarray(list_time), model_data)
		prox_data2  = prox_data
	
	if len(list_time) < len(age_prox):
		
		prox_data2  = reconstruct(np.asarray(list_time), age_prox, prox_data)
		model_data2 = model_data
		
	print(pearsonr(model_data2, prox_data2))
	#return prox_data2, model_data
		


def select_bbc_long():
	
	#ask for which simulation series 
	
	which_bbc_long = input("Enter 'bbc_long_04' or 'bbc_long_05' :")
 
	print(which_bbc_long)

	if which_bbc_long == 'bbc_long_04':

		list_simu = list_simu_04
	
	elif which_bbc_long == 'bbc_long_05':

		list_simu = list_simu_05
	
	return list_simu, which_bbc_long



def adaptativeColorMap(var, p1, p2, cmapColor):
    
    import numpy as np
    import matplotlib.pyplot as plt
    import matplotlib as mpl
    
    var = var.flatten() # 2D array -> 1D array
    var = var.compressed() # remove mask values

    n, bins = np.histogram(var, bins=10, density=True) 

    prob = n * np.diff(bins)
    
    if prob.max()-prob.mean() > 0.2:
        # Adaptative colormap (the more data available in a bin, 
        # the more increments will be generated implemented in this bin)
        lvl=[]
        
        for i in np.arange(0,len(n)):
        
            if n[i] * np.diff(bins)[i]< p1: # probability of bin n°i
                
                lvl=np.append(lvl,np.linspace(bins[i],bins[i+1],2))[0:-1]
            
            elif (p1 < n[i] * np.diff(bins)[i]) & (n[i] * np.diff(bins)[i]< p2):
                
                lvl=np.append(lvl,np.linspace(bins[i],bins[i+1],7))[0:-1] # 7 or 10
                
            else:
                
                lvl=np.append(lvl,np.linspace(bins[i],bins[i+1],20))[0:-1] # 20 or 40
        
        
        bounds = np.round(lvl,3)
        
        # diverging colormap
        # if (bounds.min() < 0) & (bounds.max() > 0):
        #     if np.abs(bounds.min()) < np.abs(bounds.max()):
        #         bounds = np.insert(bounds, 0, - bounds.max())
        #     if np.abs(bounds.min()) > np.abs(bounds.max()):
        #         bounds = np.append(bounds, np.abs(bounds.min()))
                
        cmap = plt.get_cmap(cmapColor,len(bounds)-1)
        norm = mpl.colors.BoundaryNorm(bounds, cmap.N)
        
    else:
        # cmap = cmapColor
        # norm = None

        cmap = plt.get_cmap(cmapColor,100)
        bounds = np.linspace(var.min(),var.max(),100)
        norm = mpl.colors.BoundaryNorm(bounds, cmap.N)
            
    return cmap, norm
	
'-----------------------------------------------------------------------------------------------------------------------'

	

