import numpy as np 
import new_tools as tools
import cartopy.crs as ccrs
import matplotlib.pyplot as plt 
import cartopy.feature as cfeature 
import pdb
import netCDF4 as nc
'-------------------------------------------------------------'
'DOMAIN'
'-------------------------------------------------------------'
lat_min, lat_max = 50, 0 
lon_min, lon_max = 60, 130
'-------------------------------------------------------------'

'-------------------------------------------------------------'
'DATA RECOVERY'
'-------------------------------------------------------------'
nc_file_monsoon  = nc.Dataset('/user/work/xk22684/work/data/monsoon_msk.nc')
precip_2mm_msk   = nc_file_monsoon.variables['precip_monsoon'][:]
lat, lon         = nc_file_monsoon.variables['lat'][:], nc_file_monsoon.variables['lon'][:]

idx, idxo          = [], []
idx .append(tools.select_domain(lat, lon, lat_min, lat_max, lon_min, lon_max))

precip_2mm_msk_cut        = precip_2mm_msk[idx[0][0] : idx[0][1] + 1, idx[0][2] : idx[0][3] + 1]
precip_2mm_msk_cut_masked = np.ma.masked_where(precip_2mm_msk_cut != 2, precip_2mm_msk_cut)
precip_2mm_msk_cut_masked[~precip_2mm_msk_cut_masked.mask] = 1

lat_cut, lon_cut   = lat[idx[0][0] : idx[0][1] + 1], lon[idx[0][2] : idx[0][3] + 1]
'-------------------------------------------------------------'
#pdb.set_trace()


'------------------------------------------------------------------------------'

fig = plt.figure(figsize=(10, 10))
ax = fig.add_subplot(1, 1, 1, projection=ccrs.PlateCarree())
ax.set_extent([60, 130, 0, 50], crs=ccrs.PlateCarree())

cont = ax.contourf(lon_cut, lat_cut, precip_2mm_msk_cut_masked,
                   alpha=0.8, cmap='GnBu_r', hatches='..')

ax.stock_img(alpha=0.5)
ax.add_feature(cfeature.LAND)
ax.add_feature(cfeature.COASTLINE)

ax.plot([90, 90], [0, 50], color='red', linewidth=2,
        transform=ccrs.PlateCarree(), linestyle='--', label='90E')

ax.plot([60, 130], [25, 25], color='red', linewidth=2,
        transform=ccrs.PlateCarree(), linestyle='--', label='25N')

# Gridlines
gl = ax.gridlines(draw_labels=True)
gl.top_labels = False
gl.right_labels = False
plt.savefig('/user/work/xk22684/work/fig/fig_paper_monsoon/dom_sup.png')

#plt.legend(loc='lower right')
plt.show()




pdb.set_trace()

fig = plt.figure(figsize=(10, 10))
ax = fig.add_subplot(1, 1, 1, projection=ccrs.PlateCarree())
ax.set_extent([60, 130, 0, 50], crs=ccrs.PlateCarree())

cont = ax.contourf(lon_cut, lat_cut, precip_2mm_msk_cut_masked, alpha = 0.8, cmap = 'GnBu_r', hatches = '..')
ax.stock_img(alpha = 0.5)
#ax.coastlines()

ax.plot(115, 32, 'o', color = 'pink',  markersize = 7, transform = ccrs.PlateCarree())
#ax.text(115.90, 31, 'Hulu/Sanbao', transform = ccrs.PlateCarree(), weight = 'semibold')
#ax.text(115.90, 31, '1', transform = ccrs.PlateCarree(), weight = 'semibold')
ax.text(115, 33, '1', transform=ccrs.PlateCarree(), color = 'maroon', fontsize = 'large', weight = 'semibold')
    
    
ax.plot(62, 16.62, 'o', color = 'red', markersize = 7, transform = ccrs.PlateCarree())
#ax.text(59, 16, '722', transform = ccrs.PlateCarree(), weight = 'semibold')
#ax.text(59, 16, '2', transform = ccrs.PlateCarree(), weight = 'semibold')
ax.text(62, 17.2, '2', transform=ccrs.PlateCarree(), color = 'maroon', fontsize = 'large', weight = 'semibold')
 
ax.plot(90.35, 5.38, 'o', color = 'red', markersize = 7, transform = ccrs.PlateCarree())
#ax.text(90, 5, '758', transform = ccrs.PlateCarree(), weight = 'semibold') 
#ax.text(90, 5, '3', transform = ccrs.PlateCarree(), weight = 'semibold') 
ax.text(90.35, 6.3, '3', transform=ccrs.PlateCarree(), color = 'maroon', fontsize = 'large', weight = 'semibold')  
    
ax.plot(85.73, 19.08, 'o', color = 'red', markersize = 7, transform = ccrs.PlateCarree())
#ax.text(85, 18.9, ' U1446', transform = ccrs.PlateCarree(), weight = 'semibold')
#ax.text(85, 18.9, ' 4', transform = ccrs.PlateCarree(), weight = 'semibold')    
ax.text(85.73, 19.9, '4', transform=ccrs.PlateCarree(), color = 'brown', fontsize = 'large', weight = 'semibold')    

ax.plot(113.29, 9.36, 'o', color = 'red', markersize = 7, transform = ccrs.PlateCarree())
#ax.text(113, 9, '1443', transform = ccrs.PlateCarree(), weight = 'semibold')
#ax.text(85, 18.9, ' 5', transform = ccrs.PlateCarree(), weight = 'semibold')    
ax.text(113.29, 10.2, '5', transform=ccrs.PlateCarree(), color = 'maroon', fontsize = 'large', weight = 'semibold') 



ax.plot(82, 14.03, 'o', markersize = 7, color = 'gold', transform = ccrs.PlateCarree())
#ax.text(81.5, 13.99, 'SK218-1', transform = ccrs.PlateCarree(), weight = 'semibold')
#ax.text(81.5, 13.99, '6', transform = ccrs.PlateCarree(), weight = 'semibold')
ax.text(82, 14.7, '6', transform=ccrs.PlateCarree(),  color = 'maroon', fontsize = 'large', weight = 'semibold')

ax.plot(72.09, 9.01, 'o', markersize = 7, color = 'gold', transform = ccrs.PlateCarree())
#ax.text(71, 8.5, 'Tarique', transform = ccrs.PlateCarree(), weight = 'semibold')
#ax.text(71, 8.5, '7', transform = ccrs.PlateCarree(), weight = 'semibold')
ax.text(72.09, 9.3, '7', transform=ccrs.PlateCarree(), color = 'maroon', fontsize = 'large', weight = 'semibold')


ax.plot(117.42, 20.05, 'o', markersize = 7, color = 'gold', transform = ccrs.PlateCarree())
#ax.text(118, 21, '8', transform = ccrs.PlateCarree(), weight = 'semibold')
ax.text(117.42, 21.8, '8', transform=ccrs.PlateCarree(), color = 'maroon', fontsize = 'large', weight = 'semibold')



ax.plot(109.26, 35.47, 'o', markersize = 7, color = 'orange', transform = ccrs.PlateCarree()) #Luochuan
#ax.text(110, 35, 'Luochan & Xifeng Lu2019', transform = ccrs.PlateCarree(), weight = 'semibold')
#ax.text(110, 35, '9', transform = ccrs.PlateCarree(), weight = 'semibold')
ax.text(110, 36.2, '9', transform=ccrs.PlateCarree(),  color = 'maroon', fontsize = 'large', weight = 'semibold')


ax.plot(107.38, 35.42, 'o', markersize = 7, color = 'orange', transform = ccrs.PlateCarree()) #Luochuan
#ax.text(110, 35, 'Luochan & Xifeng Lu2019', transform = ccrs.PlateCarree(), weight = 'semibold')
#ax.text(107, 35, '10', transform = ccrs.PlateCarree(), weight = 'semibold')
ax.text(107.38, 36.2, '10', transform=ccrs.PlateCarree(),  color = 'maroon', fontsize = 'large', weight = 'semibold')


ax.plot(107.39, 35.04, 'o', markersize = 7, color = 'orange', transform = ccrs.PlateCarree())
#ax.text(104, 33, 'Lingtai MAAT', transform = ccrs.PlateCarree(), weight = 'semibold')
#ax.text(104, 33, '11', transform = ccrs.PlateCarree(), weight = 'semibold')
ax.text(107.39, 33.8, '11', transform=ccrs.PlateCarree(), color = 'maroon', fontsize = 'large', weight = 'semibold')


ax.add_feature(cfeature.LAND)
ax.add_feature(cfeature.COASTLINE)
gl = ax.gridlines(draw_labels=True)
gl.top_labels = False
gl.right_labels = False

plt.savefig('/user/work/xk22684/work/fig/fig_paper_monsoon/dom_rev.png')
plt.show()
plt.close()
'------------------------------------------------------------------------------'
