from __future__ import division

import numpy as np 
import matplotlib.pyplot as plt 
from scipy import stats 
import netCDF4 as nc 
import cartopy.crs as ccrs

import pycwt as wavelet
from pycwt.helpers import find

'-----------------------------------------------------------------------------------------------------------------------'
'LIST_SIMU'
'-----------------------------------------------------------------------------------------------------------------------'
list_triff5 = ['teikc',  'tebnn',  'tebnt',  'tebnl',  'tebnp',  'tebnr',  'teii91', 'tebnj',  'teii81', 'tebni',  'teii71', 'tebnh',  'teii61', 'tebng',  'teii51', 'tebnf',  'teii41', 'tebne',  'teii31', 'tebnd',  'teii21', 'tebnc',  'teii11', 'tebnb',  'teii01', 'tebna',  'teiiZ1', 'teiiY1', 'teiiX1', 'teiiW1', 'teiiV1', 'teiiU1', 'teiiT1', 'teiiS1', 'teiiR1', 'teiiQ1', 'teiiP1', 'teiiO1', 'teiiN1', 'teiiM1', 'teiiL1', 'teiiK1', 'teiiJ1', 'teiiI1', 'teiiH1', 'teiiG1', 'teiiF1', 'teiiE1', 'teiiD1', 'teiiC1', 'teiiB1', 'teiiA1', 'teiiz1', 'teiiy1', 'teiix1', 'teiiw1', 'teiiv1', 'teiiu1', 'teiit1', 'teiis1', 'teiir1', 'teiiq1', 'teiip1', 'teiio1', 'teiin1', 'teiim1', 'teiil1', 'teiik1', 'teiij1', 'teiii1', 'teiih1', 'teiig1', 'teiif1', 'teiie1', 'teiid1', 'teiic1', 'teiib1', 'teiia1']

list_timetriff = [140,     130,    128,    126,    124,    122,    120,    118,    116,    114,    112,    110,    108,    106,    104,    102,    100,    98,     96,     94,     92,     90,     88,     86,     84,     82,     80,     78,     76,     74,     72,     70,     68,     66,     64,     62,     60,     58,     56,     54,     52,     50,     48,     46,     44,     42,     40,     38,     36,     34,     32,     30,     28,     26,     24,     22,     21,     20,     19,     18,     17,     16,     15,    14,     13,     12,     11,     10,     9,      8,     7,      6,      5,      4,      3,      2,      1,      0]


list_simu_03 = ['teIXG', 'teIXF', 'teIXE', 'teIXD', 'teIXC', 'teIXB', 'teIXA', 'teIXz', 'teIXy', 'teIXx', 'teIXw', 'teIXv', 'teIXu',
 'teIXt', 'teIXs', 'teIXr', 'teIXq', 'teIXp', 'teIXo', 'teIXn' ,'teIXm', 'teIXl', 'teIXk' ,'teIXj' ,'teIXi', 'teIXh', 'teIXg', 'teIXf',
  'teIXe', 'teIXd', 'teIXc' ,'teIXb' ,'teIXa' ,'teIx9', 'teIx8', 'teIx7' ,'teIx6', 'teIx5', 'teIx4' ,'teIx3', 'teIx2', 'teIx1', 'teIx0',
  'teIxZ', 'teIxY', 'teIxX', 'teIxW', 'teIxV' ,'teIxU' ,'teIxT', 'teIxS', 'teIxR' ,'teIxQ' ,'teIxP', 'teIxO', 'teIxN' ,'teIxM', 'teIxL',
  'teIxK', 'teIxJ' ,'teIxI', 'teIxH' ,'teIxG', 'teIxF', 'teIxE', 'teIxD', 'teIxC' ,'teIxB', 'teIxA' ,'teIxz', 'teIxy', 'teIxx', 'teIxw', 
  'teIxv', 'teIxu', 'teIxt' ,'teIxs', 'teIxr', 'teIxq', 'teIxp', 'teIxo', 'teIxn', 'teIxm', 'teIxl' ,'teIxk' ,'teIxj' ,'teIxi', 'teIxh', 'teIxg',
  'teIxf', 'teIxe', 'teIxd', 'teIxc', 'teIxb' ,'teIxa' ,'teiX9', 'teiX8' ,'teiX7', 'teiX6', 'teiX5' ,'teiX4' ,'teiX3' ,'teiX2', 'teiX1', 'teiX0',
  'teiXZ', 'teiXY', 'teiXX', 'teiXW' ,'teiXV' ,'teiXU', 'teiXT', 'teiXS', 'teiXR', 'teiXQ', 'teiXP', 'teiXO', 'teiXN', 'teiXM', 'teiXL', 'teiXK',
  'teiXJ', 'teiXI', 'teiXH' ,'teiXG', 'teiXF' ,'teiXE', 'teiXD', 'teiXC', 'teiXB', 'teiXA', 'teiXz' ,'teiXy', 'teiXx', 'teiXw', 'teiXv' ,'teiXu',
  'teiXt', 'teiXs' ,'teiXr', 'teiXq', 'teiXp', 'teiXo', 'teiXn', 'teiXm', 'teiXl', 'teiXk', 'teiXj', 'teiXi', 'teiXh', 'teiXg', 'teiXf', 'teiXe',
  'teiXd', 'teiXc', 'teiXb', 'teiXa', 'teix9' ,'teix8' ,'teix7' ,'teix6', 'teix5', 'teix4', 'teix3', 'teix2', 'teix1', 'teix0', 'teixZ', 'teixY',
  'teixX', 'teixW', 'teixV', 'teixU' ,'teixT', 'teixS', 'teixR', 'teixQ', 'teixP' ,'teixO', 'teixN', 'teixM', 'teixL', 'teixK', 'teixJ', 'teixI',
  'teixH', 'teixG', 'teixF' ,'teixE' ,'teixD' ,'teixC', 'teixB', 'teixA', 'teixz' ,'teixy' ,'teixx', 'teixw', 'teixv', 'teixu', 'teixt', 'teixs',
  'teixr', 'teixq' ,'teixp' ,'teixo', 'teixn' ,'teixm', 'teixl', 'teixk', 'teixj', 'teixi', 'teixh', 'teixg', 'teixf', 'teixe', 'teixd', 'teixc',
   'teixb', 'teixa']


list_simu_04 = ['teVTG1', 'teVTF1', 'teVTE1', 'teVTD1', 'teVTC1', 'teVTB1', 'teVTA1', 'teVTz1', 'teVTy1','teVTx1','teVTw1', 
 'teVTv1', 'teVTu1', 'teVTt1', 'teVTs1', 'teVTr1', 'teVTq1', 'teVTp1', 'teVTo1', 'teVTn1', 'teVTm1',
'teVTl1', 'teVTk1', 'teVTj1', 'teVTi1', 'teVTh1', 'teVTg1', 'teVTf1', 'teVTe1', 'teVTd1', 'teVTc1', 'teVTb1', 'teVTa1', 
'teVt91', 'teVt81', 'teVt71', 'teVt61', 'teVt51',  'teVt41', 'teVt31', 'teVt21', 'teVt11', 'teVt01', 'teVtZ1',
 'teVtY1', 'teVtX1', 'teVtW1', 'teVtV1', 'teVtU1', 'teVtT1', 'teVtS1', 'teVtR1', 'teVtQ1', 'teVtP1', 'teVtO1', 'teVtN1', 
 'teVtM1', 'teVtL1', 'teVtK1', 'teVtJ1', 'teVtI1', 'teVtH1', 'teVtG1', 'teVtF1', 'teVtE1', 'teVtD1', 'teVtC1',
 'teVtB1', 'teVtA1', 'teVtz1', 'teVty1', 'teVtx1', 'teVtw1', 'teVtv1', 'teVtu1', 'teVtt1', 'teVts1', 'teVtr1',
'teVtq1', 'teVtp1', 'teVto1', 'teVtn1', 'teVtm1', 'teVtl1', 'teVtk1', 'teVtj1', 'teVti1', 'teVth1', 'teVtg1', 'teVtf1',
 'teVte1', 'teVtd1', 'teVtc1', 'teVtb1', 'teVta1', 'tevT91', 'tevT81', 'tevT71', 'tevT61', 'tevT51', 'tevT41',
'tevT31', 'tevT21', 'tevT11', 'tevT01', 'tevTZ1', 'tevTY1', 'tevTX1', 'tevTW1', 'tevTV1', 'tevTU1', 'tevTT1', 'tevTS1',
 'tevTR1', 'tevTQ1', 'tevTP1', 'tevTO1', 'tevTN1', 'tevTM1', 'tevTL1', 'tevTK1', 'tevTJ1', 'tevTI1', 'tevTH1',
 'tevTG1', 'tevTF1', 'tevTE1', 'tevTD1', 'tevTC1', 'tevTB1', 'tevTA1', 'tevTz1', 'tevTy1', 'tevTx1', 'tevTw1', 'tevTv1',
 'tevTu1', 'tevTt1', 'tevTs1', 'tevTr1', 'tevTq1', 'tevTp1', 'tevTo1', 'tevTn1', 'tevTm1', 'tevTl1', 'tevTk1',
 'tevTj1', 'tevTi1', 'tevTh1', 'tevTg1', 'tevTf1', 'tevTe1', 'tevTd1', 'tevTc1', 'tevTb1', 'tevTa1', 'tevt91', 
'tevt81', 'tevt71', 'tevt61', 'tevt51', 'tevt41', 'tevt31', 'tevt21', 'tevt11', 'tevt01', 'tevtZ1', 'tevtY1', 'tevtX1',
 'tevtW1','tevtV1', 'tevtU1', 'tevtT1', 'tevtS1', 'tevtR1', 'tevtQ1', 'tevtP1', 'tevtO1', 'tevtN1', 'tevtM1',
'tevtL1', 'tevtK1', 'tevtJ1', 'tevtI1', 'tevtH1', 'tevtG1', 'tevtF1', 'tevtE1', 'tevtD1', 'tevtC1', 'tevtB1', 'tevtA1',
 'tevtz1', 'tevty1', 'tevtx1', 'tevtw1', 'tevtv1', 'tevtu1', 'tevtt1', 'tevts1', 'tevtr1', 'tevtq1', 'tevtp1',
 'tevto1', 'tevtn1', 'tevtm1', 'tevtl1', 'tevtk1', 'tevtj1', 'tevti1', 'tevth1', 'tevtg1', 'tevtf1', 'tevte1', 'tevtd1',
 'tevtc1', 'tevtb1', 'tevta1']
 
 
list_simu_05 = ['teVUG', 'teVUF', 'teVUE', 'teVUD', 'teVUC', 'teVUB', 'teVUA', 'teVUz', 'teVUy', 'teVUx', 'teVUw', 'teVUv', 'teVUu', 'teVUt', 'teVUs', 'teVUr', 'teVUq',
 'teVUp', 'teVUo', 'teVUn', 'teVUm', 'teVUl', 'teVUk', 'teVUj', 'teVUi', 'teVUh', 'teVUg', 'teVUf', 'teVUe', 'teVUd', 'teVUc', 'teVUb', 'teVUa', 'teVu9', 'teVu8', 'teVu7',
 'teVu6', 'teVu5', 'teVu4', 'teVu3', 'teVu2', 'teVu1', 'teVu0', 'teVuZ', 'teVuY', 'teVuX', 'teVuW', 'teVuV', 'teVuU', 'teVuT', 'teVuS', 'teVuR', 'teVuQ', 'teVuP', 'teVuO',
 'teVuN', 'teVuM', 'teVuL', 'teVuK', 'teVuJ', 'teVuI', 'teVuH', 'teVuG', 'teVuF', 'teVuE', 'teVuD', 'teVuC', 'teVuB', 'teVuA', 'teVuz', 'teVuy', 'teVux', 'teVuw', 'teVuv',
 'teVuu', 'teVut', 'teVus', 'teVur', 'teVuq', 'teVup', 'teVuo', 'teVun', 'teVum', 'teVul', 'teVuk', 'teVuj', 'teVui', 'teVuh', 'teVug', 'teVuf', 'teVue', 'teVud', 'teVuc',
 'teVub', 'teVua', 'tevU9', 'tevU8', 'tevU7', 'tevU6', 'tevU5', 'tevU4', 'tevU3', 'tevU2', 'tevU1', 'tevU0', 'tevUZ', 'tevUY', 'tevUX', 'tevUW', 'tevUV', 'tevUU', 'tevUT',
 'tevUS', 'tevUR', 'tevUQ', 'tevUP', 'tevUO', 'tevUN', 'tevUM', 'tevUL', 'tevUK', 'tevUJ', 'tevUI', 'tevUH', 'tevUG', 'tevUF', 'tevUE', 'tevUD', 'tevUC', 'tevUB', 'tevUA',
 'tevUz', 'tevUy', 'tevUx', 'tevUw', 'tevUv', 'tevUu', 'tevUt', 'tevUs', 'tevUr', 'tevUq', 'tevUp', 'tevUo', 'tevUn', 'tevUm', 'tevUl', 'tevUk', 'tevUj', 'tevUi', 'tevUh',
 'tevUg', 'tevUf', 'tevUe', 'tevUd', 'tevUc','tevUb', 'tevUa', 'tevu9', 'tevu8', 'tevu7', 'tevu6', 'tevu5', 'tevu4', 'tevu3', 'tevu2', 'tevu1', 'tevu0', 'tevuZ', 'tevuY',
 'tevuX', 'tevuW', 'tevuV', 'tevuU', 'tevuT', 'tevuS', 'tevuR', 'tevuQ', 'tevuP', 'tevuO', 'tevuN', 'tevuM', 'tevuL', 'tevuK', 'tevuJ', 'tevuI', 'tevuH', 'tevuG', 'tevuF',
 'tevuE', 'tevuD', 'tevuC', 'tevuB', 'tevuA', 'tevuz', 'tevuy', 'tevux', 'tevuw', 'tevuv', 'tevuu', 'tevut', 'tevus', 'tevur', 'tevuq', 'tevup', 'tevuo', 'tevun', 'tevum',
 'tevul', 'tevuk', 'tevuj', 'tevui', 'tevuh', 'tevug', 'tevuf', 'tevue', 'tevud', 'tevuc', 'tevub', 'tevua']
 
 
list_simu_06 = ['teVVG', 'teVVF', 'teVVE', 'teVVD', 'teVVC', 'teVVB', 'teVVA' ,'teVVz', 'teVVy', 'teVVx', 'teVVw', 'teVVv', 'teVVu', 'teVVt', 'teVVs' ,'teVVr', 'teVVq', 
'teVVp' ,'teVVo', 'teVVn' ,'teVVm', 'teVVl' ,'teVVk' ,'teVVj', 'teVVi' ,'teVVh' ,'teVVg' ,'teVVf', 'teVVe', 'teVVd' ,'teVVc' ,'teVVb' ,'teVVa', 'teVv9', 'teVv8', 'teVv7',
 'teVv6' ,'teVv5', 'teVv4', 'teVv3', 'teVv2' ,'teVv1', 'teVv0' ,'teVvZ' ,'teVvY', 'teVvX', 'teVvW', 'teVvV' ,'teVvU' ,'teVvT' ,'teVvS', 'teVvR', 'teVvQ', 'teVvP', 'teVvO' ,
'teVvN' ,'teVvM' ,'teVvL' ,'teVvK' ,'teVvJ' ,'teVvI' ,'teVvH', 'teVvG' ,'teVvF' ,'teVvE', 'teVvD', 'teVvC' ,'teVvB' ,'teVvA', 'teVvz', 'teVvy', 'teVvx' ,'teVvw' ,'teVvv', 
'teVvu' ,'teVvt', 'teVvs', 'teVvr', 'teVvq' ,'teVvp' ,'teVvo' ,'teVvn' ,'teVvm', 'teVvl' ,'teVvk' ,'teVvj' ,'teVvi' ,'teVvh' ,'teVvg' ,'teVvf' ,'teVve' ,'teVvd',
'teVvc' ,'teVvb' ,'teVva' ,'tevV9', 'tevV8', 'tevV7', 'tevV6', 'tevV5', 'tevV4' ,'tevV3' ,'tevV2', 'tevV1' ,'tevV0' ,'tevVZ', 'tevVY' ,'tevVX', 'tevVW', 'tevVV' ,'tevVU',
 'tevVT' ,'tevVS', 'tevVR' ,'tevVQ', 'tevVP' ,'tevVO', 'tevVN' ,'tevVM', 'tevVL' ,'tevVK' ,'tevVJ' ,'tevVI', 'tevVH', 'tevVG' ,'tevVF', 'tevVE' ,'tevVD', 'tevVC' ,'tevVB', 
'tevVA', 'tevVz', 'tevVy', 'tevVx', 'tevVw', 'tevVv', 'tevVu', 'tevVt' ,'tevVs', 'tevVr', 'tevVq', 'tevVp', 'tevVo', 'tevVn', 'tevVm', 'tevVl', 'tevVk', 'tevVj', 'tevVi', 
'tevVh' ,'tevVg', 'tevVf', 'tevVe' ,'tevVd' ,'tevVc', 'tevVb', 'tevVa', 'tevv9', 'tevv8', 'tevv7', 'tevv6', 'tevv5', 'tevv4', 'tevv3', 'tevv2', 'tevv1', 'tevv0',
 'tevvZ' ,'tevvY', 'tevvX' ,'tevvW' ,'tevvV' ,'tevvU', 'tevvT', 'tevvS', 'tevvR', 'tevvQ', 'tevvP', 'tevvO', 'tevvN', 'tevvM', 'tevvL', 'tevvK', 'tevvJ', 'tevvI', 'tevvH', 'tevvG', 
'tevvF' ,'tevvE', 'tevvD', 'tevvC' ,'tevvB' ,'tevvA', 'tevvz', 'tevvy', 'tevvx', 'tevvw', 'tevvv' ,'tevvu', 'tevvt' ,'tevvs' ,'tevvr' ,'tevvq' ,'tevvp', 'tevvo',
'tevvn' ,'tevvm', 'tevvl' ,'tevvk' ,'tevvj', 'tevvi', 'tevvh', 'tevvg', 'tevvf' ,'tevve' ,'tevvd' ,'tevvc' ,'tevvb' ,'tevva']

list_simu_07 = ["tEWtY", 'tEWtX', 'tEWtW', 'tEWtV', 'tEWtU', 'tEWtT', 'tEWtS' ,'tEWtR' ,'tEWtQ', 'tEWtP', 'tEWtO', 'tEWtN', 'tEWtM', 'tEWtL', 'tEWtK', 'tEWtJ', 'tEWtI',
'tEWtH', 'tEWtG', 'tEWtF' ,'tEWtE' ,'tEWtD', 'tEWtC' ,'tEWtB', 'tEWtA', 'tEWtz' ,'tEWty', 'tEWtx', 'tEWtw' ,'tEWtv', 'tEWtu' ,'tEWtt' ,'tEWts' ,'tEWtr' ,'tEWtq' ,'tEWtp',
 'tEWto' ,'tEWtn', 'tEWtm', 'tEWtl', 'tEWtk' ,'tEWtj' ,'tEWti', 'tEWth' ,'tEWtg' ,'tEWtf' ,'tEWte' ,'tEWtd', 'tEWtc', 'tEWtb', 'tEWta', 'tEwT9' ,'tEwT8' ,'tEwT7' ,'tEwT6', 
 'tEwT5', 'tEwT4' ,'tEwT3' ,'tEwT2', 'tEwT1', 'tEwT0' ,'tEwTZ' ,'tEwTY' ,'tEwTX' ,'tEwTW', 'tEwTV', 'tEwTU', 'tEwTT' ,'tEwTS' ,'tEwTR' ,'tEwTQ' ,'tEwTP', 'tEwTO', 'tEwTN',
 'tEwTM', 'tEwTL' ,'tEwTK' ,'tEwTJ' ,'tEwTI' ,'tEwTH' ,'tEwTG' ,'tEwTF' ,'tEwTE' ,'tEwTD', 'tEwTC' ,'tEwTB' ,'tEwTA' ,'tEwTz', 'tEwTy' ,'tEwTx' ,'tEwTw', 'tEwTv' ,'tEwTu',
  'tEwTt', 'tEwTs', 'tEwTr' ,'tEwTq', 'tEwTp', 'tEwTo', 'tEwTn' ,'tEwTm' ,'tEwTl' ,'tEwTk', 'tEwTj', 'tEwTi' ,'tEwTh', 'tEwTg', 'tEwTf' ,'tEwTe' ,'tEwTd', 'tEwTc' ,'tEwTb',
   'tEwTa', 'tEwt9', 'tEwt8', 'tEwt7', 'tEwt6', 'tEwt5', 'tEwt4' ,'tEwt3' ,'tEwt2', 'tEwt1', 'tEwt0' ,'tEwtZ', 'tEwtY' ,'tEwtX', 'tEwtW' ,'tEwtV' ,'tEwtU' ,'tEwtT' ,'tEwtS',
   'tEwtR', 'tEwtQ' ,'tEwtP', 'tEwtO' ,'tEwtN' ,'tEwtM', 'tEwtL', 'tEwtK', 'tEwtJ', 'tEwtI' ,'tEwtH', 'tEwtG', 'tEwtF', 'tEwtE' ,'tEwtD' ,'tEwtC', 'tEwtB' ,'tEwtA' ,'tEwtz',
   'tEwty', 'tEwtx', 'tEwtw' ,'tEwtv' ,'tEwtu', 'tEwtt' ,'tEwts', 'tEwtr' ,'tEwtq' ,'tEwtp' ,'tEwto', 'tEwtn' ,'tEwtm' ,'tEwtl' ,'tEwtk', 'tEwtj' ,'tEwti' ,'tEwth', 'tEwtg',
  'tEwtf', 'tEwte' ,'tEwtd' ,'tEwtc' ,'tEwtb', 'tEwta', 'teWT9', 'teWT8' ,'teWT7', 'teWT6', 'teWT5' ,'teWT4' ,'teWT3' ,'teWT2', 'teWT1', 'teWT0', 'teWTZ', 'teWTY', 'teWTX',
  'teWTW', 'teWTV', 'teWTU', 'teWTT' ,'teWTS', 'teWTR' ,'teWTQ', 'teWTP', 'teWTO' ,'teWTN', 'teWTM' ,'teWTL' ,'teWTK' ,'teWTJ', 'teWTI', 'teWTH', 'teWTG', 'teWTF' ,'teWTE',
   'teWTD' ,'teWTC' ,'teWTB' ,'teWTA' ,'teWTz' ,'teWTy' ,'teWTx', 'teWTw', 'teWTv' ,'teWTu', 'teWTt', 'teWTs' ,'teWTr' ,'teWTq', 'teWTp', 'teWTo', 'teWTn', 'teWTm' ,'teWTl',
    'teWTk', 'teWTj' ,'teWTi', 'teWTh', 'teWTg', 'teWTf', 'teWTe', 'teWTd' ,'teWTc', 'teWTb' ,'teWTa', 'teWt9', 'teWt8' ,'teWt7', 'teWt6', 'teWt5' ,'teWt4', 'teWt3', 'teWt2',
    'teWt1', 'teWt0', 'teWtZ' ,'teWtY' ,'teWtX' ,'teWtW', 'teWtV' ,'teWtU', 'teWtT' ,'teWtS', 'teWtR', 'teWtQ', 'teWtP', 'teWtO', 'teWtN' ,'teWtM', 'teWtL', 'teWtK' ,'teWtJ',
    'teWtI', 'teWtH', 'teWtG', 'teWtF', 'teWtE', 'teWtD' ,'teWtC', 'teWtB', 'teWtA', 'teWtz', 'teWty', 'teWtx', 'teWtw' ,'teWtv', 'teWtu' ,'teWtt' ,'teWts', 'teWtr' ,'teWtq',
     'teWtp', 'teWto', 'teWtn', 'teWtm' ,'teWtl' ,'teWtk' ,'teWtj', 'teWti', 'teWth', 'teWtg' ,'teWtf', 'teWte', 'teWtd', 'teWtc', 'teWtb' ,'teWta', 'tewT9', 'tewT8' ,'tewT7',
      'tewT6', 'tewT5', 'tewT4', 'tewT3', 'tewT2', 'tewT1', 'tewT0' ,'tewTZ' ,'tewTY', 'tewTX', 'tewTW', 'tewTV', 'tewTU', 'tewTT', 'tewTS', 'tewTR' ,'tewTQ' ,'tewTP', 'tewTO',
     'tewTN', 'tewTM', 'tewTL', 'tewTK', 'tewTJ', 'tewTI', 'tewTH', 'tewTG' ,'tewTF' ,'tewTE', 'tewTD' ,'tewTC', 'tewTB', 'tewTA', 'tewTz', 'tewTy', 'tewTx' ,'tewTw' ,'tewTv',     
     'tewTu' ,'tewTt' ,'tewTs' ,'tewTr' ,'tewTq' ,'tewTp' ,'tewTo' ,'tewTn' ,'tewTm', 'tewTl' ,'tewTk' ,'tewTj' ,'tewTi' ,'tewTh' ,'tewTg', 'tewTf' ,'tewTe', 'tewTd', 'tewTc', 
     'tewTb', 'tewTa', 'tewt9' ,'tewt8', 'tewt7', 'tewt6', 'tewt5', 'tewt4' ,'tewt3', 'tewt2' ,'tewt1', 'tewt0' ,'tewtZ' ,'tewtY', 'tewtX', 'tewtW' ,'tewtV' ,'tewtU' ,'tewtT',
      'tewtS' ,'tewtR', 'tewtQ' ,'tewtP' ,'tewtO' ,'tewtN', 'tewtM', 'tewtL', 'tewtK', 'tewtJ', 'tewtI', 'tewtH' ,'tewtG', 'tewtF', 'tewtE', 'tewtD', 'tewtC', 'tewtB', 'tewtA',
     'tewtz', 'tewty', 'tewtx', 'tewtw', 'tewtv' ,'tewtu', 'tewtt', 'tewts', 'tewtr' ,'tewtq' ,'tewtp', 'tewto' ,'tewtn', 'tewtm', 'tewtl' ,'tewtk' ,'tewtj' ,'tewti', 'tewth',
      'tewtg', 'tewtf', 'tewte', 'tewtd', 'tewtc', 'tewtb', 'tewta', 'tEVT9', 'tEVT8' ,'tEVT7', 'tEVT6', 'tEVT5', 'tEVT4', 'tEVT3', 'tEVT2', 'tEVT1', 'tEVT0', 'tEVTZ', 'tEVTY', 
     'tEVTX', 'tEVTW' ,'tEVTV' ,'tEVTU' ,'tEVTT' ,'tEVTS' ,'tEVTR', 'tEVTQ', 'tEVTP', 'tEVTO', 'tEVTN', 'tEVTM', 'tEVTL', 'tEVTK', 'tEVTJ' ,'tEVTI', 'tEVTH', 'tEVTG', 'tEVTF',
     'tEVTE', 'tEVTD', 'tEVTC', 'tEVTB', 'tEVTA', 'tEVTz', 'tEVTy' ,'tEVTx' ,'tEVTw', 'tEVTv', 'tEVTu' ,'tEVTt', 'tEVTs' ,'tEVTr' ,'tEVTq', 'tEVTp', 'tEVTo', 'tEVTn', 'tEVTm',
      'tEVTl', 'tEVTk' ,'tEVTj', 'tEVTi', 'tEVTh', 'tEVTg' ,'tEVTf' ,'tEVTe', 'tEVTd' ,'tEVTc', 'tEVTb', 'tEVTa', 'tEVt9' ,'tEVt8' ,'tEVt7' ,'tEVt6', 'tEVt5', 'tEVt4' ,'tEVt3',
     'tEVt2', 'tEVt1' ,'tEVt0', 'tEVtZ', 'tEVtY', 'tEVtX', 'tEVtW', 'tEVtV', 'tEVtU', 'tEVtT', 'tEVtS', 'tEVtR', 'tEVtQ' ,'tEVtP', 'tEVtO', 'tEVtN', 'tEVtM' ,'tEVtL', 'tEVtK',
      'tEVtJ', 'tEVtI' ,'tEVtH', 'tEVtG', 'tEVtF', 'tEVtE', 'tEVtD' ,'tEVtC' ,'tEVtB' ,'tEVtA' ,'tEVtz', 'tEVty' ,'tEVtx', 'tEVtw', 'tEVtv', 'tEVtu', 'tEVtt' ,'tEVts', 'tEVtr',
     'tEVtq', 'tEVtp', 'tEVto', 'tEVtn', 'tEVtm' ,'tEVtl', 'tEVtk' ,'tEVtj' ,'tEVti' ,'tEVth' ,'tEVtg' ,'tEVtf', 'tEVte', 'tEVtd', 'tEVtc', 'tEVtb', 'tEVta' ,'tEvT9', 'tEvT8',
     'tEvT7', 'tEvT6', 'tEvT5', 'tEvT4', 'tEvT3', 'tEvT2', 'tEvT1', 'tEvT0', 'tEvTZ', 'tEvTY', 'tEvTX', 'tEvTW' ,'tEvTV', 'tEvTU', 'tEvTT', 'tEvTS', 'tEvTR', 'tEvTQ', 'tEvTP',
     'tEvTO', 'tEvTN', 'tEvTM', 'tEvTL', 'tEvTK', 'tEvTJ', 'tEvTI' ,'tEvTH', 'tEvTG', 'tEvTF', 'tEvTE', 'tEvTD' ,'tEvTC', 'tEvTB' ,'tEvTA', 'tEvTz' ,'tEvTy', 'tEvTx', 'tEvTw',
     'tEvTv', 'tEvTu', 'tEvTt' ,'tEvTs', 'tEvTr', 'tEvTq', 'tEvTp', 'tEvTo', 'tEvTn', 'tEvTm', 'tEvTl' ,'tEvTk' ,'tEvTj', 'tEvTi' ,'tEvTh' ,'tEvTg' ,'tEvTf', 'tEvTe', 'tEvTd',
    'tEvTc', 'tEvTb', 'tEvTa', 'tEvt9', 'tEvt8', 'tEvt7', 'tEvt6', 'tEvt5', 'tEvt4', 'tEvt3', 'tEvt2', 'tEvt1', 'tEvt0', 'tEvtZ' ,'tEvtY' ,'tEvtX', 'tEvtW' ,'tEvtV', 'tEvtU', 
    'tEvtT', 'tEvtS', 'tEvtR', 'tEvtQ', 'tEvtP' ,'tEvtO' ,'tEvtN', 'tEvtM', 'tEvtL', 'tEvtK', 'tEvtJ' ,'tEvtI', 'tEvtH', 'tEvtG' ,'tEvtF', 'tEvtE', 'tEvtD', 'tEvtC', 'tEvtB',
     'tEvtA', 'tEvtz' ,'tEvty', 'tEvtx', 'tEvtw', 'tEvtv', 'tEvtu', 'tEvtt' ,'tEvts', 'tEvtr', 'tEvtq', 'tEvtp', 'tEvto', 'tEvtn', 'tEvtm', 'tEvtl', 'tEvtk', 'tEvtj', 'tEvti',
      'tEvth', 'tEvtg', 'tEvtf' ,'tEvte' ,'tEvtd', 'tEvtc', 'tEvtb', 'tEvta' ,'teVT9', 'teVT8', 'teVT7', 'teVT6', 'teVT5', 'teVT4', 'teVT3', 'teVT2', 'teVT1', 'teVT0', 'teVTZ',
     'teVTY', 'teVTX', 'teVTW', 'teVTV', 'teVTU', 'teVTT', 'teVTS', 'teVTR', 'teVTQ', 'teVTP', 'teVTO', 'teVTN', 'teVTM', 'teVTL', 'teVTK', 'teVTJ', 'teVTI', 'teVTH', 'teVTG',
      'teVTF', 'teVTE', 'teVTD', 'teVTC', 'teVTB', 'teVTA', 'teVTz', 'teVTy', 'teVTx', 'teVTw' ,'teVTv', 'teVTu', 'teVTt', 'teVTs' ,'teVTr', 'teVTq' ,'teVTp', 'teVTo', 'teVTn' ,
      'teVTm', 'teVTl', 'teVTk', 'teVTj', 'teVTi', 'teVTh', 'teVTg', 'teVTf' ,'teVTe', 'teVTd' ,'teVTc', 'teVTb', 'teVTa', 'teVt9', 'teVt8' ,'teVt7' ,'teVt6', 'teVt5' ,'teVt4',
       'teVt3' ,'teVt2' ,'teVt1', 'teVt0', 'teVtZ' ,'teVtY', 'teVtX' ,'teVtW', 'teVtV' ,'teVtU', 'teVtT', 'teVtS' ,'teVtR' ,'teVtQ', 'teVtP', 'teVtO' ,'teVtN' ,'teVtM' ,'teVtL', 
       'teVtK', 'teVtJ', 'teVtI', 'teVtH', 'teVtG', 'teVtF', 'teVtE', 'teVtD' ,'teVtC', 'teVtB', 'teVtA', 'teVtz', 'teVty', 'teVtx', 'teVtw', 'teVtv' ,'teVtu' ,'teVtt' ,'teVts',
       'teVtr', 'teVtq' ,'teVtp', 'teVto' ,'teVtn', 'teVtm', 'teVtl', 'teVtk' ,'teVtj', 'teVti', 'teVth', 'teVtg', 'teVtf' ,'teVte', 'teVtd', 'teVtc' ,'teVtb', 'teVta', 'tevT9',
       'tevT8', 'tevT7', 'tevT6', 'tevT5', 'tevT4', 'tevT3', 'tevT2' ,'tevT1', 'tevT0', 'tevTZ' ,'tevTY', 'tevTX', 'tevTW', 'tevTV', 'tevTU', 'tevTT', 'tevTS', 'tevTR', 'tevTQ',
       'tevTP', 'tevTO', 'tevTN', 'tevTM', 'tevTL' ,'tevTK', 'tevTJ', 'tevTI', 'tevTH' ,'tevTG', 'tevTF', 'tevTE', 'tevTD' ,'tevTC', 'tevTB', 'tevTA' ,'tevTz', 'tevTy', 'tevTx',
       'tevTw', 'tevTv', 'tevTu', 'tevTt' ,'tevTs' ,'tevTr', 'tevTq' ,'tevTp', 'tevTo', 'tevTn', 'tevTm', 'tevTl', 'tevTk', 'tevTj', 'tevTi', 'tevTh', 'tevTg', 'tevTf', 'tevTe',       
       'tevTd' ,'tevTc', 'tevTb' ,'tevTa', 'tevt9', 'tevt8', 'tevt7' ,'tevt6' ,'tevt5', 'tevt4' ,'tevt3', 'tevt2' ,'tevt1', 'tevt0' ,'tevtZ', 'tevtY', 'tevtX', 'tevtW' ,'tevtV',
       'tevtU', 'tevtT' ,'tevtS' ,'tevtR', 'tevtQ' ,'tevtP', 'tevtO', 'tevtN', 'tevtM' ,'tevtL', 'tevtK', 'tevtJ', 'tevtI', 'tevtH' ,'tevtG', 'tevtF', 'tevtE', 'tevtD', 'tevtC',      
        'tevtB' ,'tevtA', 'tevtz' ,'tevty' ,'tevtx', 'tevtw', 'tevtv' ,'tevtu' ,'tevtt' ,'tevts', 'tevtr' ,'tevtq', 'tevtp', 'tevto', 'tevtn' ,'tevtm', 'tevtl', 'tevtk' ,'tevtj',
        'tevti', 'tevth', 'tevtg', 'tevtf', 'tevte' ,'tevtd', 'tevtc' ,'tevtb' ,"tevta"]
 

list_simu_08       = ["tfMCG", "tfMCF", "tfMCE", "tfMCD", "tfMCC", "tfMCB", "tfMCA", "tfMCz", "tfMCy", "tfMCx", "tfMCw", "tfMCv", "tfMCu", "tfMCt", "tfMCs", "tfMCr", "tfMCq", "tfMCp", "tfMCo", "tfMCn", "tfMCm", "tfMCl", "tfMCk", "tfMCj", "tfMCi", "tfMCh", "tfMCg", "tfMCf", "tfMCe", "tfMCd", "tfMCc", "tfMCb", "tfMCa", "tfMc9", "tfMc8", "tfMc7", "tfMc6", "tfMc5", "tfMc4", "tfMc3", "tfMc2", "tfMc1", "tfMc0", "tfMcZ", "tfMcY", "tfMcX", "tfMcW", "tfMcV", "tfMcU", "tfMcT", "tfMcS", "tfMcR", "tfMcQ", "tfMcP", "tfMcO", "tfMcN", "tfMcM", "tfMcL", "tfMcK", "tfMcJ", "tfMcI", "tfMcH", "tfMcG", "tfMcF", "tfMcE", "tfMcD", "tfMcC", "tfMcB", "tfMcA", "tfMcz", "tfMcy", "tfMcx", "tfMcw", "tfMcv", "tfMcu", "tfMct", "tfMcs", "tfMcr", "tfMcq", "tfMcp", "tfMco", "tfMcn", "tfMcm", "tfMcl", "tfMck", "tfMcj", "tfMci", "tfMch", "tfMcg", "tfMcf", "tfMce", "tfMcd", "tfMcc", "tfMcb", "tfMca", "tfmC9", "tfmC8", "tfmC7", "tfmC6", "tfmC5", "tfmC4", "tfmC3", "tfmC2", "tfmC1", "tfmC0", "tfmCZ", "tfmCY", "tfmCX", "tfmCW", "tfmCV", "tfmCU", "tfmCT", "tfmCS", "tfmCR", "tfmCQ", "tfmCP", "tfmCO", "tfmCN", "tfmCM", "tfmCL", "tfmCK", "tfmCJ", "tfmCI", "tfmCH", "tfmCG", "tfmCF", "tfmCE", "tfmCD", "tfmCC", "tfmCB", "tfmCA", "tfmCz", "tfmCy", "tfmCx", "tfmCw", "tfmCv", "tfmCu", "tfmCt", "tfmCs", "tfmCr", "tfmCq", "tfmCp", "tfmCo", "tfmCn", "tfmCm", "tfmCl", "tfmCk", "tfmCj", "tfmCi", "tfmCh", "tfmCg", "tfmCf", "tfmCe", "tfmCd", "tfmCc", "tfmCb", "tfmCa", "tfmc9", "tfmc8", "tfmc7", "tfmc6", "tfmc5", "tfmc4", "tfmc3", "tfmc2", "tfmc1", "tfmc0", "tfmcZ", "tfmcY", "tfmcX", "tfmcW", "tfmcV", "tfmcU", "tfmcT", "tfmcS", "tfmcR", "tfmcQ", "tfmcP", "tfmcO", "tfmcN", "tfmcM", "tfmcL", "tfmcK", "tfmcJ", "tfmcI", "tfmcH", "tfmcG", "tfmcF", "tfmcE", "tfmcD", "tfmcC", "tfmcB", "tfmcA", "tfmcz", "tfmcy", "tfmcx", "tfmcw", "tfmcv", "tfmcu", "tfmct", "tfmcs", "tfmcr", "tfmcq", "tfmcp", "tfmco", "tfmcn", "tfmcm", "tfmcl", "tfmck", "tfmcj", "tfmci", "tfmch", "tfmcg", "tfmcf", "tfmce", "tfmcd", "tfmcc", "tfmcb", "tfmca"]


list_simu_09       = ["tfMEG", "tfMEF", "tfMEE", "tfMED", "tfMEC", "tfMEB", "tfMEA", "tfMEz", "tfMEy", "tfMEx", "tfMEw", "tfMEv", "tfMEu", "tfMEt", "tfMEs", "tfMEr", "tfMEq", "tfMEp", "tfMEo", "tfMEn", "tfMEm", "tfMEl", "tfMEk", "tfMEj", "tfMEi", "tfMEh", "tfMEg", "tfMEf", "tfMEe", "tfMEd", "tfMEc", "tfMEb", "tfMEa", "tfMe9", "tfMe8", "tfMe7", "tfMe6", "tfMe5", "tfMe4", "tfMe3", "tfMe2", "tfMe1", "tfMe0", "tfMeZ", "tfMeY", "tfMeX", "tfMeW", "tfMeV", "tfMeU", "tfMeT", "tfMeS", "tfMeR", "tfMeQ", "tfMeP", "tfMeO", "tfMeN", "tfMeM", "tfMeL", "tfMeK", "tfMeJ", "tfMeI", "tfMeH", "tfMeG", "tfMeF", "tfMeE", "tfMeD", "tfMeC", "tfMeB", "tfMeA", "tfMez", "tfMey", "tfMex", "tfMew", "tfMev", "tfMeu", "tfMet", "tfMes", "tfMer", "tfMeq", "tfMep", "tfMeo", "tfMen", "tfMem", "tfMel", "tfMek", "tfMej", "tfMei", "tfMeh", "tfMeg", "tfMef", "tfMee", "tfMed", "tfMec", "tfMeb", "tfMea", "tfmE9", "tfmE8", "tfmE7", "tfmE6", "tfmE5", "tfmE4", "tfmE3", "tfmE2", "tfmE1", "tfmE0", "tfmEZ", "tfmEY", "tfmEX", "tfmEW", "tfmEV", "tfmEU", "tfmET", "tfmES", "tfmER", "tfmEQ", "tfmEP", "tfmEO", "tfmEN", "tfmEM", "tfmEL", "tfmEK", "tfmEJ", "tfmEI", "tfmEH", "tfmEG", "tfmEF", "tfmEE", "tfmED", "tfmEC", "tfmEB", "tfmEA", "tfmEz", "tfmEy", "tfmEx", "tfmEw", "tfmEv", "tfmEu", "tfmEt", "tfmEs", "tfmEr", "tfmEq", "tfmEp", "tfmEo", "tfmEn", "tfmEm", "tfmEl", "tfmEk", "tfmEj", "tfmEi", "tfmEh", "tfmEg", "tfmEf", "tfmEe", "tfmEd", "tfmEc", "tfmEb", "tfmEa", "tfme9", "tfme8", "tfme7", "tfme6", "tfme5", "tfme4", "tfme3", "tfme2", "tfme1", "tfme0", "tfmeZ", "tfmeY", "tfmeX", "tfmeW", "tfmeV", "tfmeU", "tfmeT", "tfmeS", "tfmeR", "tfmeQ", "tfmeP", "tfmeO", "tfmeN", "tfmeM", "tfmeL", "tfmeK", "tfmeJ", "tfmeI", "tfmeH", "tfmeG", "tfmeF", "tfmeE", "tfmeD", "tfmeC", "tfmeB", "tfmeA", "tfmez", "tfmey", "tfmex", "tfmew", "tfmev", "tfmeu", "tfmet", "tfmes", "tfmer", "tfmeq", "tfmep", "tfmeo", "tfmen", "tfmem", "tfmel", "tfmek", "tfmej", "tfmei", "tfmeh", "tfmeg", "tfmef", "tfmee", "tfmed", "tfmec", "tfmeb", "tfmea"]


list_simu_10       = ["tfMGG", "tfMGF", "tfMGE", "tfMGD", "tfMGC", "tfMGB", "tfMGA", "tfMGz", "tfMGy", "tfMGx", "tfMGw", "tfMGv", "tfMGu", "tfMGt", "tfMGs", "tfMGr", "tfMGq", "tfMGp", "tfMGo", "tfMGn", "tfMGm", "tfMGl", "tfMGk", "tfMGj", "tfMGi", "tfMGh", "tfMGg", "tfMGf", "tfMGe", "tfMGd", "tfMGc", "tfMGb", "tfMGa", "tfMg9", "tfMg8", "tfMg7", "tfMg6", "tfMg5", "tfMg4", "tfMg3", "tfMg2", "tfMg1", "tfMg0", "tfMgZ", "tfMgY", "tfMgX", "tfMgW", "tfMgV", "tfMgU", "tfMgT", "tfMgS", "tfMgR", "tfMgQ", "tfMgP", "tfMgO", "tfMgN", "tfMgM", "tfMgL", "tfMgK", "tfMgJ", "tfMgI", "tfMgH", "tfMgG", "tfMgF", "tfMgE", "tfMgD", "tfMgC", "tfMgB", "tfMgA", "tfMgz", "tfMgy", "tfMgx", "tfMgw", "tfMgv", "tfMgu", "tfMgt", "tfMgs", "tfMgr", "tfMgq", "tfMgp", "tfMgo", "tfMgn", "tfMgm", "tfMgl", "tfMgk", "tfMgj", "tfMgi", "tfMgh", "tfMgg", "tfMgf", "tfMge", "tfMgd", "tfMgc", "tfMgb", "tfMga", "tfmG9", "tfmG8", "tfmG7", "tfmG6", "tfmG5", "tfmG4", "tfmG3", "tfmG2", "tfmG1", "tfmG0", "tfmGZ", "tfmGY", "tfmGX", "tfmGW", "tfmGV", "tfmGU", "tfmGT", "tfmGS", "tfmGR", "tfmGQ", "tfmGP", "tfmGO", "tfmGN", "tfmGM", "tfmGL", "tfmGK", "tfmGJ", "tfmGI", "tfmGH", "tfmGG", "tfmGF", "tfmGE", "tfmGD", "tfmGC", "tfmGB", "tfmGA", "tfmGz", "tfmGy", "tfmGx", "tfmGw", "tfmGv", "tfmGu", "tfmGt", "tfmGs", "tfmGr", "tfmGq", "tfmGp", "tfmGo", "tfmGn", "tfmGm", "tfmGl", "tfmGk", "tfmGj", "tfmGi", "tfmGh", "tfmGg", "tfmGf", "tfmGe", "tfmGd", "tfmGc", "tfmGb", "tfmGa", "tfmg9", "tfmg8", "tfmg7", "tfmg6", "tfmg5", "tfmg4", "tfmg3", "tfmg2", "tfmg1", "tfmg0", "tfmgZ", "tfmgY", "tfmgX", "tfmgW", "tfmgV", "tfmgU", "tfmgT", "tfmgS", "tfmgR", "tfmgQ", "tfmgP", "tfmgO", "tfmgN", "tfmgM", "tfmgL", "tfmgK", "tfmgJ", "tfmgI", "tfmgH", "tfmgG", "tfmgF", "tfmgE", "tfmgD", "tfmgC", "tfmgB", "tfmgA", "tfmgz", "tfmgy", "tfmgx", "tfmgw", "tfmgv", "tfmgu", "tfmgt", "tfmgs", "tfmgr", "tfmgq", "tfmgp", "tfmgo", "tfmgn", "tfmgm", "tfmgl", "tfmgk", "tfmgj", "tfmgi", "tfmgh", "tfmgg", "tfmgf", "tfmge", "tfmgd", "tfmgc", "tfmgb", "tfmga"]

list_simu_11       = ["tFMdY", "tFMdX", "tFMdW", "tFMdV", "tFMdU", "tFMdT", "tFMdS", "tFMdR", "tFMdQ", "tFMdP", "tFMdO", "tFMdN", "tFMdM", "tFMdL", "tFMdK", "tFMdJ", "tFMdI", "tFMdH", "tFMdG", "tFMdF", "tFMdE", "tFMdD", "tFMdC", "tFMdB", "tFMdA", "tFMdz", "tFMdy", "tFMdx", "tFMdw", "tFMdv", "tFMdu", "tFMdt", "tFMds", "tFMdr", "tFMdq", "tFMdp", "tFMdo", "tFMdn", "tFMdm", "tFMdl", "tFMdk", "tFMdj", "tFMdi", "tFMdh", "tFMdg", "tFMdf", "tFMde", "tFMdd", "tFMdc", "tFMdb", "tFMda", "tFmD9", "tFmD8", "tFmD7", "tFmD6", "tFmD5", "tFmD4", "tFmD3", "tFmD2", "tFmD1", "tFmD0", "tFmDZ", "tFmDY", "tFmDX", "tFmDW", "tFmDV", "tFmDU", "tFmDT", "tFmDS", "tFmDR", "tFmDQ", "tFmDP", "tFmDO", "tFmDN", "tFmDM", "tFmDL", "tFmDK", "tFmDJ", "tFmDI", "tFmDH", "tFmDG", "tFmDF", "tFmDE", "tFmDD", "tFmDC", "tFmDB", "tFmDA", "tFmDz", "tFmDy", "tFmDx", "tFmDw", "tFmDv", "tFmDu", "tFmDt", "tFmDs", "tFmDr", "tFmDq", "tFmDp", "tFmDo", "tFmDn", "tFmDm", "tFmDl", "tFmDk", "tFmDj", "tFmDi", "tFmDh", "tFmDg", "tFmDf", "tFmDe", "tFmDd", "tFmDc", "tFmDb", "tFmDa", "tFmd9", "tFmd8", "tFmd7", "tFmd6", "tFmd5", "tFmd4", "tFmd3", "tFmd2", "tFmd1", "tFmd0", "tFmdZ", "tFmdY", "tFmdX", "tFmdW", "tFmdV", "tFmdU", "tFmdT", "tFmdS", "tFmdR", "tFmdQ", "tFmdP", "tFmdO", "tFmdN", "tFmdM", "tFmdL", "tFmdK", "tFmdJ", "tFmdI", "tFmdH", "tFmdG", "tFmdF", "tFmdE", "tFmdD", "tFmdC", "tFmdB", "tFmdA", "tFmdz", "tFmdy", "tFmdx", "tFmdw", "tFmdv", "tFmdu", "tFmdt", "tFmds", "tFmdr", "tFmdq", "tFmdp", "tFmdo", "tFmdn", "tFmdm", "tFmdl", "tFmdk", "tFmdj", "tFmdi", "tFmdh", "tFmdg", "tFmdf", "tFmde", "tFmdd", "tFmdc", "tFmdb", "tFmda", "tfMD9", "tfMD8", "tfMD7", "tfMD6", "tfMD5", "tfMD4", "tfMD3", "tfMD2", "tfMD1", "tfMD0", "tfMDZ", "tfMDY", "tfMDX", "tfMDW", "tfMDV", "tfMDU", "tfMDT", "tfMDS", "tfMDR", "tfMDQ", "tfMDP", "tfMDO", "tfMDN", "tfMDM", "tfMDL", "tfMDK", "tfMDJ", "tfMDI", "tfMDH", "tfMDG", "tfMDF", "tfMDE", "tfMDD", "tfMDC", "tfMDB", "tfMDA", "tfMDz", "tfMDy", "tfMDx", "tfMDw", "tfMDv", "tfMDu", "tfMDt", "tfMDs", "tfMDr", "tfMDq", "tfMDp", "tfMDo", "tfMDn", "tfMDm", "tfMDl", "tfMDk", "tfMDj", "tfMDi", "tfMDh", "tfMDg", "tfMDf", "tfMDe", "tfMDd", "tfMDc", "tfMDb", "tfMDa", "tfMd9", "tfMd8", "tfMd7", "tfMd6", "tfMd5", "tfMd4", "tfMd3", "tfMd2", "tfMd1", "tfMd0", "tfMdZ", "tfMdY", "tfMdX", "tfMdW", "tfMdV", "tfMdU", "tfMdT", "tfMdS", "tfMdR", "tfMdQ", "tfMdP", "tfMdO", "tfMdN", "tfMdM", "tfMdL", "tfMdK", "tfMdJ", "tfMdI", "tfMdH", "tfMdG", "tfMdF", "tfMdE", "tfMdD", "tfMdC", "tfMdB", "tfMdA", "tfMdz", "tfMdy", "tfMdx", "tfMdw", "tfMdv", "tfMdu", "tfMdt", "tfMds", "tfMdr", "tfMdq", "tfMdp", "tfMdo", "tfMdn", "tfMdm", "tfMdl", "tfMdk", "tfMdj", "tfMdi", "tfMdh", "tfMdg", "tfMdf", "tfMde", "tfMdd", "tfMdc", "tfMdb", "tfMda", "tfmD9", "tfmD8", "tfmD7", "tfmD6", "tfmD5", "tfmD4", "tfmD3", "tfmD2", "tfmD1", "tfmD0", "tfmDZ", "tfmDY", "tfmDX", "tfmDW", "tfmDV", "tfmDU", "tfmDT", "tfmDS", "tfmDR", "tfmDQ", "tfmDP", "tfmDO", "tfmDN", "tfmDM", "tfmDL", "tfmDK", "tfmDJ", "tfmDI", "tfmDH", "tfmDG", "tfmDF", "tfmDE", "tfmDD", "tfmDC", "tfmDB", "tfmDA", "tfmDz", "tfmDy", "tfmDx", "tfmDw", "tfmDv", "tfmDu", "tfmDt", "tfmDs", "tfmDr", "tfmDq", "tfmDp", "tfmDo", "tfmDn", "tfmDm", "tfmDl", "tfmDk", "tfmDj", "tfmDi", "tfmDh", "tfmDg", "tfmDf", "tfmDe", "tfmDd", "tfmDc", "tfmDb", "tfmDa", "tfmd9", "tfmd8", "tfmd7", "tfmd6", "tfmd5", "tfmd4", "tfmd3", "tfmd2", "tfmd1", "tfmd0", "tfmdZ", "tfmdY", "tfmdX", "tfmdW", "tfmdV", "tfmdU", "tfmdT", "tfmdS", "tfmdR", "tfmdQ", "tfmdP", "tfmdO", "tfmdN", "tfmdM", "tfmdL", "tfmdK", "tfmdJ", "tfmdI", "tfmdH", "tfmdG", "tfmdF", "tfmdE", "tfmdD", "tfmdC", "tfmdB", "tfmdA", "tfmdz", "tfmdy", "tfmdx", "tfmdw", "tfmdv", "tfmdu", "tfmdt", "tfmds", "tfmdr", "tfmdq", "tfmdp", "tfmdo", "tfmdn", "tfmdm", "tfmdl", "tfmdk", "tfmdj", "tfmdi", "tfmdh", "tfmdg", "tfmdf", "tfmde", "tfmdd", "tfmdc", "tfmdb", "tfmda", "tFMC9", "tFMC8", "tFMC7", "tFMC6", "tFMC5", "tFMC4", "tFMC3", "tFMC2", "tFMC1", "tFMC0", "tFMCZ", "tFMCY", "tFMCX", "tFMCW", "tFMCV", "tFMCU", "tFMCT", "tFMCS", "tFMCR", "tFMCQ", "tFMCP", "tFMCO", "tFMCN", "tFMCM", "tFMCL", "tFMCK", "tFMCJ", "tFMCI", "tFMCH", "tFMCG", "tFMCF", "tFMCE", "tFMCD", "tFMCC", "tFMCB", "tFMCA", "tFMCz", "tFMCy", "tFMCx", "tFMCw", "tFMCv", "tFMCu", "tFMCt", "tFMCs", "tFMCr", "tFMCq", "tFMCp", "tFMCo", "tFMCn", "tFMCm", "tFMCl", "tFMCk", "tFMCj", "tFMCi", "tFMCh", "tFMCg", "tFMCf", "tFMCe", "tFMCd", "tFMCc", "tFMCb", "tFMCa", "tFMc9", "tFMc8", "tFMc7", "tFMc6", "tFMc5", "tFMc4", "tFMc3", "tFMc2", "tFMc1", "tFMc0", "tFMcZ", "tFMcY", "tFMcX", "tFMcW", "tFMcV", "tFMcU", "tFMcT", "tFMcS", "tFMcR", "tFMcQ", "tFMcP", "tFMcO", "tFMcN", "tFMcM", "tFMcL", "tFMcK", "tFMcJ", "tFMcI", "tFMcH", "tFMcG", "tFMcF", "tFMcE", "tFMcD", "tFMcC", "tFMcB", "tFMcA", "tFMcz", "tFMcy", "tFMcx", "tFMcw", "tFMcv", "tFMcu", "tFMct", "tFMcs", "tFMcr", "tFMcq", "tFMcp", "tFMco", "tFMcn", "tFMcm", "tFMcl", "tFMck", "tFMcj", "tFMci", "tFMch", "tFMcg", "tFMcf", "tFMce", "tFMcd", "tFMcc", "tFMcb", "tFMca", "tFmC9", "tFmC8", "tFmC7", "tFmC6", "tFmC5", "tFmC4", "tFmC3", "tFmC2", "tFmC1", "tFmC0", "tFmCZ", "tFmCY", "tFmCX", "tFmCW", "tFmCV", "tFmCU", "tFmCT", "tFmCS", "tFmCR", "tFmCQ", "tFmCP", "tFmCO", "tFmCN", "tFmCM", "tFmCL", "tFmCK", "tFmCJ", "tFmCI", "tFmCH", "tFmCG", "tFmCF", "tFmCE", "tFmCD", "tFmCC", "tFmCB", "tFmCA", "tFmCz", "tFmCy", "tFmCx", "tFmCw", "tFmCv", "tFmCu", "tFmCt", "tFmCs", "tFmCr", "tFmCq", "tFmCp", "tFmCo", "tFmCn", "tFmCm", "tFmCl", "tFmCk", "tFmCj", "tFmCi", "tFmCh", "tFmCg", "tFmCf", "tFmCe", "tFmCd", "tFmCc", "tFmCb", "tFmCa", "tFmc9", "tFmc8", "tFmc7", "tFmc6", "tFmc5", "tFmc4", "tFmc3", "tFmc2", "tFmc1", "tFmc0", "tFmcZ", "tFmcY", "tFmcX", "tFmcW", "tFmcV", "tFmcU", "tFmcT", "tFmcS", "tFmcR", "tFmcQ", "tFmcP", "tFmcO", "tFmcN", "tFmcM", "tFmcL", "tFmcK", "tFmcJ", "tFmcI", "tFmcH", "tFmcG", "tFmcF", "tFmcE", "tFmcD", "tFmcC", "tFmcB", "tFmcA", "tFmcz", "tFmcy", "tFmcx", "tFmcw", "tFmcv", "tFmcu", "tFmct", "tFmcs", "tFmcr", "tFmcq", "tFmcp", "tFmco", "tFmcn", "tFmcm", "tFmcl", "tFmck", "tFmcj", "tFmci", "tFmch", "tFmcg", "tFmcf", "tFmce", "tFmcd", "tFmcc", "tFmcb", "tFmca", "tfMC9", "tfMC8", "tfMC7", "tfMC6", "tfMC5", "tfMC4", "tfMC3", "tfMC2", "tfMC1", "tfMC0", "tfMCZ", "tfMCY", "tfMCX", "tfMCW", "tfMCV", "tfMCU", "tfMCT", "tfMCS", "tfMCR", "tfMCQ", "tfMCP", "tfMCO", "tfMCN", "tfMCM", "tfMCL", "tfMCK", "tfMCJ", "tfMCI", "tfMCH", "tfMCG", "tfMCF", "tfMCE", "tfMCD", "tfMCC", "tfMCB", "tfMCA", "tfMCz", "tfMCy", "tfMCx", "tfMCw", "tfMCv", "tfMCu", "tfMCt", "tfMCs", "tfMCr", "tfMCq", "tfMCp", "tfMCo", "tfMCn", "tfMCm", "tfMCl", "tfMCk", "tfMCj", "tfMCi", "tfMCh", "tfMCg", "tfMCf", "tfMCe", "tfMCd", "tfMCc", "tfMCb", "tfMCa", "tfMc9", "tfMc8", "tfMc7", "tfMc6", "tfMc5", "tfMc4", "tfMc3", "tfMc2", "tfMc1", "tfMc0", "tfMcZ", "tfMcY", "tfMcX", "tfMcW", "tfMcV", "tfMcU", "tfMcT", "tfMcS", "tfMcR", "tfMcQ", "tfMcP", "tfMcO", "tfMcN", "tfMcM", "tfMcL", "tfMcK", "tfMcJ", "tfMcI", "tfMcH", "tfMcG", "tfMcF", "tfMcE", "tfMcD", "tfMcC", "tfMcB", "tfMcA", "tfMcz", "tfMcy", "tfMcx", "tfMcw", "tfMcv", "tfMcu", "tfMct", "tfMcs", "tfMcr", "tfMcq", "tfMcp", "tfMco", "tfMcn", "tfMcm", "tfMcl", "tfMck", "tfMcj", "tfMci", "tfMch", "tfMcg", "tfMcf", "tfMce", "tfMcd", "tfMcc", "tfMcb", "tfMca", "tfmC9", "tfmC8", "tfmC7", "tfmC6", "tfmC5", "tfmC4", "tfmC3", "tfmC2", "tfmC1", "tfmC0", "tfmCZ", "tfmCY", "tfmCX", "tfmCW", "tfmCV", "tfmCU", "tfmCT", "tfmCS", "tfmCR", "tfmCQ", "tfmCP", "tfmCO", "tfmCN", "tfmCM", "tfmCL", "tfmCK", "tfmCJ", "tfmCI", "tfmCH", "tfmCG", "tfmCF", "tfmCE", "tfmCD", "tfmCC", "tfmCB", "tfmCA", "tfmCz", "tfmCy", "tfmCx", "tfmCw", "tfmCv", "tfmCu", "tfmCt", "tfmCs", "tfmCr", "tfmCq", "tfmCp", "tfmCo", "tfmCn", "tfmCm", "tfmCl", "tfmCk", "tfmCj", "tfmCi", "tfmCh", "tfmCg", "tfmCf", "tfmCe", "tfmCd", "tfmCc", "tfmCb", "tfmCa", "tfmc9", "tfmc8", "tfmc7", "tfmc6", "tfmc5", "tfmc4", "tfmc3", "tfmc2", "tfmc1", "tfmc0", "tfmcZ", "tfmcY", "tfmcX", "tfmcW", "tfmcV", "tfmcU", "tfmcT", "tfmcS", "tfmcR", "tfmcQ", "tfmcP", "tfmcO", "tfmcN", "tfmcM", "tfmcL", "tfmcK", "tfmcJ", "tfmcI", "tfmcH", "tfmcG", "tfmcF", "tfmcE", "tfmcD", "tfmcC", "tfmcB", "tfmcA", "tfmcz", "tfmcy", "tfmcx", "tfmcw", "tfmcv", "tfmcu", "tfmct", "tfmcs", "tfmcr", "tfmcq", "tfmcp", "tfmco", "tfmcn", "tfmcm", "tfmcl", "tfmck", "tfmcj", "tfmci", "tfmch", "tfmcg", "tfmcf", "tfmce", "tfmcd", "tfmcc", "tfmcb", "tfmca"]

list_simu_12       = ["tFMfY", "tFMfX", "tFMfW", "tFMfV", "tFMfU", "tFMfT", "tFMfS", "tFMfR", "tFMfQ", "tFMfP", "tFMfO", "tFMfN", "tFMfM", "tFMfL", "tFMfK", "tFMfJ", "tFMfI", "tFMfH", "tFMfG", "tFMfF", "tFMfE", "tFMfD", "tFMfC", "tFMfB", "tFMfA", "tFMfz", "tFMfy", "tFMfx", "tFMfw", "tFMfv", "tFMfu", "tFMft", "tFMfs", "tFMfr", "tFMfq", "tFMfp", "tFMfo", "tFMfn", "tFMfm", "tFMfl", "tFMfk", "tFMfj", "tFMfi", "tFMfh", "tFMfg", "tFMff", "tFMfe", "tFMfd", "tFMfc", "tFMfb", "tFMfa", "tFmF9", "tFmF8", "tFmF7", "tFmF6", "tFmF5", "tFmF4", "tFmF3", "tFmF2", "tFmF1", "tFmF0", "tFmFZ", "tFmFY", "tFmFX", "tFmFW", "tFmFV", "tFmFU", "tFmFT", "tFmFS", "tFmFR", "tFmFQ", "tFmFP", "tFmFO", "tFmFN", "tFmFM", "tFmFL", "tFmFK", "tFmFJ", "tFmFI", "tFmFH", "tFmFG", "tFmFF", "tFmFE", "tFmFD", "tFmFC", "tFmFB", "tFmFA", "tFmFz", "tFmFy", "tFmFx", "tFmFw", "tFmFv", "tFmFu", "tFmFt", "tFmFs", "tFmFr", "tFmFq", "tFmFp", "tFmFo", "tFmFn", "tFmFm", "tFmFl", "tFmFk", "tFmFj", "tFmFi", "tFmFh", "tFmFg", "tFmFf", "tFmFe", "tFmFd", "tFmFc", "tFmFb", "tFmFa", "tFmf9", "tFmf8", "tFmf7", "tFmf6", "tFmf5", "tFmf4", "tFmf3", "tFmf2", "tFmf1", "tFmf0", "tFmfZ", "tFmfY", "tFmfX", "tFmfW", "tFmfV", "tFmfU", "tFmfT", "tFmfS", "tFmfR", "tFmfQ", "tFmfP", "tFmfO", "tFmfN", "tFmfM", "tFmfL", "tFmfK", "tFmfJ", "tFmfI", "tFmfH", "tFmfG", "tFmfF", "tFmfE", "tFmfD", "tFmfC", "tFmfB", "tFmfA", "tFmfz", "tFmfy", "tFmfx", "tFmfw", "tFmfv", "tFmfu", "tFmft", "tFmfs", "tFmfr", "tFmfq", "tFmfp", "tFmfo", "tFmfn", "tFmfm", "tFmfl", "tFmfk", "tFmfj", "tFmfi", "tFmfh", "tFmfg", "tFmff", "tFmfe", "tFmfd", "tFmfc", "tFmfb", "tFmfa", "tfMF9", "tfMF8", "tfMF7", "tfMF6", "tfMF5", "tfMF4", "tfMF3", "tfMF2", "tfMF1", "tfMF0", "tfMFZ", "tfMFY", "tfMFX", "tfMFW", "tfMFV", "tfMFU", "tfMFT", "tfMFS", "tfMFR", "tfMFQ", "tfMFP", "tfMFO", "tfMFN", "tfMFM", "tfMFL", "tfMFK", "tfMFJ", "tfMFI", "tfMFH", "tfMFG", "tfMFF", "tfMFE", "tfMFD", "tfMFC", "tfMFB", "tfMFA", "tfMFz", "tfMFy", "tfMFx", "tfMFw", "tfMFv", "tfMFu", "tfMFt", "tfMFs", "tfMFr", "tfMFq", "tfMFp", "tfMFo", "tfMFn", "tfMFm", "tfMFl", "tfMFk", "tfMFj", "tfMFi", "tfMFh", "tfMFg", "tfMFf", "tfMFe", "tfMFd", "tfMFc", "tfMFb", "tfMFa", "tfMf9", "tfMf8", "tfMf7", "tfMf6", "tfMf5", "tfMf4", "tfMf3", "tfMf2", "tfMf1", "tfMf0", "tfMfZ", "tfMfY", "tfMfX", "tfMfW", "tfMfV", "tfMfU", "tfMfT", "tfMfS", "tfMfR", "tfMfQ", "tfMfP", "tfMfO", "tfMfN", "tfMfM", "tfMfL", "tfMfK", "tfMfJ", "tfMfI", "tfMfH", "tfMfG", "tfMfF", "tfMfE", "tfMfD", "tfMfC", "tfMfB", "tfMfA", "tfMfz", "tfMfy", "tfMfx", "tfMfw", "tfMfv", "tfMfu", "tfMft", "tfMfs", "tfMfr", "tfMfq", "tfMfp", "tfMfo", "tfMfn", "tfMfm", "tfMfl", "tfMfk", "tfMfj", "tfMfi", "tfMfh", "tfMfg", "tfMff", "tfMfe", "tfMfd", "tfMfc", "tfMfb", "tfMfa", "tfmF9", "tfmF8", "tfmF7", "tfmF6", "tfmF5", "tfmF4", "tfmF3", "tfmF2", "tfmF1", "tfmF0", "tfmFZ", "tfmFY", "tfmFX", "tfmFW", "tfmFV", "tfmFU", "tfmFT", "tfmFS", "tfmFR", "tfmFQ", "tfmFP", "tfmFO", "tfmFN", "tfmFM", "tfmFL", "tfmFK", "tfmFJ", "tfmFI", "tfmFH", "tfmFG", "tfmFF", "tfmFE", "tfmFD", "tfmFC", "tfmFB", "tfmFA", "tfmFz", "tfmFy", "tfmFx", "tfmFw", "tfmFv", "tfmFu", "tfmFt", "tfmFs", "tfmFr", "tfmFq", "tfmFp", "tfmFo", "tfmFn", "tfmFm", "tfmFl", "tfmFk", "tfmFj", "tfmFi", "tfmFh", "tfmFg", "tfmFf", "tfmFe", "tfmFd", "tfmFc", "tfmFb", "tfmFa", "tfmf9", "tfmf8", "tfmf7", "tfmf6", "tfmf5", "tfmf4", "tfmf3", "tfmf2", "tfmf1", "tfmf0", "tfmfZ", "tfmfY", "tfmfX", "tfmfW", "tfmfV", "tfmfU", "tfmfT", "tfmfS", "tfmfR", "tfmfQ", "tfmfP", "tfmfO", "tfmfN", "tfmfM", "tfmfL", "tfmfK", "tfmfJ", "tfmfI", "tfmfH", "tfmfG", "tfmfF", "tfmfE", "tfmfD", "tfmfC", "tfmfB", "tfmfA", "tfmfz", "tfmfy", "tfmfx", "tfmfw", "tfmfv", "tfmfu", "tfmft", "tfmfs", "tfmfr", "tfmfq", "tfmfp", "tfmfo", "tfmfn", "tfmfm", "tfmfl", "tfmfk", "tfmfj", "tfmfi", "tfmfh", "tfmfg", "tfmff", "tfmfe", "tfmfd", "tfmfc", "tfmfb", "tfmfa", "tFME9", "tFME8", "tFME7", "tFME6", "tFME5", "tFME4", "tFME3", "tFME2", "tFME1", "tFME0", "tFMEZ", "tFMEY", "tFMEX", "tFMEW", "tFMEV", "tFMEU", "tFMET", "tFMES", "tFMER", "tFMEQ", "tFMEP", "tFMEO", "tFMEN", "tFMEM", "tFMEL", "tFMEK", "tFMEJ", "tFMEI", "tFMEH", "tFMEG", "tFMEF", "tFMEE", "tFMED", "tFMEC", "tFMEB", "tFMEA", "tFMEz", "tFMEy", "tFMEx", "tFMEw", "tFMEv", "tFMEu", "tFMEt", "tFMEs", "tFMEr", "tFMEq", "tFMEp", "tFMEo", "tFMEn", "tFMEm", "tFMEl", "tFMEk", "tFMEj", "tFMEi", "tFMEh", "tFMEg", "tFMEf", "tFMEe", "tFMEd", "tFMEc", "tFMEb", "tFMEa", "tFMe9", "tFMe8", "tFMe7", "tFMe6", "tFMe5", "tFMe4", "tFMe3", "tFMe2", "tFMe1", "tFMe0", "tFMeZ", "tFMeY", "tFMeX", "tFMeW", "tFMeV", "tFMeU", "tFMeT", "tFMeS", "tFMeR", "tFMeQ", "tFMeP", "tFMeO", "tFMeN", "tFMeM", "tFMeL", "tFMeK", "tFMeJ", "tFMeI", "tFMeH", "tFMeG", "tFMeF", "tFMeE", "tFMeD", "tFMeC", "tFMeB", "tFMeA", "tFMez", "tFMey", "tFMex", "tFMew", "tFMev", "tFMeu", "tFMet", "tFMes", "tFMer", "tFMeq", "tFMep", "tFMeo", "tFMen", "tFMem", "tFMel", "tFMek", "tFMej", "tFMei", "tFMeh", "tFMeg", "tFMef", "tFMee", "tFMed", "tFMec", "tFMeb", "tFMea", "tFmE9", "tFmE8", "tFmE7", "tFmE6", "tFmE5", "tFmE4", "tFmE3", "tFmE2", "tFmE1", "tFmE0", "tFmEZ", "tFmEY", "tFmEX", "tFmEW", "tFmEV", "tFmEU", "tFmET", "tFmES", "tFmER", "tFmEQ", "tFmEP", "tFmEO", "tFmEN", "tFmEM", "tFmEL", "tFmEK", "tFmEJ", "tFmEI", "tFmEH", "tFmEG", "tFmEF", "tFmEE", "tFmED", "tFmEC", "tFmEB", "tFmEA", "tFmEz", "tFmEy", "tFmEx", "tFmEw", "tFmEv", "tFmEu", "tFmEt", "tFmEs", "tFmEr", "tFmEq", "tFmEp", "tFmEo", "tFmEn", "tFmEm", "tFmEl", "tFmEk", "tFmEj", "tFmEi", "tFmEh", "tFmEg", "tFmEf", "tFmEe", "tFmEd", "tFmEc", "tFmEb", "tFmEa", "tFme9", "tFme8", "tFme7", "tFme6", "tFme5", "tFme4", "tFme3", "tFme2", "tFme1", "tFme0", "tFmeZ", "tFmeY", "tFmeX", "tFmeW", "tFmeV", "tFmeU", "tFmeT", "tFmeS", "tFmeR", "tFmeQ", "tFmeP", "tFmeO", "tFmeN", "tFmeM", "tFmeL", "tFmeK", "tFmeJ", "tFmeI", "tFmeH", "tFmeG", "tFmeF", "tFmeE", "tFmeD", "tFmeC", "tFmeB", "tFmeA", "tFmez", "tFmey", "tFmex", "tFmew", "tFmev", "tFmeu", "tFmet", "tFmes", "tFmer", "tFmeq", "tFmep", "tFmeo", "tFmen", "tFmem", "tFmel", "tFmek", "tFmej", "tFmei", "tFmeh", "tFmeg", "tFmef", "tFmee", "tFmed", "tFmec", "tFmeb", "tFmea", "tfME9", "tfME8", "tfME7", "tfME6", "tfME5", "tfME4", "tfME3", "tfME2", "tfME1", "tfME0", "tfMEZ", "tfMEY", "tfMEX", "tfMEW", "tfMEV", "tfMEU", "tfMET", "tfMES", "tfMER", "tfMEQ", "tfMEP", "tfMEO", "tfMEN", "tfMEM", "tfMEL", "tfMEK", "tfMEJ", "tfMEI", "tfMEH", "tfMEG", "tfMEF", "tfMEE", "tfMED", "tfMEC", "tfMEB", "tfMEA", "tfMEz", "tfMEy", "tfMEx", "tfMEw", "tfMEv", "tfMEu", "tfMEt", "tfMEs", "tfMEr", "tfMEq", "tfMEp", "tfMEo", "tfMEn", "tfMEm", "tfMEl", "tfMEk", "tfMEj", "tfMEi", "tfMEh", "tfMEg", "tfMEf", "tfMEe", "tfMEd", "tfMEc", "tfMEb", "tfMEa", "tfMe9", "tfMe8", "tfMe7", "tfMe6", "tfMe5", "tfMe4", "tfMe3", "tfMe2", "tfMe1", "tfMe0", "tfMeZ", "tfMeY", "tfMeX", "tfMeW", "tfMeV", "tfMeU", "tfMeT", "tfMeS", "tfMeR", "tfMeQ", "tfMeP", "tfMeO", "tfMeN", "tfMeM", "tfMeL", "tfMeK", "tfMeJ", "tfMeI", "tfMeH", "tfMeG", "tfMeF", "tfMeE", "tfMeD", "tfMeC", "tfMeB", "tfMeA", "tfMez", "tfMey", "tfMex", "tfMew", "tfMev", "tfMeu", "tfMet", "tfMes", "tfMer", "tfMeq", "tfMep", "tfMeo", "tfMen", "tfMem", "tfMel", "tfMek", "tfMej", "tfMei", "tfMeh", "tfMeg", "tfMef", "tfMee", "tfMed", "tfMec", "tfMeb", "tfMea", "tfmE9", "tfmE8", "tfmE7", "tfmE6", "tfmE5", "tfmE4", "tfmE3", "tfmE2", "tfmE1", "tfmE0", "tfmEZ", "tfmEY", "tfmEX", "tfmEW", "tfmEV", "tfmEU", "tfmET", "tfmES", "tfmER", "tfmEQ", "tfmEP", "tfmEO", "tfmEN", "tfmEM", "tfmEL", "tfmEK", "tfmEJ", "tfmEI", "tfmEH", "tfmEG", "tfmEF", "tfmEE", "tfmED", "tfmEC", "tfmEB", "tfmEA", "tfmEz", "tfmEy", "tfmEx", "tfmEw", "tfmEv", "tfmEu", "tfmEt", "tfmEs", "tfmEr", "tfmEq", "tfmEp", "tfmEo", "tfmEn", "tfmEm", "tfmEl", "tfmEk", "tfmEj", "tfmEi", "tfmEh", "tfmEg", "tfmEf", "tfmEe", "tfmEd", "tfmEc", "tfmEb", "tfmEa", "tfme9", "tfme8", "tfme7", "tfme6", "tfme5", "tfme4", "tfme3", "tfme2", "tfme1", "tfme0", "tfmeZ", "tfmeY", "tfmeX", "tfmeW", "tfmeV", "tfmeU", "tfmeT", "tfmeS", "tfmeR", "tfmeQ", "tfmeP", "tfmeO", "tfmeN", "tfmeM", "tfmeL", "tfmeK", "tfmeJ", "tfmeI", "tfmeH", "tfmeG", "tfmeF", "tfmeE", "tfmeD", "tfmeC", "tfmeB", "tfmeA", "tfmez", "tfmey", "tfmex", "tfmew", "tfmev", "tfmeu", "tfmet", "tfmes", "tfmer", "tfmeq", "tfmep", "tfmeo", "tfmen", "tfmem", "tfmel", "tfmek", "tfmej", "tfmei", "tfmeh", "tfmeg", "tfmef", "tfmee", "tfmed", "tfmec", "tfmeb", "tfmea"]

list_simu_13       = ["tFMhY", "tFMhX", "tFMhW", "tFMhV", "tFMhU", "tFMhT", "tFMhS", "tFMhR", "tFMhQ", "tFMhP", "tFMhO", "tFMhN", "tFMhM", "tFMhL", "tFMhK", "tFMhJ", "tFMhI", "tFMhH", "tFMhG", "tFMhF", "tFMhE", "tFMhD", "tFMhC", "tFMhB", "tFMhA", "tFMhz", "tFMhy", "tFMhx", "tFMhw", "tFMhv", "tFMhu", "tFMht", "tFMhs", "tFMhr", "tFMhq", "tFMhp", "tFMho", "tFMhn", "tFMhm", "tFMhl", "tFMhk", "tFMhj", "tFMhi", "tFMhh", "tFMhg", "tFMhf", "tFMhe", "tFMhd", "tFMhc", "tFMhb", "tFMha", "tFmH9", "tFmH8", "tFmH7", "tFmH6", "tFmH5", "tFmH4", "tFmH3", "tFmH2", "tFmH1", "tFmH0", "tFmHZ", "tFmHY", "tFmHX", "tFmHW", "tFmHV", "tFmHU", "tFmHT", "tFmHS", "tFmHR", "tFmHQ", "tFmHP", "tFmHO", "tFmHN", "tFmHM", "tFmHL", "tFmHK", "tFmHJ", "tFmHI", "tFmHH", "tFmHG", "tFmHF", "tFmHE", "tFmHD", "tFmHC", "tFmHB", "tFmHA", "tFmHz", "tFmHy", "tFmHx", "tFmHw", "tFmHv", "tFmHu", "tFmHt", "tFmHs", "tFmHr", "tFmHq", "tFmHp", "tFmHo", "tFmHn", "tFmHm", "tFmHl", "tFmHk", "tFmHj", "tFmHi", "tFmHh", "tFmHg", "tFmHf", "tFmHe", "tFmHd", "tFmHc", "tFmHb", "tFmHa", "tFmh9", "tFmh8", "tFmh7", "tFmh6", "tFmh5", "tFmh4", "tFmh3", "tFmh2", "tFmh1", "tFmh0", "tFmhZ", "tFmhY", "tFmhX", "tFmhW", "tFmhV", "tFmhU", "tFmhT", "tFmhS", "tFmhR", "tFmhQ", "tFmhP", "tFmhO", "tFmhN", "tFmhM", "tFmhL", "tFmhK", "tFmhJ", "tFmhI", "tFmhH", "tFmhG", "tFmhF", "tFmhE", "tFmhD", "tFmhC", "tFmhB", "tFmhA", "tFmhz", "tFmhy", "tFmhx", "tFmhw", "tFmhv", "tFmhu", "tFmht", "tFmhs", "tFmhr", "tFmhq", "tFmhp", "tFmho", "tFmhn", "tFmhm", "tFmhl", "tFmhk", "tFmhj", "tFmhi", "tFmhh", "tFmhg", "tFmhf", "tFmhe", "tFmhd", "tFmhc", "tFmhb", "tFmha", "tfMH9", "tfMH8", "tfMH7", "tfMH6", "tfMH5", "tfMH4", "tfMH3", "tfMH2", "tfMH1", "tfMH0", "tfMHZ", "tfMHY", "tfMHX", "tfMHW", "tfMHV", "tfMHU", "tfMHT", "tfMHS", "tfMHR", "tfMHQ", "tfMHP", "tfMHO", "tfMHN", "tfMHM", "tfMHL", "tfMHK", "tfMHJ", "tfMHI", "tfMHH", "tfMHG", "tfMHF", "tfMHE", "tfMHD", "tfMHC", "tfMHB", "tfMHA", "tfMHz", "tfMHy", "tfMHx", "tfMHw", "tfMHv", "tfMHu", "tfMHt", "tfMHs", "tfMHr", "tfMHq", "tfMHp", "tfMHo", "tfMHn", "tfMHm", "tfMHl", "tfMHk", "tfMHj", "tfMHi", "tfMHh", "tfMHg", "tfMHf", "tfMHe", "tfMHd", "tfMHc", "tfMHb", "tfMHa", "tfMh9", "tfMh8", "tfMh7", "tfMh6", "tfMh5", "tfMh4", "tfMh3", "tfMh2", "tfMh1", "tfMh0", "tfMhZ", "tfMhY", "tfMhX", "tfMhW", "tfMhV", "tfMhU", "tfMhT", "tfMhS", "tfMhR", "tfMhQ", "tfMhP", "tfMhO", "tfMhN", "tfMhM", "tfMhL", "tfMhK", "tfMhJ", "tfMhI", "tfMhH", "tfMhG", "tfMhF", "tfMhE", "tfMhD", "tfMhC", "tfMhB", "tfMhA", "tfMhz", "tfMhy", "tfMhx", "tfMhw", "tfMhv", "tfMhu", "tfMht", "tfMhs", "tfMhr", "tfMhq", "tfMhp", "tfMho", "tfMhn", "tfMhm", "tfMhl", "tfMhk", "tfMhj", "tfMhi", "tfMhh", "tfMhg", "tfMhf", "tfMhe", "tfMhd", "tfMhc", "tfMhb", "tfMha", "tfmH9", "tfmH8", "tfmH7", "tfmH6", "tfmH5", "tfmH4", "tfmH3", "tfmH2", "tfmH1", "tfmH0", "tfmHZ", "tfmHY", "tfmHX", "tfmHW", "tfmHV", "tfmHU", "tfmHT", "tfmHS", "tfmHR", "tfmHQ", "tfmHP", "tfmHO", "tfmHN", "tfmHM", "tfmHL", "tfmHK", "tfmHJ", "tfmHI", "tfmHH", "tfmHG", "tfmHF", "tfmHE", "tfmHD", "tfmHC", "tfmHB", "tfmHA", "tfmHz", "tfmHy", "tfmHx", "tfmHw", "tfmHv", "tfmHu", "tfmHt", "tfmHs", "tfmHr", "tfmHq", "tfmHp", "tfmHo", "tfmHn", "tfmHm", "tfmHl", "tfmHk", "tfmHj", "tfmHi", "tfmHh", "tfmHg", "tfmHf", "tfmHe", "tfmHd", "tfmHc", "tfmHb", "tfmHa", "tfmh9", "tfmh8", "tfmh7", "tfmh6", "tfmh5", "tfmh4", "tfmh3", "tfmh2", "tfmh1", "tfmh0", "tfmhZ", "tfmhY", "tfmhX", "tfmhW", "tfmhV", "tfmhU", "tfmhT", "tfmhS", "tfmhR", "tfmhQ", "tfmhP", "tfmhO", "tfmhN", "tfmhM", "tfmhL", "tfmhK", "tfmhJ", "tfmhI", "tfmhH", "tfmhG", "tfmhF", "tfmhE", "tfmhD", "tfmhC", "tfmhB", "tfmhA", "tfmhz", "tfmhy", "tfmhx", "tfmhw", "tfmhv", "tfmhu", "tfmht", "tfmhs", "tfmhr", "tfmhq", "tfmhp", "tfmho", "tfmhn", "tfmhm", "tfmhl", "tfmhk", "tfmhj", "tfmhi", "tfmhh", "tfmhg", "tfmhf", "tfmhe", "tfmhd", "tfmhc", "tfmhb", "tfmha", "tFMG9", "tFMG8", "tFMG7", "tFMG6", "tFMG5", "tFMG4", "tFMG3", "tFMG2", "tFMG1", "tFMG0", "tFMGZ", "tFMGY", "tFMGX", "tFMGW", "tFMGV", "tFMGU", "tFMGT", "tFMGS", "tFMGR", "tFMGQ", "tFMGP", "tFMGO", "tFMGN", "tFMGM", "tFMGL", "tFMGK", "tFMGJ", "tFMGI", "tFMGH", "tFMGG", "tFMGF", "tFMGE", "tFMGD", "tFMGC", "tFMGB", "tFMGA", "tFMGz", "tFMGy", "tFMGx", "tFMGw", "tFMGv", "tFMGu", "tFMGt", "tFMGs", "tFMGr", "tFMGq", "tFMGp", "tFMGo", "tFMGn", "tFMGm", "tFMGl", "tFMGk", "tFMGj", "tFMGi", "tFMGh", "tFMGg", "tFMGf", "tFMGe", "tFMGd", "tFMGc", "tFMGb", "tFMGa", "tFMg9", "tFMg8", "tFMg7", "tFMg6", "tFMg5", "tFMg4", "tFMg3", "tFMg2", "tFMg1", "tFMg0", "tFMgZ", "tFMgY", "tFMgX", "tFMgW", "tFMgV", "tFMgU", "tFMgT", "tFMgS", "tFMgR", "tFMgQ", "tFMgP", "tFMgO", "tFMgN", "tFMgM", "tFMgL", "tFMgK", "tFMgJ", "tFMgI", "tFMgH", "tFMgG", "tFMgF", "tFMgE", "tFMgD", "tFMgC", "tFMgB", "tFMgA", "tFMgz", "tFMgy", "tFMgx", "tFMgw", "tFMgv", "tFMgu", "tFMgt", "tFMgs", "tFMgr", "tFMgq", "tFMgp", "tFMgo", "tFMgn", "tFMgm", "tFMgl", "tFMgk", "tFMgj", "tFMgi", "tFMgh", "tFMgg", "tFMgf", "tFMge", "tFMgd", "tFMgc", "tFMgb", "tFMga", "tFmG9", "tFmG8", "tFmG7", "tFmG6", "tFmG5", "tFmG4", "tFmG3", "tFmG2", "tFmG1", "tFmG0", "tFmGZ", "tFmGY", "tFmGX", "tFmGW", "tFmGV", "tFmGU", "tFmGT", "tFmGS", "tFmGR", "tFmGQ", "tFmGP", "tFmGO", "tFmGN", "tFmGM", "tFmGL", "tFmGK", "tFmGJ", "tFmGI", "tFmGH", "tFmGG", "tFmGF", "tFmGE", "tFmGD", "tFmGC", "tFmGB", "tFmGA", "tFmGz", "tFmGy", "tFmGx", "tFmGw", "tFmGv", "tFmGu", "tFmGt", "tFmGs", "tFmGr", "tFmGq", "tFmGp", "tFmGo", "tFmGn", "tFmGm", "tFmGl", "tFmGk", "tFmGj", "tFmGi", "tFmGh", "tFmGg", "tFmGf", "tFmGe", "tFmGd", "tFmGc", "tFmGb", "tFmGa", "tFmg9", "tFmg8", "tFmg7", "tFmg6", "tFmg5", "tFmg4", "tFmg3", "tFmg2", "tFmg1", "tFmg0", "tFmgZ", "tFmgY", "tFmgX", "tFmgW", "tFmgV", "tFmgU", "tFmgT", "tFmgS", "tFmgR", "tFmgQ", "tFmgP", "tFmgO", "tFmgN", "tFmgM", "tFmgL", "tFmgK", "tFmgJ", "tFmgI", "tFmgH", "tFmgG", "tFmgF", "tFmgE", "tFmgD", "tFmgC", "tFmgB", "tFmgA", "tFmgz", "tFmgy", "tFmgx", "tFmgw", "tFmgv", "tFmgu", "tFmgt", "tFmgs", "tFmgr", "tFmgq", "tFmgp", "tFmgo", "tFmgn", "tFmgm", "tFmgl", "tFmgk", "tFmgj", "tFmgi", "tFmgh", "tFmgg", "tFmgf", "tFmge", "tFmgd", "tFmgc", "tFmgb", "tFmga", "tfMG9", "tfMG8", "tfMG7", "tfMG6", "tfMG5", "tfMG4", "tfMG3", "tfMG2", "tfMG1", "tfMG0", "tfMGZ", "tfMGY", "tfMGX", "tfMGW", "tfMGV", "tfMGU", "tfMGT", "tfMGS", "tfMGR", "tfMGQ", "tfMGP", "tfMGO", "tfMGN", "tfMGM", "tfMGL", "tfMGK", "tfMGJ", "tfMGI", "tfMGH", "tfMGG", "tfMGF", "tfMGE", "tfMGD", "tfMGC", "tfMGB", "tfMGA", "tfMGz", "tfMGy", "tfMGx", "tfMGw", "tfMGv", "tfMGu", "tfMGt", "tfMGs", "tfMGr", "tfMGq", "tfMGp", "tfMGo", "tfMGn", "tfMGm", "tfMGl", "tfMGk", "tfMGj", "tfMGi", "tfMGh", "tfMGg", "tfMGf", "tfMGe", "tfMGd", "tfMGc", "tfMGb", "tfMGa", "tfMg9", "tfMg8", "tfMg7", "tfMg6", "tfMg5", "tfMg4", "tfMg3", "tfMg2", "tfMg1", "tfMg0", "tfMgZ", "tfMgY", "tfMgX", "tfMgW", "tfMgV", "tfMgU", "tfMgT", "tfMgS", "tfMgR", "tfMgQ", "tfMgP", "tfMgO", "tfMgN", "tfMgM", "tfMgL", "tfMgK", "tfMgJ", "tfMgI", "tfMgH", "tfMgG", "tfMgF", "tfMgE", "tfMgD", "tfMgC", "tfMgB", "tfMgA", "tfMgz", "tfMgy", "tfMgx", "tfMgw", "tfMgv", "tfMgu", "tfMgt", "tfMgs", "tfMgr", "tfMgq", "tfMgp", "tfMgo", "tfMgn", "tfMgm", "tfMgl", "tfMgk", "tfMgj", "tfMgi", "tfMgh", "tfMgg", "tfMgf", "tfMge", "tfMgd", "tfMgc", "tfMgb", "tfMga", "tfmG9", "tfmG8", "tfmG7", "tfmG6", "tfmG5", "tfmG4", "tfmG3", "tfmG2", "tfmG1", "tfmG0", "tfmGZ", "tfmGY", "tfmGX", "tfmGW", "tfmGV", "tfmGU", "tfmGT", "tfmGS", "tfmGR", "tfmGQ", "tfmGP", "tfmGO", "tfmGN", "tfmGM", "tfmGL", "tfmGK", "tfmGJ", "tfmGI", "tfmGH", "tfmGG", "tfmGF", "tfmGE", "tfmGD", "tfmGC", "tfmGB", "tfmGA", "tfmGz", "tfmGy", "tfmGx", "tfmGw", "tfmGv", "tfmGu", "tfmGt", "tfmGs", "tfmGr", "tfmGq", "tfmGp", "tfmGo", "tfmGn", "tfmGm", "tfmGl", "tfmGk", "tfmGj", "tfmGi", "tfmGh", "tfmGg", "tfmGf", "tfmGe", "tfmGd", "tfmGc", "tfmGb", "tfmGa", "tfmg9", "tfmg8", "tfmg7", "tfmg6", "tfmg5", "tfmg4", "tfmg3", "tfmg2", "tfmg1", "tfmg0", "tfmgZ", "tfmgY", "tfmgX", "tfmgW", "tfmgV", "tfmgU", "tfmgT", "tfmgS", "tfmgR", "tfmgQ", "tfmgP", "tfmgO", "tfmgN", "tfmgM", "tfmgL", "tfmgK", "tfmgJ", "tfmgI", "tfmgH", "tfmgG", "tfmgF", "tfmgE", "tfmgD", "tfmgC", "tfmgB", "tfmgA", "tfmgz", "tfmgy", "tfmgx", "tfmgw", "tfmgv", "tfmgu", "tfmgt", "tfmgs", "tfmgr", "tfmgq", "tfmgp", "tfmgo", "tfmgn", "tfmgm", "tfmgl", "tfmgk", "tfmgj", "tfmgi", "tfmgh", "tfmgg", "tfmgf", "tfmge", "tfmgd", "tfmgc", "tfmgb", "tfmga"]

list_simu_14       = ['xQFvY', 'xQFvX', 'xQFvW', 'xQFvV', 'xQFvU', 'xQFvT', 'xQFvS', 'xQFvR', 'xQFvQ', 'xQFvP', 'xQFvO', 'xQFvN', 'xQFvM', 'xQFvL', 'xQFvK', 'xQFvJ', 'xQFvI', 'xQFvH', 'xQFvG', 'xQFvF', 'xQFvE', 'xQFvD', 'xQFvC', 'xQFvB', 'xQFvA', 'xQFvz', 'xQFvy', 'xQFvx', 'xQFvw', 'xQFvv', 'xQFvu', 'xQFvt', 'xQFvs', 'xQFvr', 'xQFvq', 'xQFvp', 'xQFvo', 'xQFvn', 'xQFvm', 'xQFvl', 'xQFvk', 'xQFvj', 'xQFvi', 'xQFvh', 'xQFvg', 'xQFvf', 'xQFve', 'xQFvd', 'xQFvc', 'xQFvb', 'xQFva', 'xQfV9', 'xQfV8', 'xQfV7', 'xQfV6', 'xQfV5', 'xQfV4', 'xQfV3', 'xQfV2', 'xQfV1', 'xQfV0', 'xQfVZ', 'xQfVY', 'xQfVX', 'xQfVW', 'xQfVV', 'xQfVU', 'xQfVT', 'xQfVS', 'xQfVR', 'xQfVQ', 'xQfVP', 'xQfVO', 'xQfVN', 'xQfVM', 'xQfVL', 'xQfVK', 'xQfVJ', 'xQfVI', 'xQfVH', 'xQfVG', 'xQfVF', 'xQfVE', 'xQfVD', 'xQfVC', 'xQfVB', 'xQfVA', 'xQfVz', 'xQfVy', 'xQfVx', 'xQfVw', 'xQfVv', 'xQfVu', 'xQfVt', 'xQfVs', 'xQfVr', 'xQfVq', 'xQfVp', 'xQfVo', 'xQfVn', 'xQfVm', 'xQfVl', 'xQfVk', 'xQfVj', 'xQfVi', 'xQfVh', 'xQfVg', 'xQfVf', 'xQfVe', 'xQfVd', 'xQfVc', 'xQfVb', 'xQfVa', 'xQfv9', 'xQfv8', 'xQfv7', 'xQfv6', 'xQfv5', 'xQfv4', 'xQfv3', 'xQfv2', 'xQfv1', 'xQfv0', 'xQfvZ', 'xQfvY', 'xQfvX', 'xQfvW', 'xQfvV', 'xQfvU', 'xQfvT', 'xQfvS', 'xQfvR', 'xQfvQ', 'xQfvP', 'xQfvO', 'xQfvN', 'xQfvM', 'xQfvL', 'xQfvK', 'xQfvJ', 'xQfvI', 'xQfvH', 'xQfvG', 'xQfvF', 'xQfvE', 'xQfvD', 'xQfvC', 'xQfvB', 'xQfvA', 'xQfvz', 'xQfvy', 'xQfvx', 'xQfvw', 'xQfvv', 'xQfvu', 'xQfvt', 'xQfvs', 'xQfvr', 'xQfvq', 'xQfvp', 'xQfvo', 'xQfvn', 'xQfvm', 'xQfvl', 'xQfvk', 'xQfvj', 'xQfvi', 'xQfvh', 'xQfvg', 'xQfvf', 'xQfve', 'xQfvd', 'xQfvc', 'xQfvb', 'xQfva', 'xqFV9', 'xqFV8', 'xqFV7', 'xqFV6', 'xqFV5', 'xqFV4', 'xqFV3', 'xqFV2', 'xqFV1', 'xqFV0', 'xqFVZ', 'xqFVY', 'xqFVX', 'xqFVW', 'xqFVV', 'xqFVU', 'xqFVT', 'xqFVS', 'xqFVR', 'xqFVQ', 'xqFVP', 'xqFVO', 'xqFVN', 'xqFVM', 'xqFVL', 'xqFVK', 'xqFVJ', 'xqFVI', 'xqFVH', 'xqFVG', 'xqFVF', 'xqFVE', 'xqFVD', 'xqFVC', 'xqFVB', 'xqFVA', 'xqFVz', 'xqFVy', 'xqFVx', 'xqFVw', 'xqFVv', 'xqFVu', 'xqFVt', 'xqFVs', 'xqFVr', 'xqFVq', 'xqFVp', 'xqFVo', 'xqFVn', 'xqFVm', 'xqFVl', 'xqFVk', 'xqFVj', 'xqFVi', 'xqFVh', 'xqFVg', 'xqFVf', 'xqFVe', 'xqFVd', 'xqFVc', 'xqFVb', 'xqFVa', 'xqFv9', 'xqFv8', 'xqFv7', 'xqFv6', 'xqFv5', 'xqFv4', 'xqFv3', 'xqFv2', 'xqFv1', 'xqFv0', 'xqFvZ', 'xqFvY', 'xqFvX', 'xqFvW', 'xqFvV', 'xqFvU', 'xqFvT', 'xqFvS', 'xqFvR', 'xqFvQ', 'xqFvP', 'xqFvO', 'xqFvN', 'xqFvM', 'xqFvL', 'xqFvK', 'xqFvJ', 'xqFvI', 'xqFvH', 'xqFvG', 'xqFvF', 'xqFvE', 'xqFvD', 'xqFvC', 'xqFvB', 'xqFvA', 'xqFvz', 'xqFvy', 'xqFvx', 'xqFvw', 'xqFvv', 'xqFvu', 'xqFvt', 'xqFvs', 'xqFvr', 'xqFvq', 'xqFvp', 'xqFvo', 'xqFvn', 'xqFvm', 'xqFvl', 'xqFvk', 'xqFvj', 'xqFvi', 'xqFvh', 'xqFvg', 'xqFvf', 'xqFve', 'xqFvd', 'xqFvc', 'xqFvb', 'xqFva', 'xqfV9', 'xqfV8', 'xqfV7', 'xqfV6', 'xqfV5', 'xqfV4', 'xqfV3', 'xqfV2', 'xqfV1', 'xqfV0', 'xqfVZ', 'xqfVY', 'xqfVX', 'xqfVW', 'xqfVV', 'xqfVU', 'xqfVT', 'xqfVS', 'xqfVR', 'xqfVQ', 'xqfVP', 'xqfVO', 'xqfVN', 'xqfVM', 'xqfVL', 'xqfVK', 'xqfVJ', 'xqfVI', 'xqfVH', 'xqfVG', 'xqfVF', 'xqfVE', 'xqfVD', 'xqfVC', 'xqfVB', 'xqfVA', 'xqfVz', 'xqfVy', 'xqfVx', 'xqfVw', 'xqfVv', 'xqfVu', 'xqfVt', 'xqfVs', 'xqfVr', 'xqfVq', 'xqfVp', 'xqfVo', 'xqfVn', 'xqfVm', 'xqfVl', 'xqfVk', 'xqfVj', 'xqfVi', 'xqfVh', 'xqfVg', 'xqfVf', 'xqfVe', 'xqfVd', 'xqfVc', 'xqfVb', 'xqfVa', 'xqfv9', 'xqfv8', 'xqfv7', 'xqfv6', 'xqfv5', 'xqfv4', 'xqfv3', 'xqfv2', 'xqfv1', 'xqfv0', 'xqfvZ', 'xqfvY', 'xqfvX', 'xqfvW', 'xqfvV', 'xqfvU', 'xqfvT', 'xqfvS', 'xqfvR', 'xqfvQ', 'xqfvP', 'xqfvO', 'xqfvN', 'xqfvM', 'xqfvL', 'xqfvK', 'xqfvJ', 'xqfvI', 'xqfvH', 'xqfvG', 'xqfvF', 'xqfvE', 'xqfvD', 'xqfvC', 'xqfvB', 'xqfvA', 'xqfvz', 'xqfvy', 'xqfvx', 'xqfvw', 'xqfvv', 'xqfvu', 'xqfvt', 'xqfvs', 'xqfvr', 'xqfvq', 'xqfvp', 'xqfvo', 'xqfvn', 'xqfvm', 'xqfvl', 'xqfvk', 'xqfvj', 'xqfvi', 'xqfvh', 'xqfvg', 'xqfvf', 'xqfve', 'xqfvd', 'xqfvc', 'xqfvb', 'xqfva', 'xQFU9', 'xQFU8', 'xQFU7', 'xQFU6', 'xQFU5', 'xQFU4', 'xQFU3', 'xQFU2', 'xQFU1', 'xQFU0', 'xQFUZ', 'xQFUY', 'xQFUX', 'xQFUW', 'xQFUV', 'xQFUU', 'xQFUT', 'xQFUS', 'xQFUR', 'xQFUQ', 'xQFUP', 'xQFUO', 'xQFUN', 'xQFUM', 'xQFUL', 'xQFUK', 'xQFUJ', 'xQFUI', 'xQFUH', 'xQFUG', 'xQFUF', 'xQFUE', 'xQFUD', 'xQFUC', 'xQFUB', 'xQFUA', 'xQFUz', 'xQFUy', 'xQFUx', 'xQFUw', 'xQFUv', 'xQFUu', 'xQFUt', 'xQFUs', 'xQFUr', 'xQFUq', 'xQFUp', 'xQFUo', 'xQFUn', 'xQFUm', 'xQFUl', 'xQFUk', 'xQFUj', 'xQFUi', 'xQFUh', 'xQFUg', 'xQFUf', 'xQFUe', 'xQFUd', 'xQFUc', 'xQFUb', 'xQFUa', 'xQFu9', 'xQFu8', 'xQFu7', 'xQFu6', 'xQFu5', 'xQFu4', 'xQFu3', 'xQFu2', 'xQFu1', 'xQFu0', 'xQFuZ', 'xQFuY', 'xQFuX', 'xQFuW', 'xQFuV', 'xQFuU', 'xQFuT', 'xQFuS', 'xQFuR', 'xQFuQ', 'xQFuP', 'xQFuO', 'xQFuN', 'xQFuM', 'xQFuL', 'xQFuK', 'xQFuJ', 'xQFuI', 'xQFuH', 'xQFuG', 'xQFuF', 'xQFuE', 'xQFuD', 'xQFuC', 'xQFuB', 'xQFuA', 'xQFuz', 'xQFuy', 'xQFux', 'xQFuw', 'xQFuv', 'xQFuu', 'xQFut', 'xQFus', 'xQFur', 'xQFuq', 'xQFup', 'xQFuo', 'xQFun', 'xQFum', 'xQFul', 'xQFuk', 'xQFuj', 'xQFui', 'xQFuh', 'xQFug', 'xQFuf', 'xQFue', 'xQFud', 'xQFuc', 'xQFub', 'xQFua', 'xQfU9', 'xQfU8', 'xQfU7', 'xQfU6', 'xQfU5', 'xQfU4', 'xQfU3', 'xQfU2', 'xQfU1', 'xQfU0', 'xQfUZ', 'xQfUY', 'xQfUX', 'xQfUW', 'xQfUV', 'xQfUU', 'xQfUT', 'xQfUS', 'xQfUR', 'xQfUQ', 'xQfUP', 'xQfUO', 'xQfUN', 'xQfUM', 'xQfUL', 'xQfUK', 'xQfUJ', 'xQfUI', 'xQfUH', 'xQfUG', 'xQfUF', 'xQfUE', 'xQfUD', 'xQfUC', 'xQfUB', 'xQfUA', 'xQfUz', 'xQfUy', 'xQfUx', 'xQfUw', 'xQfUv', 'xQfUu', 'xQfUt', 'xQfUs', 'xQfUr', 'xQfUq', 'xQfUp', 'xQfUo', 'xQfUn', 'xQfUm', 'xQfUl', 'xQfUk', 'xQfUj', 'xQfUi', 'xQfUh', 'xQfUg', 'xQfUf', 'xQfUe', 'xQfUd', 'xQfUc', 'xQfUb', 'xQfUa', 'xQfu9', 'xQfu8', 'xQfu7', 'xQfu6', 'xQfu5', 'xQfu4', 'xQfu3', 'xQfu2', 'xQfu1', 'xQfu0', 'xQfuZ', 'xQfuY', 'xQfuX', 'xQfuW', 'xQfuV', 'xQfuU', 'xQfuT', 'xQfuS', 'xQfuR', 'xQfuQ', 'xQfuP', 'xQfuO', 'xQfuN', 'xQfuM', 'xQfuL', 'xQfuK', 'xQfuJ', 'xQfuI', 'xQfuH', 'xQfuG', 'xQfuF', 'xQfuE', 'xQfuD', 'xQfuC', 'xQfuB', 'xQfuA', 'xQfuz', 'xQfuy', 'xQfux', 'xQfuw', 'xQfuv', 'xQfuu', 'xQfut', 'xQfus', 'xQfur', 'xQfuq', 'xQfup', 'xQfuo', 'xQfun', 'xQfum', 'xQful', 'xQfuk', 'xQfuj', 'xQfui', 'xQfuh', 'xQfug', 'xQfuf', 'xQfue', 'xQfud', 'xQfuc', 'xQfub', 'xQfua', 'xqFU9', 'xqFU8', 'xqFU7', 'xqFU6', 'xqFU5', 'xqFU4', 'xqFU3', 'xqFU2', 'xqFU1', 'xqFU0', 'xqFUZ', 'xqFUY', 'xqFUX', 'xqFUW', 'xqFUV', 'xqFUU', 'xqFUT', 'xqFUS', 'xqFUR', 'xqFUQ', 'xqFUP', 'xqFUO', 'xqFUN', 'xqFUM', 'xqFUL', 'xqFUK', 'xqFUJ', 'xqFUI', 'xqFUH', 'xqFUG', 'xqFUF', 'xqFUE', 'xqFUD', 'xqFUC', 'xqFUB', 'xqFUA', 'xqFUz', 'xqFUy', 'xqFUx', 'xqFUw', 'xqFUv', 'xqFUu', 'xqFUt', 'xqFUs', 'xqFUr', 'xqFUq', 'xqFUp', 'xqFUo', 'xqFUn', 'xqFUm', 'xqFUl', 'xqFUk', 'xqFUj', 'xqFUi', 'xqFUh', 'xqFUg', 'xqFUf', 'xqFUe', 'xqFUd', 'xqFUc', 'xqFUb', 'xqFUa', 'xqFu9', 'xqFu8', 'xqFu7', 'xqFu6', 'xqFu5', 'xqFu4', 'xqFu3', 'xqFu2', 'xqFu1', 'xqFu0', 'xqFuZ', 'xqFuY', 'xqFuX', 'xqFuW', 'xqFuV', 'xqFuU', 'xqFuT', 'xqFuS', 'xqFuR', 'xqFuQ', 'xqFuP', 'xqFuO', 'xqFuN', 'xqFuM', 'xqFuL', 'xqFuK', 'xqFuJ', 'xqFuI', 'xqFuH', 'xqFuG', 'xqFuF', 'xqFuE', 'xqFuD', 'xqFuC', 'xqFuB', 'xqFuA', 'xqFuz', 'xqFuy', 'xqFux', 'xqFuw', 'xqFuv', 'xqFuu', 'xqFut', 'xqFus', 'xqFur', 'xqFuq', 'xqFup', 'xqFuo', 'xqFun', 'xqFum', 'xqFul', 'xqFuk', 'xqFuj', 'xqFui', 'xqFuh', 'xqFug', 'xqFuf', 'xqFue', 'xqFud', 'xqFuc', 'xqFub', 'xqFua', 'xqfU9', 'xqfU8', 'xqfU7', 'xqfU6', 'xqfU5', 'xqfU4', 'xqfU3', 'xqfU2', 'xqfU1', 'xqfU0', 'xqfUZ', 'xqfUY', 'xqfUX', 'xqfUW', 'xqfUV', 'xqfUU', 'xqfUT', 'xqfUS', 'xqfUR', 'xqfUQ', 'xqfUP', 'xqfUO', 'xqfUN', 'xqfUM', 'xqfUL', 'xqfUK', 'xqfUJ', 'xqfUI', 'xqfUH', 'xqfUG', 'xqfUF', 'xqfUE', 'xqfUD', 'xqfUC', 'xqfUB', 'xqfUA', 'xqfUz', 'xqfUy', 'xqfUx', 'xqfUw', 'xqfUv', 'xqfUu', 'xqfUt', 'xqfUs', 'xqfUr', 'xqfUq', 'xqfUp', 'xqfUo', 'xqfUn', 'xqfUm', 'xqfUl', 'xqfUk', 'xqfUj', 'xqfUi', 'xqfUh', 'xqfUg', 'xqfUf', 'xqfUe', 'xqfUd', 'xqfUc', 'xqfUb', 'xqfUa', 'xqfu9', 'xqfu8', 'xqfu7', 'xqfu6', 'xqfu5', 'xqfu4', 'xqfu3', 'xqfu2', 'xqfu1', 'xqfu0', 'xqfuZ', 'xqfuY', 'xqfuX', 'xqfuW', 'xqfuV', 'xqfuU', 'xqfuT', 'xqfuS', 'xqfuR', 'xqfuQ', 'xqfuP', 'xqfuO', 'xqfuN', 'xqfuM', 'xqfuL', 'xqfuK', 'xqfuJ', 'xqfuI', 'xqfuH', 'xqfuG', 'xqfuF', 'xqfuE', 'xqfuD', 'xqfuC', 'xqfuB', 'xqfuA', 'xqfuz', 'xqfuy', 'xqfux', 'xqfuw', 'xqfuv', 'xqfuu', 'xqfut', 'xqfus', 'xqfur', 'xqfuq', 'xqfup', 'xqfuo', 'xqfun', 'xqfum', 'xqful', 'xqfuk', 'xqfuj', 'xqfui', 'xqfuh', 'xqfug', 'xqfuf', 'xqfue', 'xqfud', 'xqfuc', 'xqfub', 'xqfua']

list_simu_all3     = ["tcmpa3", "tcmpb3", "tcmpc3", "tcmpd3", "tcmpe3", "tcmpf3", "tcmpg3", "tcmph3", "tcmpi3", "tcmpj3", "tcmpk3", "tcmqk3", "tcmpl3", "tcmql3", "tcmpm3", "tcmqm3", "tcmpn3", "tcmqn3", "tcmpo3", "tcmqo3", "tcmpp3", "tcmqp3", "tcmpq3", "tcmqq3", "tcmpr3", "tcmqr3", "tcmps3", "tcmqs3", "tcmpt3", "tcmqt3", "tcmpu3", "tcmqu3", "tcmoa3", "tcmqv3", "tcmob3", "tcmqw3", "tcmoc3", "tcmqx3", "tcmod3", "tcmqy3", "tcmoe3", "tcmof3", "tcmog3", "tcmoh3", "tcmoi3", "tcmoj3", "tcmok3", "tcmol3", "tcmom3", "tcmon3", "tcmoo3", "tcmop3", "tcmoq3", "tcmor3", "tcmos3", "tcmot3", "tcmou3", "tcmov3", "tcmow3", "tcmox3", "tcmoy3", "tcmfa3"]
list_simu_all3_ni  = ["tcmka3", "tcmkb3", "tcmkc3", "tcmkd3", "tcmke3", "tcmkf3", "tcmkg3", "tcmkh3", "tcmki3", "tcmkj3", "tcmfc3", "tcmkk3", "tcmfe3", "tcmkl3", "tcmfg3", "tcmkm3", "tcmfi3", "tcmkn3", "tcmfk3", "tcmko3", "tcmfm3", "tcmkp3", "tcmfo3", "tcmkq3", "tcmfq3", "tcmkr3", "tcmfs3", "tcmks3", "tcmfu3", "tcmkt3", "tcmfw3", "tcmku3", "tcmja3", "tcmkv3", "tcmjb3", "tcmkw3", "tcmjc3", "tcmkx3", "tcmjd3", "tcmky3", "tcmje3", "tcmjf3", "tcmjg3", "tcmjh3", "tcmji3", "tcmjj3", "tcmjk3", "tcmjl3", "tcmjm3", "tcmjn3", "tcmjo3", "tcmjp3", "tcmjq3", "tcmjr3", "tcmjs3", "tcmjt3", "tcmju3", "tcmjv3", "tcmjw3", "tcmjx3", "tcmjy3", "tcmfa3"]
list_time_all3     = [120, 116, 112, 108, 104, 100, 96, 92, 88, 84, 80, 78, 76, 74, 72, 70, 68, 66, 64, 62, 60, 58, 56, 54, 52, 50, 48, 46, 44, 42, 40, 38, 36, 34, 32, 30, 28, 26, 24, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]


list_simu_alltriff = ["teikc", "tebnn", "tebnt", "tebnl", "tebnp", "tebnr", "teii91", "tebnj", "teii81", "tebni", "teii71", "tebnh", "teii61", "tebng", "teii51", "tebnf", "teii41", "tebne", "teii31", "tebnd", "teii21", "tebnc", "teii11", "tebnb", "teii01", "tebna", "teiiZ1", "teiiY1", "teiiX1", "teiiW1", "teiiV1", "teiiU1", "teiiT1", "teiiS1", "teiiR1", "teiiQ1", "teiiP1", "teiiO1", "teiiN1", "teiiM1", "teiiL1", "teiiK1", "teiiJ1", "teiiI1", "teiiH1", "teiiG1", "teiiF1", "teiiE1", "teiiD1", "teiiC1", "teiiB1", "teiiA1", "teiiz1", "teiiy1", "teiix1", "teiiw1", "teiiv1", "teiiu1", "teiit1", "teiis1", "teiir1", "teiiq1", "teiip1", "teiio1", "teiin1", "teiim1", "teiil1", "teiik1", "teiij1", "teiii1", "teiih1", "teiig1", "teiif1", "teiie1", "teiid1", "teiic1", "teiib1", "teiia1"]
list_time_alltriff = [140,  130,  128,  126,  124,  122,  120,  118,  116,  114,  112,  110,  108,  106,  104,  102,  100,  98,  96,  94,  92,  90,  88,  86,  84,  82,  80,  78,  76,  74,  72,  70,  68,  66,  64,  62,  60,  58,  56,  54,  52,  50,  48,  46,  44,  42,  40,  38,  36,  34,  32,  30,  28,  26,  24,  22,  21,  20,  19,  18,  17,  16,  15,  14,  13,  12,  11,  10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0 ]


list_time          = [800 ,  796,   792,   788,   784,   780,   776,   772,   768,   764,  760,   756,   752,   748,  744,   740,   736,   732,
 728,   724,   720,   716,   712,   708,   704,   700,   696,   692,   688,   684,   680,   676,   672,   668,   664,   660,   656,
 652,   648,   644 ,  640 ,  636  , 632  , 628 ,  624  , 620  , 616 ,  612  , 608 ,  604 ,  600  , 596 ,  592 ,  588,   584 ,  580,   576,
 572,   568,   564  , 560  , 556  , 552   ,548,   544 ,  540  , 536  , 532   ,528,   524 ,  520 ,  516 ,  512  , 508  , 504 ,  500,
  496,   492,   488 ,  484,   480 ,  476 ,  472  , 468   ,464  , 460,   456,   452  , 448,   444  , 440   ,436,   432 ,  428,   424 ,  420,
 416 ,  412 ,  408 ,  404 ,  400  , 396 ,  392  , 388 ,  384  , 380  , 376,   372 ,  368  , 364  , 360 ,  356  , 352  , 348  , 344,
 340 ,  336  , 332  , 328 ,  324  , 320 ,  316 ,  312 ,  308 ,  304 ,  300 ,  296 ,  292 ,  288  , 284  , 280  , 276 ,  272 ,  268,   264,
  260 ,  256 ,  252 ,  248 ,  244 ,  240 ,  236,   232 ,  228  , 224 ,  220  , 216 ,  212 ,  208  , 204 ,  200 ,  196 ,  192  , 188,
 184  , 180 ,  176 ,  172 ,  168  , 164 ,  160  , 156,   152 ,  148  , 144  , 140 ,  136  , 132  , 128,   124 ,  120 ,  116  , 112,   108,
104,   100,   96,    92 ,   88  ,  84 ,   80  ,  76   , 72  ,  68  ,  64  ,  60   , 56   , 52,    48,    44,    40,    36,    32,
 28,    24 ,   23  ,  22  ,  21  ,  20  ,  19   , 18   , 17 ,   16  ,  15   , 14 ,   13  ,  12 ,   11  ,  10 ,   9 ,    8   ,  7 ,    6,
    5,     4,     3 ,    2  ,   1  , 0]
    
list_time07 = [3600, 3596, 3592, 3588, 3584, 3580, 3576, 3572, 3568, 3564, 3560, 3556, 3552, 3548, 3544, 3540, 3536, 3532, 3528, 3524, 3520,
3516, 3512, 3508, 3504, 3500, 3496, 3492, 3488, 3484, 3480, 3476, 3472, 3468, 3464, 3460, 3456, 3452, 3448, 3444, 3440, 3436, 3432, 3428, 3424,
3420, 3416, 3412, 3408, 3404, 3400, 3396, 3392, 3388, 3384, 3380, 3376, 3372, 3368, 3364, 3360, 3356, 3352, 3348, 3344, 3340, 3336, 3332, 3328,
3324, 3320, 3316, 3312, 3308, 3304, 3300, 3296, 3292, 3288, 3284, 3280, 3276, 3272, 3268, 3264, 3260, 3256, 3252, 3248, 3244, 3240, 3236, 3232,
3228, 3224, 3220, 3216, 3212, 3208, 3204, 3200, 3196, 3192, 3188, 3184, 3180, 3176, 3172, 3168, 3164, 3160, 3156, 3152, 3148, 3144, 3140, 3136,
3132, 3128, 3124, 3120, 3116, 3112, 3108, 3104, 3100, 3096, 3092, 3088, 3084, 3080, 3076, 3072, 3068, 3064, 3060, 3056, 3052, 3048, 3044, 3040, 3036,
3032, 3028, 3024, 3020, 3016, 3012, 3008, 3004, 3000, 2996, 2992, 2988, 2984, 2980, 2976, 2972, 2968, 2964, 2960, 2956, 2952 ,2948 ,2944, 2940 ,2936,
2932, 2928, 2924, 2920, 2916, 2912, 2908, 2904, 2900, 2896, 2892, 2888, 2884, 2880, 2876, 2872, 2868 ,2864, 2860, 2856 ,2852, 2848, 2844, 2840, 2836,
2832, 2828, 2824, 2820, 2816, 2812, 2808, 2804, 2800, 2796, 2792, 2788, 2784, 2780, 2776, 2772, 2768, 2764, 2760, 2756, 2752, 2748, 2744, 2740, 2736,
2732, 2728, 2724, 2720, 2716, 2712, 2708, 2704, 2700, 2696, 2692, 2688, 2684, 2680, 2676, 2672, 2668, 2664, 2660, 2656, 2652, 2648 ,2644, 2640, 2636,
2632, 2628, 2624, 2620, 2616, 2612, 2608, 2604, 2600, 2596, 2592, 2588, 2584, 2580, 2576, 2572, 2568, 2564, 2560, 2556, 2552, 2548, 2544, 2540, 2536,
2532, 2528, 2524, 2520, 2516, 2512, 2508, 2504, 2500, 2496, 2492, 2488, 2484, 2480, 2476, 2472, 2468, 2464, 2460, 2456, 2452, 2448, 2444 ,2440, 2436,
2432, 2428, 2424, 2420, 2416, 2412, 2408, 2404, 2400, 2396, 2392, 2388, 2384, 2380, 2376, 2372, 2368, 2364, 2360, 2356, 2352, 2348, 2344 ,2340, 2336,
2332, 2328, 2324, 2320, 2316, 2312, 2308, 2304, 2300, 2296, 2292, 2288, 2284, 2280, 2276, 2272, 2268, 2264, 2260, 2256, 2252, 2248, 2244, 2240, 2236,
2232, 2228, 2224, 2220, 2216, 2212, 2208, 2204, 2200, 2196, 2192, 2188, 2184, 2180, 2176, 2172, 2168, 2164 ,2160, 2156 ,2152, 2148, 2144, 2140, 2136,
2132, 2128, 2124, 2120, 2116, 2112, 2108, 2104, 2100, 2096, 2092, 2088, 2084, 2080, 2076, 2072, 2068, 2064, 2060, 2056, 2052, 2048, 2044 ,2040, 2036 ,
2032, 2028, 2024, 2020, 2016, 2012, 2008, 2004, 2000, 1996, 1992, 1988, 1984, 1980, 1976, 1972, 1968, 1964, 1960, 1956, 1952, 1948, 1944, 1940, 1936,
1932, 1928, 1924, 1920, 1916, 1912, 1908, 1904 ,1900, 1896, 1892, 1888, 1884, 1880, 1876, 1872, 1868, 1864, 1860, 1856, 1852, 1848, 1844, 1840, 1836,
1832, 1828, 1824, 1820, 1816, 1812, 1808, 1804, 1800, 1796, 1792, 1788, 1784, 1780, 1776, 1772, 1768, 1764, 1760, 1756, 1752, 1748 ,1744 ,1740, 1736,
1732, 1728, 1724, 1720, 1716, 1712, 1708, 1704, 1700, 1696, 1692, 1688, 1684, 1680, 1676, 1672, 1668 ,1664 ,1660, 1656, 1652, 1648 ,1644 ,1640, 1636,
1632, 1628, 1624, 1620, 1616, 1612, 1608, 1604, 1600, 1596, 1592, 1588, 1584, 1580, 1576, 1572 ,1568, 1564, 1560, 1556, 1552 ,1548, 1544 ,1540 ,1536,
1532, 1528, 1524, 1520, 1516, 1512, 1508, 1504, 1500, 1496, 1492, 1488, 1484 ,1480 ,1476 ,1472, 1468, 1464, 1460, 1456, 1452, 1448, 1444 ,1440, 1436,
1432, 1428, 1424, 1420, 1416 ,1412, 1408, 1404, 1400 ,1396, 1392, 1388, 1384, 1380, 1376, 1372, 1368 ,1364, 1360, 1356, 1352, 1348, 1344 ,1340 ,1336 ,
1332, 1328, 1324 ,1320, 1316, 1312, 1308, 1304 ,1300, 1296, 1292, 1288, 1284 ,1280, 1276, 1272, 1268 ,1264 ,1260, 1256, 1252, 1248, 1244, 1240, 1236,
1232, 1228, 1224, 1220, 1216, 1212, 1208, 1204, 1200, 1196, 1192, 1188, 1184, 1180 ,1176 ,1172, 1168, 1164, 1160, 1156 ,1152 ,1148, 1144, 1140, 1136,
1132, 1128, 1124, 1120, 1116, 1112, 1108, 1104, 1100, 1096, 1092, 1088 ,1084, 1080, 1076, 1072, 1068, 1064, 1060, 1056, 1052, 1048, 1044, 1040, 1036,
1032, 1028, 1024, 1020, 1016, 1012, 1008, 1004, 1000, 996, 992, 988, 984, 980, 976, 972, 968, 964, 960, 956, 952, 948, 944, 940, 936, 932 ,928 ,924 ,
920, 916, 912, 908 ,904 ,900, 896, 892 ,888, 884, 880, 876 ,872, 868, 864, 860, 856, 852, 848, 844, 840, 836, 832, 828 ,824 ,820, 816, 812, 808, 804, 
800,  796,   792,   788,   784,   780,   776,   772,   768,   764,  760,   756,   752,   748,  744,   740,   736,   732,
 728,   724,   720,   716,   712,   708,   704,   700,   696,   692,   688,   684,   680,   676,   672,   668,   664,   660,   656,
 652,   648,   644 ,  640 ,  636  , 632  , 628 ,  624  , 620  , 616 ,  612  , 608 ,  604 ,  600  , 596 ,  592 ,  588,   584 ,  580,   576,
 572,   568,   564  , 560  , 556  , 552   ,548,   544 ,  540  , 536  , 532   ,528,   524 ,  520 ,  516 ,  512  , 508  , 504 ,  500,
  496,   492,   488 ,  484,   480 ,  476 ,  472  , 468   ,464  , 460,   456,   452  , 448,   444  , 440   ,436,   432 ,  428,   424 ,  420,
 416 ,  412 ,  408 ,  404 ,  400  , 396 ,  392  , 388 ,  384  , 380  , 376,   372 ,  368  , 364  , 360 ,  356  , 352  , 348  , 344,
 340 ,  336  , 332  , 328 ,  324  , 320 ,  316 ,  312 ,  308 ,  304 ,  300 ,  296 ,  292 ,  288  , 284  , 280  , 276 ,  272 ,  268,   264,
  260 ,  256 ,  252 ,  248 ,  244 ,  240 ,  236,   232 ,  228  , 224 ,  220  , 216 ,  212 ,  208  , 204 ,  200 ,  196 ,  192  , 188,
 184  , 180 ,  176 ,  172 ,  168  , 164 ,  160  , 156,   152 ,  148  , 144  , 140 ,  136  , 132  , 128,   124 ,  120 ,  116  , 112,   108,
104,   100,   96,    92 ,   88  ,  84 ,   80  ,  76   , 72  ,  68  ,  64  ,  60   , 56   , 52,    48,    44,    40,    36,    32,
 28,    24 ,   23  ,  22  ,  21  ,  20  ,  19   , 18   , 17 ,   16  ,  15   , 14 ,   13  ,  12 ,   11  ,  10 ,   9 ,    8   ,  7 ,    6,
    5,     4,     3 ,    2  ,   1  , 0]
'-----------------------------------------------------------------------------------------------------------------------'



'-----------------------------------------------------------------------------------------------------------------------'
'FUNCTIONS'
'-----------------------------------------------------------------------------------------------------------------------'

########################################################################################################################
##                                                    Collecting files                                                ## 
########################################################################################################################


def get_basinmsk():

	nc_file = nc.Dataset('/user/home/xk22684/work/data/basins_msk.nc')

	return nc_file

def get_fracfiles(list_simu):

	nc_files = []

	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/inidata/' + simu + '.qrfrac.type.nc'))

	return nc_files



def get_bathyfiles(list_simu):

        nc_files = []

        for simu in list_simu:

            nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/inidata/' + simu + '.qrparm.ovmask.nc'))

        return nc_files



def get_sedfiles(list_simu):

	nc_files = []

	for simu in list_simu :

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/sed/' + simu + '_sed.nc'))

	return nc_files
	
	
def get_sedminmaxfiles(list_simu):

	nc_files = []

	for simu in list_simu :

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/sed/' + simu + '_tempminmax.nc'))

	return nc_files



def get_orofiles(list_simu):
	
	nc_files = []

	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/inidata/' + simu + '.qrparm.orog.nc'))

	return nc_files



def get_mskfiles(list_simu):
	
	nc_files = []
	
	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/inidata/' + simu + '.qrparm.mask.nc'))
	
	return nc_files 
	
	
def get_omskfiles(list_simu):
	
	nc_files = []
	
	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/inidata/' + simu + '.qrparm.omask.nc'))
	
	return nc_files 



def get_ptfiles(list_simu, season):
	
	nc_files = []
	
	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/climate/' + simu + 'a.ptcl' + season + '.nc'))
	
	return nc_files 

def get_clfiles(list_simu, season):
	
	nc_files = []
	
	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/climate/' + simu + 'a.pdcl' + season + '.nc'))
	
	return nc_files 
	

def get_clofiles(list_simu, season):
	
	nc_files = []
	
	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/climate/' + simu + 'o.pfcl' + season + '.nc'))
	
	return nc_files 



def get_pcclfiles(list_simu, season):
	
	nc_files = []
	
	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/climate/' + simu + 'a.pccl' + season + '.nc'))
	
	return nc_files 
	
	
def get_pdclfiles(list_simu, season):
	
	nc_files = []
	
	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/climate/' + simu + 'a.pdcl' + season + '.nc'))
	
	return nc_files 


def get_merid_ocnfiles(list_simu):

		
	nc_files = []
	
	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/merid_ocn/' + simu + 'o.meridclann.nc'))
	
	return nc_files 

	
def get_merid_cnfiles(list_simu, season):

		
	nc_files = []
	
	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/merid_atm/' + simu + 'a.meridcl' + season + '.nc'))
	
	return nc_files 




def get_mean07ofiles(list_simu, season):

	nc_files = []

	for simu in list_simu :

		nc_files.append(nc.Dataset('./data/mean11/mean11o/glob_mean_'  + simu + 'o.pfcl' + season + '.nc'))

	return nc_files 



def get_mean07files(list_simu, season):

	nc_files = []

	for simu in list_simu :

		nc_files.append(nc.Dataset('./data/mean11/mean11/glob_mean_'  + simu + 'a.pdcl' + season + '.nc'))

	return nc_files 
	
	


def get_mean12ofiles(list_simu, season):

	nc_files = []

	for simu in list_simu :

		nc_files.append(nc.Dataset('./data/mean12/mean12o/glob_mean_'  + simu + 'o.pfcl' + season + '.nc'))

	return nc_files 



def get_mean12files(list_simu, season):

	nc_files = []

	for simu in list_simu :

		nc_files.append(nc.Dataset('./data/mean12/mean12/glob_mean_'  + simu + 'a.pdcl' + season + '.nc'))

	return nc_files 
	
	
def get_meanfiles(list_simu, season, numbbc):

	nc_files = []

	for simu in list_simu :

		nc_files.append(nc.Dataset('./data/mean' + numbbc + '/mean' + numbbc + '/glob_mean_'  + simu + 'a.pdcl' + season + '.nc'))

	return nc_files 
	
	
def get_meanofiles(list_simu, season, numbbc):

	nc_files = []

	for simu in list_simu :

		nc_files.append(nc.Dataset('./data/mean' + numbbc + '/mean' + numbbc + 'o/glob_mean_'  + simu + 'o.pfcl' + season + '.nc'))

	return nc_files 
	

def get_meanfiles_hemisphere(list_simu, season, numbbc, hemisphere):

	nc_files = []
	
	for simu in list_simu:
	
		nc_files.append(nc.Dataset('./data/mean' + numbbc + '/mean' + numbbc + '/' + hemisphere +'_mean_'  + simu + 'a.pdcl' + season + '.nc'))
		
	return nc_files
		
	
def get_warmpool_files(list_simu, season, numbbc):

	nc_files = []
	
	for simu in list_simu:
	
		nc_files.append(nc.Dataset('./data/mean' + numbbc + '/mean' + numbbc + 'o/warm_pool_'  + simu + 'o.pfcl' + season + '.nc'))
		
	return nc_files


def close_files(nc_files):

	for nc_file in nc_files :

		nc_file.close()


	
def get_pgofiles(list_simu):

	nc_files = []
	
	for simu in list_simu:
	
		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/climate/' + simu + 'o.pgclann.nc'))
		
	return nc_files	

########################################################################################################################
##                                                    Collecting variables                                            ## 
########################################################################################################################

def get_var2d(nomvar, nc_files, conv = 0):
	
	var = []
	
	for i, f in enumerate(nc_files):

		v = f.variables[nomvar][:]

		var     .append(v[0, 0, :, :] - conv)
	
	return var 


def get_var3d(nomvar, nc_files, conv = 0):
	
	var = []
	
	for i, f in enumerate(nc_files):

		v = f.variables[nomvar][:]

		var     .append(v[0, :, :, :] - conv)
	
	return var 


def get_var_meridocn(nomvar, nc_files):

	var = []
	
	for i, f in enumerate(nc_files):

		v = f.variables[nomvar][:]

		var     .append(v[0, :, :])
	
	return var


def get_var07(nomvar, nc_files, conv = 0):
	
	var = []
	
	for i, f in enumerate(nc_files):

		v = f.variables[nomvar][:]

		var     .append(v[0, 0, 0, 0] - conv)
	
	return var 


def get_var_sed(nomvar, nc_files):

	var = []
	
	for i, f in enumerate(nc_files):

		v = f.variables[nomvar][:]

		var     .append(v[:])

	return var


def  get_varini(nomvar, nc_files):
	
	var = []
	
	for i, f in enumerate(nc_files):

		var     .append(f.variables[nomvar][0, :, :, :])
	
	return var 


########################################################################################################################
##                                              VARIED    OPERATIONS                                                  ## 
########################################################################################################################

def find_nearest(tab, point):

	"""
	Find in an array 'tab' the closest element to the scalar value 'point'
	tab = array 1D
	point = scalar
	"""
	
	idx = np.abs(tab-point).argmin()
	
	return idx 


def reconstruct (short_tabyrs, long_tabyrs, tab):

	tab_bis = []
	
	for age in short_tabyrs :
			
			idx = np.abs(long_tabyrs - age).argmin()
			tab_bis.append(tab[idx])
	
	return tab_bis
	
	

def reconstruct_nan (short_tabyrs, long_tabyrs, tab):

	tab_bis = []
	
	for age in short_tabyrs :
			
			idx = np.abs(long_tabyrs - age).argmin()
			
			if np.isnan(tab[idx]):
			
				tab_bis.append(np.nan)
			else:
				tab_bis.append(tab[idx])
	
	return tab_bis
	

def select_domain(lat, lon, lat_min, lat_max, lon_min, lon_max): 
	
	"""
	lat & lon : array 
	lat_min, lat_max, lon_min, lon_max : scalar
	
	Return : int (index) 
	"""
	
	id_lat_min = find_nearest(lat, lat_min)
	id_lat_max = find_nearest(lat, lat_max)	
	id_lon_min = find_nearest(lon, lon_min)
	id_lon_max = find_nearest(lon, lon_max)
	
	return id_lat_min, id_lat_max, id_lon_min, id_lon_max



def cut (data, id_lat_min, id_lat_max, id_lon_min, id_lon_max):

	'''
	data : list[array] 
	list of each simulation of an array where spatial data are saved 
	id_lat_min, id_lat_max, id_lon_min, id_lon_max: int 
	domain's demarcation index
	
	Return : data_dom = list[array]
	'''

	data_dom = []
	
	for simu in range(len(data)):
	
		data_dom.append(data[simu][id_lat_min:id_lat_max+1, id_lon_min:id_lon_max+1])
	
	return data_dom



def cut_3d (data, id_lat_min, id_lat_max, id_lon_min, id_lon_max, p = 0):


	if p == 0:
	
		data_dom = []
	
		for simu in range(len(data)):
	
			data_dom.append(data[simu][:, id_lat_min:id_lat_max+1, id_lon_min:id_lon_max+1])
	if p != 0:
	
		data_dom = []
	
		for simu in range(len(data)):
	
			data_dom.append(data[simu][p, id_lat_min:id_lat_max+1, id_lon_min:id_lon_max+1])
	
	return data_dom


def cut_3d_z (data, id_lat_min, id_lat_max, id_lon):

	
	data_dom = []

	for simu in range(len(data)):
	
		data_dom.append(data[simu][:, id_lat_min:id_lat_max+1, id_lon])

	return data_dom



def mask_application (data, masks, config):

	'''
	data   : list[array] 
	list of each simulation of an array where spatial data are saved 
	masks  : list[array] 
	lists of mask for each simulation 
	config : str ('sea' or 'land')
	
	
	Return : data_masked (same as data but sea or land masked)
	
	'''
	
	if config == 'sea' :
		
		option = 1
		
	elif config == 'land' :
		
		option = 0
		
	data_masked = []
	
	for simu in range(len(data)):
		
		data_masked.append(np.ma.masked_array(data[simu], mask = (masks[simu] == option)))
		
	return data_masked


def theta(T, P, conv = 0):

	R     = 287.0  # J/(kg*K)
	cp    = 1004.0 # J/(kg*K)
	
	P0    = 1000.0 # hPa

	theta = np.array(T) * (P0/P) ** (R/cp)

	return theta + conv	


def moist_stat_energy(T, gz, q):
	
	cp    = 1004.0 # J/(kg*K)
	Lv    = 2.5e6  # J/kg
	g     = 9.8    # m/s-2

	mse   = cp * T + g*gz + q*Lv
	
	return mse 


def correlation_test (data_prox, data_model):
	
	print('Pearson Test Result = ' , stats.pearsonr(data_prox, data_model))
	print(stats.spearmanr(data_prox, data_model))




def spectre(data1D, time, title, label, units):

	dat = np.asarray(data1D)
	t   = np.asarray(time)


	dt  = t[0] - t[1]
	N   = dat.size

	p   = np.polyfit(t, dat, 1)  # fit polynomial degree 1
	dat_notrend = dat - np.polyval(p, t) # give up the trend in dat
	std = dat_notrend.std()  # Standard deviation ecart type 
	var = std ** 2  # Variance
	dat_norm = dat_notrend / std  # Normalized dataset



	mother = wavelet.Morlet(6)
	s0 = 2*dt    # Starting scale
	dj = 1 / 12  # Twelve sub-octaves per octaves
	J  = 7 / dj  # Seven powers of two with dj sub-octaves
	alpha, _, _ = wavelet.ar1(dat)  # Lag-1 autocorrelation for red noise

	wave, scales, freqs, coi, fft, fftfreqs = wavelet.cwt(dat_norm, dt, dj, s0, J, mother)

	iwave = wavelet.icwt(wave, scales, dt, dj, mother) * std	

	power     = (np.abs(wave)) ** 2
	fft_power = np.abs(fft) ** 2
	period    = 1 / freqs


	signif, fft_theor = wavelet.significance(1.0, dt, scales, 0, alpha, significance_level=0.95, wavelet=mother)
	sig95 = np.ones([1, N]) * signif[:, None]
	sig95 = power / sig95
	print(sig95)

	glbl_power = power.mean(axis=1)
	dof = N - scales  # Correction for padding at edges
	glbl_signif, tmp = wavelet.significance(var, dt, scales, 1, alpha, significance_level=0.95, dof=dof, wavelet=mother)

	# Prepare the figure
	plt.close('all')
	plt.ioff()
	figprops = dict(figsize=(11, 8), dpi=72)
	fig = plt.figure(**figprops)

	# First sub-plot, the original time series anomaly and inverse wavelet
	# transform.
	ax = plt.axes([0.1, 0.75, 0.65, 0.2])
	ax.plot(t, iwave, '-', linewidth=1, color=[0.5, 0.5, 0.5])
	ax.plot(t, dat, 'k', linewidth=1.5)
	ax.set_title('a) {}'.format(title))
	ax.set_ylabel(r'{} [{}]'.format(label, units))

	# Second sub-plot, the normalized wavelet power spectrum and significance
	# level contour lines and cone of influece hatched area. Note that period
	# scale is logarithmic.
	bx = plt.axes([0.1, 0.37, 0.65, 0.28], sharex=ax)
	levels = [0.0625, 0.125, 0.25, 0.5, 1, 2, 4, 8, 16]
	bx.contourf(t, np.log2(period), np.log2(power), np.log2(levels),
		    extend='both', cmap=plt.cm.viridis)
	extent = [t.min(), t.max(), 0, max(period)]
	bx.contour(t, np.log2(period), sig95, [-99, 1], colors='k', linewidths=2,
		   extent=extent)

	tutu = np.concatenate([t, t[-1:] + dt, t[-1:] + dt, t[:1] - dt, t[:1] - dt])
	toto = np.concatenate([np.log2(coi), [1e-9], np.log2(period[-1:]), np.log2(period[-1:]), [1e-9]])

	bx.fill(tutu, toto, 'k', alpha = 0.3, hatch = 'x')
	bx.set_title('Wavelet Power Spectrum - ' + title.format(label, mother.name))
	bx.set_ylabel('Period (kyr)')
	
	Yticks = 2 ** np.arange(np.ceil(np.log2(period.min())),
		                   np.ceil(np.log2(period.max())))
	bx.set_yticks(np.log2(Yticks))
	bx.set_yticklabels(Yticks)

	# Third sub-plot, the global wavelet and Fourier power spectra and theoretical
	# noise spectra. Note that period scale is logarithmic.
	cx = plt.axes([0.77, 0.37, 0.2, 0.28], sharey=bx)
	cx.plot(glbl_signif, np.log2(period), 'k--')
	cx.plot(var * fft_theor, np.log2(period), '--', color='#cccccc')
	cx.plot(var * fft_power, np.log2(1./fftfreqs), '-', color='#cccccc',
		linewidth=1.)
	cx.set_title('Global Wavelet Spectrum')
	cx.set_xlabel(r'Power [({})^2]'.format(units))
	cx.set_xlim([0, glbl_power.max() + var])
	cx.set_ylim(np.log2([period.min(), period.max()]))
	cx.set_yticks(np.log2(Yticks))
	cx.set_yticklabels(Yticks)

	plt.setp(cx.get_yticklabels(), visible=False)

	plt.show()



def weight_mean(lat, data):

	weight    = np.cos(np.deg2rad(lat))
	weight    = weight/weight.sum()
	data_lon  = [np.mean(data[i], axis = 1) for i in range(len(data))]
	data_mean = [np.sum(data_lon[i]*weight) for i in range(len(data))]
	
	return data_mean  
	


	
	
def gl_in_MPT(list_time, temp_list, data, yr1, yr2):

	idx1         = find_nearest(np.asarray(list_time), yr1)
	idx2         = find_nearest(np.asarray(list_time), yr2)
	
	temp_yr12    = temp_list[idx2 : idx1 + 1]
	data_yr12    = data     [idx2 : idx1 + 1]
	
	
	data_yr12_gl = []
	data_yr12_in = []
	
	for i in range(len(temp_yr12)):
	
		if temp_yr12[i] < np.mean(temp_yr12) - 1:
		
			data_yr12_gl.append(data_yr12[i])
			
		if temp_yr12[i] > np.mean(temp_yr12) + 1:
		
			data_yr12_in.append(data_yr12[i])
			
	return data_yr12_gl, data_yr12_in
	


def merid_strf(pres, v_wind_zon, lat):

	rad    = np.pi/180
	a      = 6371000.   #Earth radius in m 
	g      = 9.81       #gravital acceleration m/s^2
	
	#Create an array sigmah with one more level than the pressure levels.
	n_lev  = len(pres)
	sigmah = [100.0] 
	
	
	for i in range(1, len(pres)):
		sigmah.append(0.5* (pres[i] + pres[i-1])/10) #mbar to kPa
		
	sigmah.append(0.1) #top atm 0.1 kPa
	
	dsigmah = np.asarray(sigmah[:-1]) - np.asarray(sigmah[1:]) # thickness of each layer
	
	coslat  = np.cos(lat * rad)

	psi     = np.zeros((len(v_wind_zon), len(dsigmah), len(lat)))
	
	v_wind  = np.asarray(v_wind_zon)
	
	for i in range(len(v_wind_zon)):
	
		strf          = dsigmah[:, None] * 1000 * v_wind[i, :, :] * coslat[None, :] #kPa to Pa [kg.m-1.s-2] 
		psi[i, 1:, :] = -np.cumsum(strf[:-1, :], axis = 0)
		
	scale = (2 * np.pi * a /g) # ? why 1e5
	
	psi = psi * scale           # ? why 8e11
	
	return psi 


def omega_to_w_zon (temp_zon, omega_zon, pres):

	R = 287.
	g = 9.8
	
	w          = np.zeros_like(omega_zon)
	temp_zon_r = [(np.asarray(temp_zon)[i, :, :-1] + np.asarray(temp_zon)[i, :, 1:])/2 for i in range(len(temp_zon))]
	
	for i in range(len(temp_zon)):
	
		rho        = pres[:, None] / (R * temp_zon_r[i])
		w[i, :, :] = -  omega_zon[i] / (rho * g)
		
	return w
	
		
	
def max_partition(data, data_mean, data_to_part):

	data_to_part_max = []
	data_to_part_min = []

	for i in range(len(data)):
	
		if data[i] > data_mean:
		
			data_to_part_max.append(data_to_part[i])
		
		if data[i] < data_mean:
		
			data_to_part_min.append(data_to_part[i])
			
	return data_to_part_max
	


def min_partition(data, data_mean, data_to_part):

	data_to_part_max = []
	data_to_part_min = []

	for i in range(len(data)):
	
		if data[i] > data_mean:
		
			data_to_part_max.append(data_to_part[i])
		
		if data[i] < data_mean:
		
			data_to_part_min.append(data_to_part[i])
			
	return data_to_part_min


########################################################################################################################
###                                                 PLOTS                                                            ### 
########################################################################################################################
def wavelet_plot(ts, title):
	ts_sst11_std   = ts.detrend().interp().standardize()
	PSD_sig_sst11  = ts_sst11_std.spectral(method = 'mtm').signif_test()
	scal_sst11     = ts_sst11_std.wavelet (method = 'cwt')
	scal_sig_sst11 = scal_sst11.signif_test(method = 'ar1asym')

	fig, ax        = ts_sst11.summary_plot(PSD_sig_sst11, scal_sig_sst11)
	ax['cb'].set_xlabel('Amplitude')

	plt.suptitle(title)
	plt.show()
	plt.close()	


def quick_plot(x, y, title = 'title?', xlabel = 'xlab?', ylabel = 'ylab?'):

	plt.plot(x, y)
	plt.grid()
	plt.xlabel(xlabel)
	plt.ylabel(ylabel)
	plt.title(title)
	plt.show()
	plt.close()


def plot_Robinson(lon, lat, data, palette = 'Spectral_r', units = 'units?', title = 'title?', level = 0):


	'''
	lon et lat 1D
	'''
	
	ax = plt.axes(projection = ccrs.Robinson())
	ax.set_global()
	
	cmap        = plt.get_cmap(palette)
	
	if type(level) == int: 

		cont1 = plt.contourf(lon, lat, data, cmap = cmap, transform = ccrs.PlateCarree())


	else :

		cont1 = plt.contourf(lon, lat, data, levels = level, cmap = cmap, transform = ccrs.PlateCarree())

	ax.coastlines()
	ax.gridlines(draw_labels = True)
#	ax.clabel(cont1, fmt=' {:.1f} '.format, fontsize='x-large')


	cbar = plt.colorbar(cont1, ax = ax, shrink = 0.5)
	cbar.set_label(units)

	plt.title(title)

	plt.show()	




def plot_SouthPole(lon, lat_SH, data, palette = 'Spectral_r', units = 'units?', title = 'title?', level = 0):

	cmap = plt.get_cmap(palette)
	ax   = plt.axes(projection = ccrs.SouthPolarStereo())
	ax.set_extent([-180, 180, -90, -50], ccrs.PlateCarree())

	if type(level) == int: 

		cont = plt.contourf(lon, lat_SH, data, cmap = cmap, transform = ccrs.PlateCarree())

	else :
		cont = plt.contourf(lon, lat_SH, data, cmap = cmap, transform = ccrs.PlateCarree(), levels = level)

	ax.gridlines(draw_labels = True)
	ax.coastlines()
	cbar = plt.colorbar(cont, ax = ax, shrink = 0.5)
	cbar.set_label(units)
	plt.title(title)
	plt.show()




def plot_NorthPole(lon, lat_NH, data, palette = 'Spectral_r', units = 'units?', title = 'title?', level = 0):

	cmap = plt.get_cmap(palette)
	ax   = plt.axes(projection = ccrs.NorthPolarStereo())
	ax.set_extent([-180, 180, 50, 90], ccrs.PlateCarree())

	if type(level) == int: 

		cont = plt.contourf(lon, lat_NH, data, cmap = cmap, transform = ccrs.PlateCarree())

	else :
		cont = plt.contourf(lon, lat_NH, data, cmap = cmap, transform = ccrs.PlateCarree(), levels = level)

	ax.gridlines(draw_labels = True)
	ax.coastlines()
	cbar = plt.colorbar(cont, ax = ax, shrink = 0.5)
	cbar.set_label(units)
	plt.title(title)
	plt.show()


def zlat_map(lat, z, data, palette = 'Spectral_r', units = 'units?', title = 'title?', levels = 0, clabel = 'no'):

	fig  = plt.figure()
	ax   = fig.add_subplot(1, 1, 1)
	cmap = plt.get_cmap(palette)

	if clabel != 'no':

		# Create line contours with the same levels as filled contours for labeling
		if type(levels) == int:
			cl = plt.contour(lat, z, data, colors='black')
			plt.clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
		else:
			cl = plt.contour(lat, z, data, levels=levels, colors='black')
			plt.clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')


	if type(levels) == int: 
		cs   = plt.contourf(lat, z, data, cmap = cmap)

	else : 
		cs   = plt.contourf(lat, z, data, cmap = cmap, levels = levels)



		
	cbar = plt.colorbar(cs, ax = ax)

	#plt.clabel(cs, inline = 0.5, colors = 'black')
	cbar .set_label(units)
	plt  .title(title)
	plt  .gca().invert_yaxis()

	plt.show()
	plt.close()

'-----------------------------------------------------------------------------------------------------------------------'


