import tools
import numpy as np 
import netCDF4 as nc 
import os
import matplotlib.pyplot as plt 
from scipy.stats.stats import pearsonr
import pdb
import xarray as xr
import new_tools 
import cmocean
import cartopy.crs as ccrs

#from make_Hadley_circulation.pro script from Alex

'----------------------------------------------------------------------------'
'DATA RECOVERY'
'----------------------------------------------------------------------------'
list_simu_14       = new_tools.list_simu_14
list_simu_14_800k  = list_simu_14[700:]

list_simu      = [tools.list_simu_08, tools.list_simu_09, list_simu_14_800k, tools.list_simu_10]


nc_filesjjs    = [new_tools.get_clfiles(list_simu[i], 'jjs')           for i in range(len(list_simu))]
precip_jjs     = [new_tools.get_var2d('precip_mm_srf', nc_filesjjs[i]) for i in range(len(list_simu))]
#temp_jjs       = [new_tools.get_var2d('temp_mm_srf',   nc_filesjjs[i]) for i in range(len(list_simu))]
lats,  lons    = nc_filesjjs[0][0]. variables['latitude'][:], nc_filesjjs[0][0]. variables['longitude'][:]
for i in range(len(list_simu)):
	new_tools.close_files(nc_filesjjs[i])


nc_filesmay    = [new_tools.get_clfiles(list_simu[i], 'may')           for i in range(len(list_simu))]
precip_may     = [new_tools.get_var2d('precip_mm_srf', nc_filesmay[i]) for i in range(len(list_simu))]
temp_may       = [new_tools.get_var2d('temp_mm_srf',   nc_filesmay[i]) for i in range(len(list_simu))]
for i in range(len(list_simu)):
	new_tools.close_files(nc_filesmay[i])
	

nc_pcfilesjjs  = [new_tools.get_pcclfiles(list_simu[i], 'jjs')             for i in range(len(list_simu))]
w_wind_jjs     = [new_tools.get_var3d('omega_mm_p',  nc_pcfilesjjs[i])     for i in range(len(list_simu))]
v_wind_jjs     = [new_tools.get_var3d('v_mm_p',      nc_pcfilesjjs[i])     for i in range(len(list_simu))]
temp_pc_jjs    = [new_tools.get_var3d('temp_mm_p',   nc_pcfilesjjs[i])     for i in range(len(list_simu))]
omega_jjs      = [new_tools.get_var3d('omega_mm_p',  nc_pcfilesjjs[i])     for i in range(len(list_simu))]
SH_jjs         = [new_tools.get_var3d('q_mm_p',      nc_pcfilesjjs[i])     for i in range(len(list_simu))]
gz_jjs         = [new_tools.get_var3d('ht_mm_p',     nc_pcfilesjjs[i])     for i in range(len(list_simu))]
pres           = nc_pcfilesjjs[0][0].variables['p'][:]
lat_pc, lon_pc = nc_pcfilesjjs[0][0].variables['latitude'][:], nc_pcfilesjjs[0][0].variables['longitude'][:]
for i in range(len(list_simu)):
	new_tools.close_files(nc_pcfilesjjs[i])


nc_pcfilesmay  = [new_tools.get_pcclfiles(list_simu[i], 'may')            for i in range(len(list_simu))]
w_wind_may     = [new_tools.get_var3d('omega_mm_p', nc_pcfilesmay[i])     for i in range(len(list_simu))]
v_wind_may     = [new_tools.get_var3d('v_mm_p',     nc_pcfilesmay[i])     for i in range(len(list_simu))]
temp_pc_may    = [new_tools.get_var3d('temp_mm_p',  nc_pcfilesmay[i])     for i in range(len(list_simu))]
omega_may      = [new_tools.get_var3d('omega_mm_p', nc_pcfilesmay[i])     for i in range(len(list_simu))]
SH_may         = [new_tools.get_var3d('q_mm_p',     nc_pcfilesmay[i])     for i in range(len(list_simu))]
gz_may         = [new_tools.get_var3d('ht_mm_p',    nc_pcfilesmay[i])     for i in range(len(list_simu))]
for i in range(len(list_simu)):
	new_tools.close_files(nc_pcfilesmay[i])
	
'''	
nc_pdfilesjjs  = [new_tools.get_pdclfiles(list_simu[i], 'jjs')            for i in range(len(list_simu))]
mslp_jjs       = [new_tools.get_var2d('p_mm_msl', nc_pdfilesjjs[i])       for i in range(len(list_simu))]
for i in range(len(list_simu)):
	new_tools.close_files(nc_pdfilesjjs[i])
	

nc_pdfilesmay  = [new_tools.get_pdclfiles(list_simu[i], 'may')            for i in range(len(list_simu))]
mslp_may       = [new_tools.get_var2d('p_mm_msl', nc_pdfilesmay[i])       for i in range(len(list_simu))]
for i in range(len(list_simu)):
	new_tools.close_files(nc_pdfilesmay[i])	
'''
nc_file_monsoon  = nc.Dataset('/user/work/xk22684/work/data/monsoon_msk_regridded.nc')
precip_2mm_msk   = nc_file_monsoon.variables['precip_monsoon'][:]
'----------------------------------------------------------------------------'
print('DATA COLLECTED')

#pdb.set_trace()
'----------------------------------------------------------------------------'
'MEAN'
'----------------------------------------------------------------------------'
#precip_mean_jjs       = [tools.averages(precip_jjs[i], conv_1 = 86400)                            for i in range(len(list_simu))]
#precip_mean_may       = [tools.averages(precip_may[i], conv_1 = 86400)                            for i in range(len(list_simu))]
precip_mean_MJJS      = [(np.asarray(precip_jjs[i])*4   + np.asarray(precip_may[i]))/5  for i in range(len(list_simu))]
#precip_mean_MJJS_mean = [precip_mean_MJJS[i].mean()                                               for i in range(len(list_simu))]
#precip_mean_MJJS_mean = [np.ma.median(precip_mean_MJJS[i])                                        for i in range(len(list_simu))] 
#precip_mean_MJJS_3rq  = [np.quantile(precip_mean_MJJS[i], 0.75)                                   for i in range(len(list_simu))] 
#precip_mean_MJJS_1sq  = [np.quantile(precip_mean_MJJS[i], 0.25)                                   for i in range(len(list_simu))] 



w_wind_MJJS           = [(np.asarray(w_wind_jjs [i])*4   + np.asarray(w_wind_may [i]))/5          for i in range(len(list_simu))]
v_wind_MJJS           = [(np.asarray(v_wind_jjs [i])*4   + np.asarray(v_wind_may [i]))/5          for i in range(len(list_simu))]
temp_MJJS             = [(np.asarray(temp_pc_jjs[i])*4   + np.asarray(temp_pc_may[i]))/5          for i in range(len(list_simu))]
omega_MJJS            = [(np.asarray(omega_jjs  [i])*4   + np.asarray(omega_may  [i]))/5          for i in range(len(list_simu))]
SH_MJJS               = [(np.asarray(SH_jjs     [i])*4   + np.asarray(SH_may     [i]))/5          for i in range(len(list_simu))]
gz_MJJS               = [(np.asarray(gz_jjs     [i])*4   + np.asarray(gz_may     [i]))/5          for i in range(len(list_simu))]
#mslp_MJJS             = [(np.asarray(mslp_jjs   [i])*4   + np.asarray(mslp_may   [i]))/5          for i in range(len(list_simu))]

'----------------------------------------------------------------------------'
print('MJJS MEANS DONE')


'----------------------------------------------------------------------------'
'REGION - CUT'
'----------------------------------------------------------------------------'
Regionlon_IA       = [60., 63.75, 67.5, 71.25, 75., 78.75, 82.5, 86.25, 90., 93.75, 97.5, 101.25]		#Indo-Asia.
Regionlon_EA       = [101.25, 105, 108.750, 112.5, 116.25, 120.]		                                #East-Asia.

idx_lonmin_IA      = tools.find_nearest(lon_pc, min(Regionlon_IA))
idx_lonmax_IA      = tools.find_nearest(lon_pc, max(Regionlon_IA))

idx_lonmin_EA      = tools.find_nearest(lon_pc, min(Regionlon_EA))
idx_lonmax_EA      = tools.find_nearest(lon_pc, max(Regionlon_EA))

lat_min, lat_max   = 50, 0 
lon_min, lon_max   = 60, 130
id_lat_min,  id_lat_max,  id_lon_min,  id_lon_max  = tools.select_domain(lats, lons, lat_min, lat_max, lon_min, lon_max)


#faire avec le msk
precip_MJJS_cut    = [new_tools.cut(precip_mean_MJJS[i], id_lat_min, id_lat_max,  id_lon_min, id_lon_max) for i in range(len(list_simu))]


w_wind_MJJS_cut_IA = [new_tools.cut_3d(w_wind_MJJS[i], 0, len(lat_pc), idx_lonmin_IA, idx_lonmax_IA) for i in range(len(list_simu))]
w_wind_MJJS_cut_EA = [new_tools.cut_3d(w_wind_MJJS[i], 0, len(lat_pc), idx_lonmin_EA, idx_lonmax_EA) for i in range(len(list_simu))]

v_wind_MJJS_cut_IA = [new_tools.cut_3d(v_wind_MJJS[i], 0, len(lat_pc), idx_lonmin_IA, idx_lonmax_IA) for i in range(len(list_simu))]
v_wind_MJJS_cut_EA = [new_tools.cut_3d(v_wind_MJJS[i], 0, len(lat_pc), idx_lonmin_EA, idx_lonmax_EA) for i in range(len(list_simu))]


temp_MJJS_cut_IA   = [new_tools.cut_3d(temp_MJJS  [i], 0, len(lat_pc), idx_lonmin_IA, idx_lonmax_IA) for i in range(len(list_simu))]
temp_MJJS_cut_EA   = [new_tools.cut_3d(temp_MJJS  [i], 0, len(lat_pc), idx_lonmin_EA, idx_lonmax_EA) for i in range(len(list_simu))]

omega_MJJS_cut_IA  = [new_tools.cut_3d(omega_MJJS [i], 0, len(lat_pc), idx_lonmin_IA, idx_lonmax_IA) for i in range(len(list_simu))]
omega_MJJS_cut_EA  = [new_tools.cut_3d(omega_MJJS [i], 0, len(lat_pc), idx_lonmin_EA, idx_lonmax_EA) for i in range(len(list_simu))]
'''
mslp_MJJS_cut_IA   = [new_tools.cut_3d(mslp_MJJS  [i], 0, len(lat_pc), idx_lonmin_IA, idx_lonmax_IA) for i in range(len(list_simu))]
mslp_MJJS_cut_EA   = [new_tools.cut_3d(mslp_MJJS  [i], 0, len(lat_pc), idx_lonmin_EA, idx_lonmax_EA) for i in range(len(list_simu))]
'''

#average along lon
w_wind_MJJS_IA     = [np.ma.mean(np.asarray(w_wind_MJJS_cut_IA[i]), axis = 3)  for i in range(len(list_simu))]
w_wind_MJJS_EA     = [np.ma.mean(np.asarray(w_wind_MJJS_cut_EA[i]), axis = 3)  for i in range(len(list_simu))]

v_wind_MJJS_IA     = [np.ma.mean(np.asarray(v_wind_MJJS_cut_IA[i]), axis = 3)  for i in range(len(list_simu))]
v_wind_MJJS_EA     = [np.ma.mean(np.asarray(v_wind_MJJS_cut_EA[i]), axis = 3)  for i in range(len(list_simu))]

temp_MJJS_IA       = [np.ma.mean(np.asarray(temp_MJJS_cut_IA  [i]), axis = 3)  for i in range(len(list_simu))]
temp_MJJS_EA       = [np.ma.mean(np.asarray(temp_MJJS_cut_EA  [i]), axis = 3)  for i in range(len(list_simu))]

omega_MJJS_IA      = [np.ma.mean(np.asarray(omega_MJJS_cut_IA [i]), axis = 3)  for i in range(len(list_simu))]
omega_MJJS_EA      = [np.ma.mean(np.asarray(omega_MJJS_cut_EA [i]), axis = 3)  for i in range(len(list_simu))]
'''
mslp_MJJS_IA       = [np.ma.mean(np.asarray(mslp_MJJS_cut_IA  [i]), axis = 3)  for i in range(len(list_simu))]
mslp_MJJS_EA       = [np.ma.mean(np.asarray(mslp_MJJS_cut_EA  [i]), axis = 3)  for i in range(len(list_simu))]
'''
precip_2mm_msk_cut        = precip_2mm_msk[id_lat_min : id_lat_max + 1, id_lon_min : id_lon_max + 1]
precip_2mm_msk_cut_masked = np.ma.masked_where(precip_2mm_msk_cut != 2, precip_2mm_msk_cut)
precip_2mm_msk_cut_masked[~precip_2mm_msk_cut_masked.mask] = 1

precip_msk         = [np.asarray(precip_MJJS_cut)[i, :, :, :] * precip_2mm_msk_cut_masked[None, :, :] for i in range(len(list_simu))]

precip_mean_MJJS   = []

for i in range(len(list_simu)):
	
	mean = []

	for j in range(len(precip_msk[0])):
	
		mean.append(np.ma.mean(precip_msk[i][j]))
		
	precip_mean_MJJS.append(mean)
	
precip_mean_MJJS_3rq  = [np.quantile(precip_mean_MJJS[i], 0.75)                                   for i in range(len(list_simu))] 
precip_mean_MJJS_1sq  = [np.quantile(precip_mean_MJJS[i], 0.25)                                   for i in range(len(list_simu))] 
'----------------------------------------------------------------------------'
print('CUT REGION DONE')
#pdb.set_trace()

'----------------------------------------------------------------------------'
'MERIDIONAL STRF & VERTICAL VELOCITY'
'----------------------------------------------------------------------------'
psi_EA     = [new_tools.merid_strf(pres, v_wind_MJJS_EA[i], lat_pc)             for i in range(len(list_simu))]
psi_IA     = [new_tools.merid_strf(pres, v_wind_MJJS_IA[i], lat_pc)             for i in range(len(list_simu))]

w_EA       = [new_tools.omega_to_w_zon(temp_MJJS_EA[i], omega_MJJS_EA[i], pres) for i in range(len(list_simu))]
w_IA       = [new_tools.omega_to_w_zon(temp_MJJS_IA[i], omega_MJJS_IA[i], pres) for i in range(len(list_simu))]


lat_cut    = lat_pc[12:41]
idx_100    = tools.find_nearest(pres, 100)
pres_100   = pres[:idx_100 + 1]
psi_EA_cut = np.asarray(psi_EA)[:, :, :idx_100 + 1, 12:41]
psi_IA_cut = np.asarray(psi_IA)[:, :, :idx_100 + 1, 12:41]
w_EA_cut   = np.asarray(w_EA)  [:, :, :idx_100 + 1, 12:41]
w_IA_cut   = np.asarray(w_IA)  [:, :, :idx_100 + 1, 12:41]


#new_tools.zlat_map(lat_cut, pres[:idx_100 + 1], np.asarray(psi_EA)[0, 0, :idx_100 + 1, 12:41])
#new_tools.zlat_map(lat_cut, pres[:idx_100 + 1], np.asarray(psi_IA)[0, 0, :idx_100 + 1, 12:41])
'----------------------------------------------------------------------------'
print('STRF DONE')

#pdb.set_trace()
'----------------------------------------------------------------------------'
'SUBCLOUD MSE - 20 hPa above surface - based on Alex s code'
'----------------------------------------------------------------------------'
'''
cpd      = 1.0047    	     # KJ Kg-1 k-1
cpv      = 1.8461            # kJ?kg??K?  (water vapor)
Lvo      = 2500.8            # KJ Kg-1 k-1
g        = 0.00981   	     # kKJ Kg-1 k-1  (i.e. 9.81 J+0.00981 kJ per m)

ps_hpa   = np.asarray(mslp_MJJS) / 100.
target_p = ps_hpa - 20.

p1       = pres[0] #already hPa
p2       = pres[1]

w        = (p1 - target_p) / (p1 - p2)   
'''
'----------------------------------------------------------------------------'

#pdb.set_trace()
'----------------------------------------------------------'
'MONSOON MAX & MIN'
'----------------------------------------------------------'
psi_EA_cut_min = [new_tools.min_partition(precip_mean_MJJS[i], precip_mean_MJJS_1sq [i], psi_EA_cut[i])     for i in range(len(list_simu))]
psi_EA_cut_max = [new_tools.max_partition(precip_mean_MJJS[i], precip_mean_MJJS_3rq [i], psi_EA_cut[i])     for i in range(len(list_simu))]

psi_IA_cut_min = [new_tools.min_partition(precip_mean_MJJS[i], precip_mean_MJJS_1sq [i], psi_IA_cut[i])     for i in range(len(list_simu))]
psi_IA_cut_max = [new_tools.max_partition(precip_mean_MJJS[i], precip_mean_MJJS_3rq [i], psi_IA_cut[i])     for i in range(len(list_simu))]

w_EA_cut_min   = [new_tools.min_partition(precip_mean_MJJS[i], precip_mean_MJJS_1sq [i], w_EA_cut[i])       for i in range(len(list_simu))]
w_EA_cut_max   = [new_tools.max_partition(precip_mean_MJJS[i], precip_mean_MJJS_3rq [i], w_EA_cut[i])       for i in range(len(list_simu))]

w_IA_cut_min   = [new_tools.min_partition(precip_mean_MJJS[i], precip_mean_MJJS_1sq [i], w_IA_cut[i])       for i in range(len(list_simu))]
w_IA_cut_max   = [new_tools.max_partition(precip_mean_MJJS[i], precip_mean_MJJS_3rq [i], w_IA_cut[i])       for i in range(len(list_simu))]

v_EA_cut_min   = [new_tools.min_partition(precip_mean_MJJS[i], precip_mean_MJJS_1sq [i], v_wind_MJJS_EA[i]) for i in range(len(list_simu))]
v_EA_cut_max   = [new_tools.max_partition(precip_mean_MJJS[i], precip_mean_MJJS_3rq [i], v_wind_MJJS_EA[i]) for i in range(len(list_simu))]

v_IA_cut_min   = [new_tools.min_partition(precip_mean_MJJS[i], precip_mean_MJJS_1sq [i], v_wind_MJJS_IA[i]) for i in range(len(list_simu))]
v_IA_cut_max   = [new_tools.max_partition(precip_mean_MJJS[i], precip_mean_MJJS_3rq [i], v_wind_MJJS_IA[i]) for i in range(len(list_simu))]


psi_EA_min_av  = [np.mean(np.asarray(psi_EA_cut_min[i]), axis = 0)              for i in range(len(list_simu))]
psi_EA_max_av  = [np.mean(np.asarray(psi_EA_cut_max[i]), axis = 0)              for i in range(len(list_simu))]

psi_IA_min_av  = [np.mean(np.asarray(psi_IA_cut_min[i]), axis = 0)              for i in range(len(list_simu))]
psi_IA_max_av  = [np.mean(np.asarray(psi_IA_cut_max[i]), axis = 0)              for i in range(len(list_simu))]
'''
psi_EA_min_MAX = [np.where(psi_EA_min_av[i] == psi_EA_min_av[i].max())          for i in range(len(list_simu))]
psi_EA_max_MAX = [np.where(psi_EA_max_av[i] == psi_EA_max_av[i].max())          for i in range(len(list_simu))]

psi_IA_min_MAX = [np.where(psi_IA_min_av[i] == psi_IA_min_av[i].max())          for i in range(len(list_simu))]
psi_IA_max_MAX = [np.where(psi_IA_max_av[i] == psi_IA_max_av[i].max())          for i in range(len(list_simu))]
'''

w_EA_min_av    = [np.mean(np.asarray(w_EA_cut_min[i]),   axis = 0)              for i in range(len(list_simu))]
w_EA_max_av    = [np.mean(np.asarray(w_EA_cut_max[i]),   axis = 0)              for i in range(len(list_simu))]

w_IA_min_av    = [np.mean(np.asarray(w_IA_cut_min[i]),   axis = 0)              for i in range(len(list_simu))]
w_IA_max_av    = [np.mean(np.asarray(w_IA_cut_max[i]),   axis = 0)              for i in range(len(list_simu))]

v_EA_min_av    = [np.mean(np.asarray(v_EA_cut_min[i])[:, :idx_100 + 1, 12:41],   axis = 0) for i in range(len(list_simu))]
v_EA_max_av    = [np.mean(np.asarray(v_EA_cut_max[i])[:, :idx_100 + 1, 12:41],   axis = 0) for i in range(len(list_simu))]

v_IA_min_av    = [np.mean(np.asarray(v_IA_cut_min[i])[:, :idx_100 + 1, 12:41],   axis = 0) for i in range(len(list_simu))]
v_IA_max_av    = [np.mean(np.asarray(v_IA_cut_max[i])[:, :idx_100 + 1, 12:41],   axis = 0) for i in range(len(list_simu))]
'----------------------------------------------------------'

#pdb.set_trace()

'----------------------------------------------------------'
'PLOT'
'----------------------------------------------------------'
'''
fig  = plt.figure()
ax   = fig.add_subplot(1, 1, 1)
cmap = plt.get_cmap('BrBG')

cl   = plt.contour(lat_cut, pres_100, psi_IA_max_av[0] * 1e-10 - psi_IA_min_av[0] * 1e-10, colors='black', levels = np.arange(-30, 31))
plt.clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')

cs   = plt.contourf(lat_cut, pres_100, psi_IA_max_av[0] * 1e-10 - psi_IA_min_av[0] * 1e-10, cmap = cmap, levels = np.arange(-30, 31))
cbar = plt.colorbar(cs, ax = ax)


cbar .set_label('kg/s x1e10')
plt.title('Hadley circulation MJJS - Indian- Asian sector \n bbc08 All max-min monsoon quant')
plt  .gca().invert_yaxis()
plt.show()
plt.close()



fig  = plt.figure()
ax   = fig.add_subplot(1, 1, 1)
cmap = plt.get_cmap('BrBG')

cl   = plt.contour(lat_cut, pres_100, psi_IA_max_av[1] * 1e-10 - psi_IA_min_av[1] * 1e-10, colors='black', levels = np.arange(-30, 31))
plt.clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')

cs   = plt.contourf(lat_cut, pres_100, psi_IA_max_av[1] * 1e-10 - psi_IA_min_av[1] * 1e-10, cmap = cmap, levels = np.arange(-30, 31))
cbar = plt.colorbar(cs, ax = ax)


cbar .set_label('kg/s x1e10')
plt.title('Hadley circulation MJJS - Indian- Asian sector \n bbc08 OrbGhg max-min monsoon quant')
plt  .gca().invert_yaxis()
plt.show()
plt.close()



fig  = plt.figure()
ax   = fig.add_subplot(1, 1, 1)
cmap = plt.get_cmap('BrBG')

cl   = plt.contour(lat_cut, pres_100, psi_IA_max_av[2] * 1e-10 - psi_IA_min_av[2] * 1e-10, colors='black', levels = np.arange(-30, 31))
plt.clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')

cs   = plt.contourf(lat_cut, pres_100, psi_IA_max_av[2] * 1e-10 - psi_IA_min_av[2] * 1e-10, cmap = cmap, levels = np.arange(-30, 31))
cbar = plt.colorbar(cs, ax = ax)


cbar .set_label('kg/s x1e10')
plt.title('Hadley circulation MJJS -Indian - Asian sector \n bbc08 Orb max-min monsoon quant')
plt  .gca().invert_yaxis()
plt.show()
plt.close()

'''

min_index_IA_min = [np.unravel_index(np.argmin(psi_IA_min_av[i]), psi_IA_min_av[i].shape) for i in range(len(psi_IA_min_av))]
lat_minIA_min    = [lat_cut [min_index_IA_min[i][1]]        for i in range(len(psi_IA_min_av))]
pres_minIA_min   = [pres_100[min_index_IA_min[i][0]]        for i in range(len(psi_IA_min_av))]



fig, axs  = plt.subplots(2, 4, figsize = (26, 10))

cmap      = 'seismic'
levels    = np.arange(-90, 95, 5)

cl = axs[0, 0].contour(lat_cut, pres_100, psi_IA_min_av[0] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[0, 0].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[0, 0].contourf(lat_cut, pres_100, psi_IA_min_av[0] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[0, 0])
cbar .set_label('kg/s x1e10')
axs[0, 0].quiver(lat_cut, pres_100, v_IA_min_av[0], w_IA_min_av[0] * np.absolute(np.mean(v_IA_min_av[0])/np.mean(w_IA_min_av[0])), color = 'black', linewidth=2)
axs[0, 0].set_title('All - min summer precip')
axs[0, 0].invert_yaxis()
axs[0, 0].axvline(x=lat_minIA_min[0], color='limegreen', linewidth=2)


cl = axs[0, 1].contour(lat_cut, pres_100, psi_IA_min_av[1] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[0, 1].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[0, 1].contourf(lat_cut, pres_100, psi_IA_min_av[1] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[0, 1])
cbar .set_label('kg/s x1e10')
axs[0, 1].quiver(lat_cut, pres_100, v_IA_min_av[1], w_IA_min_av[1] * np.absolute(np.mean(v_IA_min_av[1])/np.mean(w_IA_min_av[1])), color = 'black', linewidth=2)
axs[0, 1].set_title('Orb_Ghg - min summer precip')
axs[0, 1].invert_yaxis()
axs[0, 1].axvline(x=lat_minIA_min[1], color='limegreen', linewidth=2)


cl = axs[0, 2].contour(lat_cut, pres_100, psi_IA_min_av[2] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[0, 2].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[0, 2].contourf(lat_cut, pres_100, psi_IA_min_av[2] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[0, 2])
cbar .set_label('kg/s x1e10')
axs[0, 2].quiver(lat_cut, pres_100, v_IA_min_av[2], w_IA_min_av[2] * np.absolute(np.mean(v_IA_min_av[2])/np.mean(w_IA_min_av[2])), color = 'black', linewidth=2)
axs[0, 2].set_title('Orb_Ice - min summer precip')
axs[0, 2].invert_yaxis()
axs[0, 2].axvline(x=lat_minIA_min[2], color='limegreen', linewidth=2)


cl = axs[0, 3].contour(lat_cut, pres_100, psi_IA_min_av[3] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[0, 2].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[0, 3].contourf(lat_cut, pres_100, psi_IA_min_av[3] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[0, 3])
cbar .set_label('kg/s x1e10')
axs[0, 3].quiver(lat_cut, pres_100, v_IA_min_av[3], w_IA_min_av[3] * np.absolute(np.mean(v_IA_min_av[3])/np.mean(w_IA_min_av[3])), color = 'black', linewidth=2)
axs[0, 3].set_title('Orb - min summer precip')
axs[0, 3].invert_yaxis()
axs[0, 3].axvline(x=lat_minIA_min[2], color='limegreen', linewidth=2)


min_index_IA_max = [np.unravel_index(np.argmin(psi_IA_max_av[i]), psi_IA_max_av[i].shape) for i in range(len(psi_IA_max_av))]
lat_minIA_max    = [lat_cut [min_index_IA_max[i][1]]        for i in range(len(psi_IA_max_av))]
pres_minIA_max   = [pres_100[min_index_IA_max[i][0]]        for i in range(len(psi_IA_max_av))]



cl = axs[1, 0].contour(lat_cut, pres_100, psi_IA_max_av[0] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[1, 0].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[1, 0].contourf(lat_cut, pres_100, psi_IA_max_av[0] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[1, 0])
cbar .set_label('kg/s x1e10')
axs[1, 0].quiver(lat_cut, pres_100, v_IA_max_av[0], w_IA_max_av[0] * np.absolute(np.mean(v_IA_max_av[0])/np.mean(w_IA_max_av[0])), color = 'black', linewidth=2)
axs[1, 0].set_title('All - max summer precip')
axs[1, 0].invert_yaxis()
axs[1, 0].axvline(x=lat_minIA_max[0], color='limegreen', linewidth=2)


cl = axs[1, 1].contour(lat_cut, pres_100, psi_IA_max_av[1] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[1, 1].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[1, 1].contourf(lat_cut, pres_100, psi_IA_max_av[1] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[1, 1])
cbar .set_label('kg/s x1e10')
axs[1, 1].quiver(lat_cut, pres_100, v_IA_max_av[1], w_IA_max_av[1] * np.absolute(np.mean(v_IA_max_av[1])/np.mean(w_IA_max_av[1])), color = 'black', linewidth=2)
axs[1, 1].set_title('Orb_Ghg - max summer precip')
axs[1, 1].invert_yaxis()
axs[1, 1].axvline(x=lat_minIA_max[1], color='limegreen', linewidth=2)

cl = axs[1, 2].contour(lat_cut, pres_100, psi_IA_max_av[2] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[1, 2].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[1, 2].contourf(lat_cut, pres_100, psi_IA_max_av[2] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[1, 2])
cbar .set_label('kg/s x1e10')
axs[1, 2].quiver(lat_cut, pres_100, v_IA_max_av[2], w_IA_max_av[2] * np.absolute(np.mean(v_IA_max_av[2])/np.mean(w_IA_max_av[2])), color = 'black', linewidth=2)
axs[1, 2].set_title('Orb_Ice - max summer precip')
axs[1, 2].invert_yaxis()
axs[1, 2].axvline(x=lat_minIA_max[2], color='limegreen', linewidth=2)


cl = axs[1, 3].contour(lat_cut, pres_100, psi_IA_max_av[3] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[1, 2].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[1, 3].contourf(lat_cut, pres_100, psi_IA_max_av[3] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[1, 3])
cbar .set_label('kg/s x1e10')
axs[1, 3].quiver(lat_cut, pres_100, v_IA_max_av[3], w_IA_max_av[3] * np.absolute(np.mean(v_IA_max_av[3])/np.mean(w_IA_max_av[3])), color = 'black', linewidth=2)
axs[1, 3].set_title('Orb - max summer precip')
axs[1, 3].invert_yaxis()
axs[1, 3].axvline(x=lat_minIA_max[3], color='limegreen', linewidth=2)



plt.suptitle('Hadley circulation above Indo-Asian sector in MJJAS for min and max monsoon')
plt.savefig('/user/work/xk22684/work/fig/fig_paper_monsoon/hadley_IA.png')

plt.show()
plt.close()








min_index_EA_min = [np.unravel_index(np.argmin(psi_EA_min_av[i]), psi_EA_min_av[i].shape) for i in range(len(psi_EA_min_av))]
lat_minEA_min    = [lat_cut [min_index_EA_min[i][1]]        for i in range(len(psi_EA_min_av))]
pres_minEA_min   = [pres_100[min_index_EA_min[i][0]]        for i in range(len(psi_EA_min_av))]



fig, axs  = plt.subplots(2, 4, figsize = (26, 10))

cmap      = 'seismic'
levels    = np.arange(-90, 95, 5)

cl = axs[0, 0].contour(lat_cut, pres_100, psi_EA_min_av[0] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[0, 0].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[0, 0].contourf(lat_cut, pres_100, psi_EA_min_av[0] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[0, 0])
cbar .set_label('kg/s x1e10')
axs[0, 0].quiver(lat_cut, pres_100, v_EA_min_av[0], w_EA_min_av[0] * np.absolute(np.mean(v_EA_min_av[0])/np.mean(w_EA_min_av[0])), color = 'black', linewidth=2)
axs[0, 0].set_title('All - min summer precip')
axs[0, 0].invert_yaxis()
axs[0, 0].axvline(x=lat_minEA_min[0], color='limegreen', linewidth=2)


cl = axs[0, 1].contour(lat_cut, pres_100, psi_EA_min_av[1] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[0, 1].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[0, 1].contourf(lat_cut, pres_100, psi_EA_min_av[1] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[0, 1])
cbar .set_label('kg/s x1e10')
axs[0, 1].quiver(lat_cut, pres_100, v_EA_min_av[1], w_EA_min_av[1] * np.absolute(np.mean(v_EA_min_av[1])/np.mean(w_EA_min_av[1])), color = 'black', linewidth=2)
axs[0, 1].set_title('Orb_Ghg - min summer precip')
axs[0, 1].invert_yaxis()
axs[0, 1].axvline(x=lat_minEA_min[1], color='limegreen', linewidth=2)

cl = axs[0, 2].contour(lat_cut, pres_100, psi_EA_min_av[2] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[0, 2].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[0, 2].contourf(lat_cut, pres_100, psi_EA_min_av[2] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[0, 2])
axs[0, 2].quiver(lat_cut, pres_100, v_EA_min_av[2], w_EA_min_av[2] * np.absolute(np.mean(v_EA_min_av[2])/np.mean(w_EA_min_av[2])), color = 'black', linewidth=2)
cbar .set_label('kg/s x1e10')
axs[0, 2].set_title('Orb_Ice - min summer precip')
axs[0, 2].invert_yaxis()
axs[0, 2].axvline(x=lat_minEA_min[2], color='limegreen', linewidth=2)


cl = axs[0, 3].contour(lat_cut, pres_100, psi_EA_min_av[3] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[0, 2].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[0, 3].contourf(lat_cut, pres_100, psi_EA_min_av[3] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[0, 3])
axs[0, 3].quiver(lat_cut, pres_100, v_EA_min_av[3], w_EA_min_av[3] * np.absolute(np.mean(v_EA_min_av[3])/np.mean(w_EA_min_av[3])), color = 'black', linewidth=2)
cbar .set_label('kg/s x1e10')
axs[0, 3].set_title('Orb - min summer precip')
axs[0, 3].invert_yaxis()
axs[0, 3].axvline(x=lat_minEA_min[3], color='limegreen', linewidth=2)


min_index_EA_max = [np.unravel_index(np.argmin(psi_EA_max_av[i]), psi_EA_max_av[i].shape) for i in range(len(psi_EA_max_av))]
lat_minEA_max    = [lat_cut [min_index_EA_max[i][1]]        for i in range(len(psi_EA_max_av))]
pres_minEA_max   = [pres_100[min_index_EA_max[i][0]]        for i in range(len(psi_EA_max_av))]


cl = axs[1, 0].contour(lat_cut, pres_100, psi_EA_max_av[0] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[1, 0].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[1, 0].contourf(lat_cut, pres_100, psi_EA_max_av[0] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[1, 0])
cbar .set_label('kg/s x1e10')
axs[1, 0].quiver(lat_cut, pres_100, v_EA_max_av[0], w_EA_max_av[0] * np.absolute(np.mean(v_EA_max_av[0])/np.mean(w_EA_max_av[0])), color = 'black', linewidth=2)
axs[1, 0].set_title('All - max summer precip')
axs[1, 0].invert_yaxis()
axs[1, 0].axvline(x=lat_minEA_max[0], color='limegreen', linewidth=2)


cl = axs[1, 1].contour(lat_cut, pres_100, psi_EA_max_av[1] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[1, 1].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[1, 1].contourf(lat_cut, pres_100, psi_EA_max_av[1] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[1, 1])
cbar .set_label('kg/s x1e10')
axs[1, 1].quiver(lat_cut, pres_100, v_EA_max_av[1], w_EA_max_av[1] * np.absolute(np.mean(v_EA_max_av[1])/np.mean(w_EA_max_av[1])), color = 'black', linewidth=2)
axs[1, 1].set_title('Orb_Ghg - max summer precip')
axs[1, 1].invert_yaxis()
axs[1, 1].axvline(x=lat_minEA_max[1], color='limegreen', linewidth=2)


cl = axs[1, 2].contour(lat_cut, pres_100, psi_EA_max_av[2] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[1, 2].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[1, 2].contourf(lat_cut, pres_100, psi_EA_max_av[2] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[1, 2])
cbar .set_label('kg/s x1e10')
axs[1, 2].quiver(lat_cut, pres_100, v_EA_max_av[2], w_EA_max_av[2] * np.absolute(np.mean(v_EA_max_av[2])/np.mean(w_EA_max_av[2])), color = 'black', linewidth=2)
axs[1, 2].set_title('Orb_Ice - max summer precip')
axs[1, 2].invert_yaxis()
axs[1, 2].axvline(x=lat_minEA_max[2], color='limegreen', linewidth=2)



cl = axs[1, 3].contour(lat_cut, pres_100, psi_EA_max_av[3] * 1e-10, colors='black', levels = levels, alpha = 0.2)
#axs[1, 2].clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')
cs = axs[1, 3].contourf(lat_cut, pres_100, psi_EA_max_av[3] * 1e-10, cmap = cmap, levels = levels)
cbar = plt.colorbar(cs, ax = axs[1, 3])
cbar .set_label('kg/s x1e10')
axs[1, 3].quiver(lat_cut, pres_100, v_EA_max_av[3], w_EA_max_av[3] * np.absolute(np.mean(v_EA_max_av[3])/np.mean(w_EA_max_av[3])), color = 'black', linewidth=2)
axs[1, 3].set_title('Orb - max summer precip')
axs[1, 3].invert_yaxis()
axs[1, 3].axvline(x=lat_minEA_max[3], color='limegreen', linewidth=2)



plt.suptitle('Hadley circulation above East-Asian sector in MJJAS for min and max monsoon')
plt.savefig('/user/work/xk22684/work/fig/fig_paper_monsoon/hadley_EA.png')
plt.show()
plt.close()







pdb.set_trace()

fig  = plt.figure()
ax   = fig.add_subplot(1, 1, 1)
cmap = plt.get_cmap('seismic')

cl   = plt.contour(lat_cut, pres_100, psi_IA_min_av[0] * 1e-10, colors='black', levels = np.arange(-90, 95, 5))
plt.clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')

cs   = plt.contourf(lat_cut, pres_100, psi_IA_min_av[0] * 1e-10, cmap = cmap, levels = np.arange(-90, 95, 5))
cbar = plt.colorbar(cs, ax = ax)

ax.quiver(lat_cut, pres_100, v_IA_min_av[0], w_IA_min_av[0] * np.mean(v_IA_min_av[0])/np.mean(w_IA_min_av[0]), color = 'grey')

cbar .set_label('kg/s x1e10')
plt.title('Hadley circulation MJJS - India- Asian sector \n All min monsoon - < 0.25 quantile')
plt  .gca().invert_yaxis()
plt.show()
plt.close()




fig  = plt.figure()
ax   = fig.add_subplot(1, 1, 1)
cmap = plt.get_cmap('seismic')

cl   = plt.contour(lat_cut, pres_100, psi_IA_max_av[0] * 1e-10, colors='black', levels = np.arange(-90, 95, 5))
plt.clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')

cs   = plt.contourf(lat_cut, pres_100, psi_IA_max_av[0] * 1e-10, cmap = cmap, levels = np.arange(-90, 95, 5))
cbar = plt.colorbar(cs, ax = ax)

ax.quiver(lat_cut, pres_100, v_IA_max_av[0], w_IA_max_av[0] * np.mean(v_IA_max_av[0])/np.mean(w_IA_max_av[0]), color = 'grey')

cbar .set_label('kg/s x1e10')
plt.title('Hadley circulation MJJS - India- Asian sector \n bbc08 All monsoon  - > 0.75 quantile')
plt  .gca().invert_yaxis()
plt.show()
plt.close()






fig  = plt.figure()
ax   = fig.add_subplot(1, 1, 1)
cmap = plt.get_cmap('seismic')

cl   = plt.contour(lat_cut, pres_100, psi_IA_min_av[1] * 1e-10, colors='black', levels = np.arange(-90, 95, 5))
plt.clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')

cs   = plt.contourf(lat_cut, pres_100, psi_IA_min_av[1] * 1e-10, cmap = cmap, levels = np.arange(-90, 95, 5))
cbar = plt.colorbar(cs, ax = ax)

ax.quiver(lat_cut, pres_100, v_IA_min_av[1], w_IA_min_av[1] * np.mean(v_IA_min_av[1])/np.mean(w_IA_min_av[1]), color = 'grey')

cbar .set_label('kg/s x1e10')
plt.title('Hadley circulation MJJS - India- Asian sector \n OrbGhg min monsoon - < 0.25 quantile')
plt  .gca().invert_yaxis()
plt.show()
plt.close()




fig  = plt.figure()
ax   = fig.add_subplot(1, 1, 1)
cmap = plt.get_cmap('seismic')

cl   = plt.contour(lat_cut, pres_100, psi_IA_max_av[1] * 1e-10, colors='black', levels = np.arange(-90, 95, 5))
plt.clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')

cs   = plt.contourf(lat_cut, pres_100, psi_IA_max_av[1] * 1e-10, cmap = cmap, levels = np.arange(-90, 95, 5))
cbar = plt.colorbar(cs, ax = ax)

ax.quiver(lat_cut, pres_100, v_IA_max_av[1], w_IA_max_av[1] * np.mean(v_IA_max_av[1])/np.mean(w_IA_max_av[1]), color = 'grey')

cbar .set_label('kg/s x1e10')
plt.title('Hadley circulation MJJS - India- Asian sector \n  OrbGhg monsoon - > 0.75 quantile')
plt  .gca().invert_yaxis()
plt.show()
plt.close()






fig  = plt.figure()
ax   = fig.add_subplot(1, 1, 1)
cmap = plt.get_cmap('seismic')

cl   = plt.contour(lat_cut, pres_100, psi_IA_min_av[2] * 1e-10, colors='black', levels = np.arange(-90, 95, 5))
plt.clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black')

cs   = plt.contourf(lat_cut, pres_100, psi_IA_min_av[2] * 1e-10, cmap = cmap, levels = np.arange(-90, 95, 5))
cbar = plt.colorbar(cs, ax = ax)

ax.quiver(lat_cut, pres_100, v_IA_min_av[2], w_IA_min_av[2] * np.mean(v_IA_min_av[2])/np.mean(w_IA_min_av[2]), color = 'grey')

cbar .set_label('kg/s x1e10')
plt.title('Hadley circulation MJJS - India- Asian sector \n Orb min monsoon - < 0.25 quantile')
plt  .gca().invert_yaxis()
plt.show()
plt.close()




fig  = plt.figure()
ax   = fig.add_subplot(1, 1, 1)
cmap = plt.get_cmap('seismic')

cl   = plt.contour(lat_cut, pres_100, psi_IA_max_av[2] * 1e-10, colors='black', levels = np.arange(-90, 95, 5))
plt.clabel(cl, fmt=' {:.1f} '.format, fontsize='x-large', colors = 'black', alpha = 0.5)

cs   = plt.contourf(lat_cut, pres_100, psi_IA_max_av[2] * 1e-10, cmap = cmap, levels = np.arange(-90, 95, 5))
cbar = plt.colorbar(cs, ax = ax)

ax.quiver(lat_cut, pres_100, v_IA_max_av[2], w_IA_max_av[2] * np.mean(v_IA_max_av[2])/np.mean(w_IA_max_av[2]), color = 'grey')

cbar .set_label('kg/s x1e10')
plt.title('Hadley circulation MJJS - India- Asian sector \n  Orb monsoon - > 0.75 quantile')
plt  .gca().invert_yaxis()
plt.show()
plt.close()




'----------------------------------------------------------'


pdb.set_trace()


'''
psi_IA  = np.zeros((len(list_simu), len(tools.list_time), len(dsigmah), len(lat_pc)))
psi_EA  = np.zeros((len(list_simu), len(tools.list_time), len(dsigmah), len(lat_pc)))

for i in range(len(list_simu)):

	for f in range(len(tools.list_time)):
	
		for s in range(len(dsigmah) - 1):
		
			for l in range(len(lat_pc)):
			
				strf_IA = dsigmah[s] * np.asarray(v_wind_MJJS_IA)[i, f, s, l] * np.cos(lat_pc[l] * rad)
				
				psi_IA[i, f, s+1, l] = psi_IA[i, f, s, l] - strf_IA
		 
			
				strf_EA = dsigmah[s] * np.asarray(v_wind_MJJS_EA)[i, f, s, l] * np.cos(lat_pc[l] * rad)
				
				psi_EA[i, f, s+1, l] = psi_EA[i, f, s, l] - strf_EA
		 
print('STRF COMPUTED')

scale   = 1e5 * (2 * np.pi * a / g)
psi_EA  =  psi_EA * scale / 8e11

lat_cut = lat_pc[12:41]

new_tools.zlat_map(lat_cut, pres[::-1], psi_EA[0, 0, :, 12:41])

'''

'''
#Define csts
rad    = np.pi/180
a      = 6371000.   #Earth radius in m 
g      = 9.81       #gravital acceleration m/s^2

#Create an array sigmah with one more level than the pressure levels.
n_lev  = len(pres)

sigmah = [100.0] 

for i in range(1, len(pres)):
	
	sigmah.append(0.5* (pres[i] + pres[i-1])/10)
	
sigmah.append(0.1)

dsigmah = np.asarray(sigmah[:-1]) - np.asarray(sigmah[1:])

coslat    = np.cos(lat_pc * rad)

psi_IA    = np.zeros((len(list_simu), len(tools.list_time), len(dsigmah), len(lat_pc)))
psi_EA    = np.zeros((len(list_simu), len(tools.list_time), len(dsigmah), len(lat_pc)))

v_wind_IA = np.asarray(v_wind_MJJS_IA)
v_wind_EA = np.asarray(v_wind_MJJS_EA)

for i in range(len(list_simu)):

	for f in range(len(tools.list_time)):
	
		strf_IA = dsigmah[:, None] * v_wind_IA[i, f, :, :] * coslat[None, :]
		psi_IA[i, f, 1:, :] = -np.cumsum(strf_IA[:-1, :], axis=0)	
	
		strf_EA = dsigmah[:, None] * v_wind_EA[i, f, :, :] * coslat[None, :]
		psi_EA[i, f, 1:, :] = -np.cumsum(strf_EA[:-1, :], axis=0)	

scale  = 1e5 * (2 * np.pi * a / g)
psi_IA =  psi_IA * scale / 8e11
psi_EA =  psi_EA * scale / 8e11
'''
