import tools 
import numpy as np 
import netCDF4 as nc 
import os
import matplotlib.pyplot as plt
import pandas as pd 
import pdb
from scipy.stats.stats import pearsonr
import new_tools

'-----------------------------------------------------------------'
'FUNCTIONS'
'-----------------------------------------------------------------'
def get_clfiles(list_simu, season):
	
	nc_files = []
	
	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/climate/' + simu + 'a.pdcl' + season + '.nc'))
	
	return nc_files 



def get_clofiles(list_simu, season):
	
	nc_files = []
	
	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/climate/' + simu + 'o.pfcl' + season + '.nc'))
	
	return nc_files 



def get_mskfiles(list_simu):
	
	nc_files = []
	
	for i, simu in enumerate(list_simu):

		nc_files.append(nc.Dataset('/user/home/ggpjv/swsvalde/ummodel/data_olig/' + simu + '/inidata/' + simu + '.qrparm.mask.nc'))
	
	return nc_files 
	


def get_var(nomvar, nc_files):
	
	var = []
	
	for i, f in enumerate(nc_files):

		var     .append(f.variables[nomvar][:])
	
	return var 
'-----------------------------------------------------------------'


'-----------------------------------------------------------------'
'DOMAIN DEMARCATION'
'-----------------------------------------------------------------'
lato_min, lato_max                 = 26, 0 #same for three domains 

lon_min_bengal,  lon_max_bengal  = 78, 100
lon_min_arabian, lon_max_arabian = 45, 78
lon_min_ch,      lon_max_ch      = 105, 130 


lat_min, lat_max                 = 50, 0   #for LST
lon_min, lon_max                 = 60, 130




#delta18O
lat_arab,    lon_arab            = 16.62, 59.8
lat_bob1446, lon_bob1446         = 19.08, 85.73
lat_bob758,  lon_bob758          = 5.58, 90.36
lat_scs,     lon_scs             = 9.38, 113.29
lat_hulu,    lon_hulu            = 32.5, 119.17

#loess
lat_lingT,   lon_lingT           = 35.04, 107.39
lat_JY,      lon_JY              = 36.35, 104.6
lat_XF,      lon_XF              = 35.75, 107.82
lat_LC,      lon_LC              = 35.75, 109.42

#Mg/Ca
lat_govil,   lon_govil           = 14.03, 82
lat_govilAS, lon_govilAS         = 14.5, 72.66
lat_panmei,  lon_panmei          = 16.06, 82.02
lat_tarique, lon_tarique         = 9.01,  72.09
lat_wei,     lon_wei             = 20.05, 117.42
'-----------------------------------------------------------------'


'-----------------------------------------------------------------'
'DATA RECOVERY'
'-----------------------------------------------------------------'
os.chdir(os.pardir) 

'MODEL'
list_simu          = tools.list_simu_08

nc_ofiles_jjs      = get_clofiles(list_simu, 'jjs') 
sst_jjs            = get_var('temp_mm_uo', nc_ofiles_jjs)
lato, lono         = nc_ofiles_jjs[0].variables['latitude'][:], nc_ofiles_jjs[0].variables['longitude'][:]
for j in range(len(nc_ofiles_jjs)):
	nc_ofiles_jjs[j].close()

nc_ofiles_may      = get_clofiles(list_simu, 'may') 
sst_may            = get_var('temp_mm_uo', nc_ofiles_may)
for j in range(len(nc_ofiles_may)):
	nc_ofiles_may[j].close()
	

nc_ofiles_ann      = get_clofiles(list_simu, 'ann') 
sst_ann            = get_var('temp_mm_uo', nc_ofiles_ann)
for j in range(len(nc_ofiles_ann)):
	nc_ofiles_ann[j].close()
	
	
sst = [(4*np.asarray(sst_jjs[i]) + np.asarray(sst_may[i]))/5 for i in range(len(list_simu))]
sst_mgCA = sst_ann


nc_files_jjs       = get_clfiles(list_simu, 'jjs') 
tempe_jjs          = get_var('temp_mm_srf',   nc_files_jjs)
precip_jjs         = get_var('precip_mm_srf', nc_files_jjs) 
lat, lon           = nc_files_jjs[0].variables['latitude'][:], nc_files_jjs[0].variables['longitude'][:]
for j in range(len(nc_files_jjs)):
	nc_files_jjs[j].close()
	
	
	
nc_files_may       = get_clfiles(list_simu, 'may') 
tempe_may          = get_var('temp_mm_srf',   nc_files_may)
precip_may         = get_var('precip_mm_srf', nc_files_may) 
for j in range(len(nc_files_may)):
	nc_files_may[j].close()
	
	
nc_files_jja       = get_clfiles(list_simu, 'jja') 
tempe_jja          = get_var('temp_mm_srf',   nc_files_jja)
for j in range(len(nc_files_jja)):
	nc_files_jja[j].close()	
	
nc_files_mam       = get_clfiles(list_simu, 'mam') 
tempe_mam          = get_var('temp_mm_srf',   nc_files_mam)
for j in range(len(nc_files_mam)):
	nc_files_mam[j].close()		
	
nc_files_son       = get_clfiles(list_simu, 'son') 
tempe_son          = get_var('temp_mm_srf',   nc_files_son)
for j in range(len(nc_files_son)):
	nc_files_son[j].close()	
	

tempe_MN           = [(np.asarray(tempe_jja[i]) + np.asarray(tempe_mam[i]) + np.asarray(tempe_son[i]))/3 for i in range(len(list_simu))]


nc_files_ann       = get_clfiles(list_simu, 'ann') 
tempe_ann          = get_var('temp_mm_srf',   nc_files_ann)
precip_ann         = get_var('precip_mm_srf', nc_files_ann) 
for j in range(len(nc_files_ann)):
	nc_files_ann[j].close()
	

tempe  = [(4*np.asarray(tempe_jjs [i]) + np.asarray(tempe_may [i]))/5 for i in range(len(list_simu))]
precip = [(4*np.asarray(precip_jjs[i]) + np.asarray(precip_may[i]))/5 for i in range(len(list_simu))]

nc_masks           = get_mskfiles(list_simu)
msk                = get_var('lsm', nc_masks)
new_tools.close_files(nc_masks)

#pdb.set_trace()

#tempe  = tempe_ann
#precip = precip_ann 


'PROX'

#delta 18O
sea_prox           = pd.read_csv('/user/work/xk22684/work/data/prox_monsoon/Sun_marine_proxy.csv')
speleo_prox        = pd.read_csv('/user/work/xk22684/work/data/prox_monsoon/speleo_iso18O_Sun2022.csv')

arabian_age        = sea_prox['Age(ka)']
arabian_iso        = sea_prox['d18Op'] 

BoB_1_age          = sea_prox['Age(ka).2']
#BoB_1_iso          = sea_prox['d18Op.1'].fillna(0)
BoB_1_iso          = sea_prox['d18Op.1'].fillna(0)

BoB_2_age          = sea_prox['Age(ka).4']
BoB_2_iso          = sea_prox['d18Op.3']

South_China_age    = sea_prox['Age(ka).3']
South_China_iso    = sea_prox['d18Op.2']

speleo_age         = speleo_prox['Hulu/Sanbao Age (Ka)']
speleo_iso         = speleo_prox['Speleothem 18O']


#mg/ca
Tarique_2023       = pd.read_excel('/user/work/xk22684/work/data/prox_monsoon/Tarique2023.xlsx')  #Arabian sea
Govil_2011         = pd.read_excel('/user/work/xk22684/work/data/prox_monsoon/Govil_2011.xlsx')   #Bay of Bengal
Wei_2007           =  pd.read_excel('/user/work/xk22684/work/data/prox_monsoon/Wei.xlsx')         # South China Sea

Tarique_age        = Tarique_2023['Age [ka BP]']
Tarique_SST        = Tarique_2023['SST [C]']

Govil_age          = Govil_2011['Age [ka BP]']
Govil_SST          = Govil_2011['SST (1-12) [C]']

Wei_age            = Wei_2007['Age [ka BP]']
Wei_SST            = Wei_2007['SST (1-12) [C]']

#loess
Sun_loess_2022     = pd.read_excel('/user/work/xk22684/work/data/prox_monsoon/Sun-QSR2022-proxy-data.xls', 'loess proxies')
Lu_2019_luochuan   = pd.read_excel('/user/work/xk22684/work/data/prox_monsoon/Luochuan_Xifeng_800.xlsx',   'Luochuan')
Lu_2019_xifeng1    = pd.read_excel('/user/work/xk22684/work/data/prox_monsoon/Luochuan_Xifeng_800.xlsx',   'Xifeng 1')
Lu_2019_xifeng2    = pd.read_excel('/user/work/xk22684/work/data/prox_monsoon/Luochuan_Xifeng_800.xlsx',   'Xifeng 2')
lingtai_2022       = pd.read_excel('/user/work/xk22684/work/data/prox_monsoon/lingtai_temperature.xlsx') # lat = 35.04, lon = 107.39


#Sun - quartz size
JY_age             = Sun_loess_2022['Age (ka) JY']
JY_LST             = Sun_loess_2022['Mean JY']

XF_age             = Sun_loess_2022['Age (ka) XF']
XF_LST             = Sun_loess_2022['Qtz Mean XF']

LC_age             = Sun_loess_2022['New Age LC']
LC_LST             = Sun_loess_2022['Mean LC']

#Lu temperature degree C
LC_Lu_age          = Lu_2019_luochuan['Age(ka)']
LC_Lu_LST          = Lu_2019_luochuan['3-point moving average LSTs']

XF1_Lu_age         = Lu_2019_xifeng1['Age(ka)']
XF1_Lu_LST         = Lu_2019_xifeng1['3-point moving average LSTs']

XF2_Lu_age         = Lu_2019_xifeng2['Age(ka)']
XF2_Lu_LST         = Lu_2019_xifeng2['3-point moving average LSTs']

XF_Lu_age          = np.concatenate((np.asarray(XF1_Lu_age), np.asarray(XF2_Lu_age)))
XF_Lu_LST          = np.concatenate((np.asarray(XF1_Lu_LST), np.asarray(XF2_Lu_LST)))

lingtai_age        = lingtai_2022['Age (Ma)']
lingtai_LST        = lingtai_2022['MATmrs']
lingtai_LSTBay     = lingtai_2022['BayMBT0']
'-----------------------------------------------------------------'


'-----------------------------------------------------------------'
'DATA CUT'
'-----------------------------------------------------------------'

idx = []
idx.append(tools.select_domain(lat, lon, lat_min, lat_max, lon_min, lon_max))

tempe_cut          = tools.cut(tempe,  idx[0][0], idx[0][1], idx[0][2], idx[0][3]) 
masks_cut          = tools.cut(msk, idx[0][0], idx[0][1], idx[0][2], idx[0][3]) 
tempe_land         = tools.mask_application(tempe_cut, masks_cut, 'land') 


tempe_mean   = tools.averages(tempe_land,  conv_2 = -273.15)

idx_ar, idx_bob, idx_chi = [], [], []

idx_ar. append(tools.select_domain(lato, lono, lato_max, lato_min, lon_min_arabian, lon_max_arabian))
idx_bob.append(tools.select_domain(lato, lono, lato_max, lato_min, lon_min_bengal, lon_max_bengal))
idx_chi.append(tools.select_domain(lato, lono, lato_max, lato_min, lon_min_ch,     lon_max_ch))

#delta18O
idx_lat_arab       = tools.find_nearest(lato, lat_arab)
idx_lon_arab       = tools.find_nearest(lono, lon_arab)

idx_lat_bob1446    = tools.find_nearest(lato, lat_bob1446)
idx_lon_bob1446    = tools.find_nearest(lono, lon_bob1446)

idx_lat_bob758     = tools.find_nearest(lato, lat_bob758)
idx_lon_bob758     = tools.find_nearest(lono, lon_bob758)

idx_lat_scs        = tools.find_nearest(lato, lat_scs)
idx_lon_scs        = tools.find_nearest(lono, lon_scs)

idx_lat_hulu       = tools.find_nearest(lat, lat_hulu)
idx_lon_hulu       = tools.find_nearest(lon, lon_hulu)


#mg/ca
idx_lat_govil      = tools.find_nearest(lato, lat_govil)
idx_lon_govil      = tools.find_nearest(lono, lon_govil)

idx_lat_tarique    = tools.find_nearest(lato, lat_tarique)
idx_lon_tarique    = tools.find_nearest(lono, lon_tarique)

idx_lat_wei        = tools.find_nearest(lato, lat_wei)
idx_lon_wei        = tools.find_nearest(lono, lon_wei)


#loess
idx_lat_lingT      = tools.find_nearest(lat, lat_lingT)
idx_lon_lingT      = tools.find_nearest(lon, lon_lingT)

idx_lat_JY         = tools.find_nearest(lat, lat_JY)
idx_lon_JY         = tools.find_nearest(lon, lon_JY)

idx_lat_XF         = tools.find_nearest(lat, lat_XF)
idx_lon_XF         = tools.find_nearest(lon, lon_XF)

idx_lat_LC         = tools.find_nearest(lat, lat_LC)
idx_lon_LC         = tools.find_nearest(lon, lon_LC)


sst_arab           = [sst[i][0, 0, idx_lat_arab,     idx_lon_arab]    for i in range(len(sst))]
sst_bob1446        = [sst[i][0, 0, idx_lat_bob1446,  idx_lon_bob1446] for i in range(len(sst))]
sst_bob758         = [sst[i][0, 0, idx_lat_bob758,   idx_lon_bob758]  for i in range(len(sst))]
sst_scs            = [sst[i][0, 0, idx_lat_scs,      idx_lon_scs]     for i in range(len(sst))]
sst_govil          = [sst_ann[i][0, 0, idx_lat_govil,    idx_lon_govil]   for i in range(len(sst))]
sst_tarique        = [sst_ann[i][0, 0, idx_lat_tarique,  idx_lon_tarique] for i in range(len(sst))]
sst_wei            = [sst_ann[i][0, 0, idx_lat_wei,  idx_lon_wei] for i in range(len(sst))]


precip_hulu        = [precip[i][0, 0, idx_lat_hulu,  idx_lon_hulu]    for i in range(len(precip))]
temp_hulu          = [tempe [i][0, 0, idx_lat_hulu,  idx_lon_hulu]    for i in range(len(tempe)) ]
temp_lingT         = [tempe_MN [i][0, 0, idx_lat_lingT, idx_lon_lingT]   for i in range(len(tempe)) ]
temp_JY            = [tempe_MN [i][0, 0, idx_lat_JY,    idx_lon_JY]      for i in range(len(tempe)) ]
temp_XF            = [tempe_MN [i][0, 0, idx_lat_XF,    idx_lon_XF]      for i in range(len(tempe)) ]
temp_LC            = [tempe_MN [i][0, 0, idx_lat_LC,    idx_lon_LC]      for i in range(len(tempe)) ]

#delta18O
arabian_idx        = tools.find_nearest(arabian_age, 800) 
arabian_age800     = arabian_age.iloc[:arabian_idx + 1]
arabian_iso800     = arabian_iso.iloc[:arabian_idx + 1]

BoB_1_idx          = tools.find_nearest(BoB_1_age, 800)
BoB_1_age800       = BoB_1_age.iloc[:BoB_1_idx + 1]
BoB_1_iso800       = BoB_1_iso.iloc[:BoB_1_idx + 1]

BoB_2_idx          = tools.find_nearest(BoB_2_age, 800)
BoB_2_age800       = BoB_2_age.iloc[:BoB_2_idx + 1]
BoB_2_iso800       = BoB_2_iso.iloc[:BoB_2_idx + 1]

South_China_idx    = tools.find_nearest(South_China_age, 800)
South_China_age800 = South_China_age.iloc[:South_China_idx + 1]
South_China_iso800 = South_China_iso.iloc[:South_China_idx + 1]

speleo_idx         = tools.find_nearest(speleo_age, 800)
speleo_age800      = speleo_age.iloc[:speleo_idx + 1]
speleo_iso800      = speleo_iso.iloc[:speleo_idx + 1]


#MgCa
idx_Govil          = tools.find_nearest(np.asarray(tools.list_time), max(Govil_age))
list_timeGovil     = tools.list_time[idx_Govil : ]
sst_cutgovil       = sst_govil[idx_Govil : ]

idx_tarique        = tools.find_nearest(np.asarray(tools.list_time), max(Tarique_age))
list_timetarique   = tools.list_time[idx_tarique : ]
sst_cuttarique     = sst_tarique[idx_tarique : ]
sst_arab_cut       = sst_arab[idx_tarique : ]

idx_wei            = tools.find_nearest(np.asarray(tools.list_time), max(Wei_age))
list_timewei       = tools.list_time[idx_wei : ]
sst_cutwei         = sst_wei[idx_wei : ]
sst_scs_cut        = sst_scs[idx_wei : ]

#loess
lingT_idx          = tools.find_nearest(lingtai_age, 0.8)
lingT_age800       = lingtai_age.iloc[:lingT_idx + 1]
lingT_temp800      = lingtai_LST.iloc[:lingT_idx + 1]
lingT_LSTBay800    = lingtai_LSTBay.iloc[:lingT_idx + 1]

JY_idx             = tools.find_nearest(JY_age, 800)
JY_age800          = JY_age.iloc[:JY_idx + 1]
JY_LST800          = JY_LST.iloc[:JY_idx + 1]

XF_idx             = tools.find_nearest(XF_age, 800)
XF_age800          = XF_age.iloc[:XF_idx + 1]
XF_LST800          = XF_LST.iloc[:XF_idx + 1]

LC_idx             = tools.find_nearest(LC_age, 800)
LC_age800          = LC_age.iloc[:LC_idx + 1]
LC_LST800          = LC_LST.iloc[:LC_idx + 1]

idx_XF_Lu          = tools.find_nearest(np.asarray(tools.list_time), max(XF_Lu_age))
list_time_XF_Lu    = tools.list_time[idx_XF_Lu:]
temp_XF_cut_Lu     = temp_XF[idx_XF_Lu:]


idx_LT             = tools.find_nearest(np.asarray(tools.list_time), min(lingT_age800*1e3))
list_time_LT       = tools.list_time[:idx_LT]
temp_LT_cut        = temp_lingT[:idx_LT]

#temp_hulu          = [tempe [i][0, 0, idx_lat_hulu,  idx_lon_hulu]    for i in range(len(tempe)) ]
'-----------------------------------------------------------------'

'-----------------------------------------------------------------'
'CORRELATION'
'-----------------------------------------------------------------'
print('Arabian sea Mg/Ca: ')
tools.corr_prox(Tarique_age, list_timetarique, Tarique_SST, sst_cuttarique)
print('')

print('BoB Mg/Ca: ')
tools.corr_prox(Govil_age, list_timeGovil, Govil_SST, sst_cutgovil)
print('')


print('SCs mg/ca: ')
tools.corr_prox(Wei_age, list_timewei, Wei_SST, sst_cutwei)
print('')


print('Xifeng: ')
tools.corr_prox(XF_Lu_age, list_time_XF_Lu, XF_Lu_LST, np.asarray(temp_XF_cut_Lu) - 273.15)
print('')


print('Luochan: ')
tools.corr_prox(LC_Lu_age, tools.list_time, LC_Lu_LST, np.asarray(temp_LC) - 273.15)
print('')



print('Lingtai: ')
tools.corr_prox(lingT_age800 * 1e3, list_time_LT, lingT_temp800, np.asarray(temp_LT_cut) - 273.15)
print('')
'-----------------------------------------------------------------'
pdb.set_trace()

'-----------------------------------------------------------------'
'PLOT'
'-----------------------------------------------------------------'

fig, axes = plt.subplots(nrows=6, ncols=1, figsize=(10, 12))

axes[0].plot(list_timetarique, sst_cuttarique, '-o', color = 'black')
#axes[0].plot(list_timetarique, sst_arab_cut, '-o', color = 'black')

axes[0].grid()
axes[0].set_title('Arabian Sea SST  (lat: 9.01, lon: 72.09) ann model vs Mg/Ca')
axes[0].set_ylabel('SST ($^\circ$C)', color='k')
axes[0].plot(Tarique_age, Tarique_SST, '-x', color='purple', alpha = 0.7)


axes[1].plot(list_timeGovil, sst_cutgovil, '-o', color = 'black')
axes[1].grid()
axes[1].set_title('Bay of Bengal SST ann(lat: 14.03, lon: 82.00) ann model vs Mg/Ca')
axes[1].set_ylabel('SST ($^\circ$C)', color='k')
axes[1].plot(Govil_age, Govil_SST, '-x', color='purple', alpha = 0.7)

axes[2].plot(list_timewei, sst_cutwei, '-o', color = 'black')
#axes[2].plot(list_timewei, sst_scs_cut, '-o', color = 'black')

axes[2].grid()
axes[2].set_title('South China Sea SST ann (lat: 20.05, lon: 117.42) ann model vs Mg/Ca')
axes[2].set_ylabel('SST ($^\circ$C)', color='k')
axes[2].plot(Wei_age, Wei_SST, '-x', color='purple', alpha = 0.7)



axes[3].plot(list_time_XF_Lu,  np.asarray(temp_XF_cut_Lu) - 273.15, '-o', color = 'black')
#axes[3].plot(list_time_XF_Lu,  np.asarray(tempe_mean[idx_XF_Lu:]), '-o', color = 'black')
axes[3].grid()
axes[3].set_title('Xifeng LST (lat: 35.75, lon: 109.42) MAMJJASON model vs Loess')
axes[3].set_ylabel('LST ($^\circ$C)', color='k')
axes[3].plot(XF_Lu_age, XF_Lu_LST, '-x', color='teal', alpha = 0.7)

axes[4].plot(tools.list_time, np.asarray(temp_LC) - 273.15, '-o',  color = 'black')
axes[4].grid()
axes[4].set_title('Luochan LST (lat: 35.75, lon: 109.42) MAMJJASON model vs Loess')
axes[4].set_ylabel('LST ($^\circ$C)', color='k')
axes[4].plot(LC_Lu_age, LC_Lu_LST, '-x', color='teal', alpha = 0.7)

axes[5].plot(list_time_LT, np.asarray(temp_LT_cut) - 273.15, '-o', color = 'black')
axes[5].grid()
axes[5].set_title('Lingtai LST (lat: 35.04, lon: 107.39) MAMJJASON model vs Loess')
axes[5].set_ylabel('LST ($^\circ$C)', color='k')
axes[5].plot(lingT_age800 * 1e3, lingT_temp800, '-x', color='teal', alpha = 0.7)

plt.tight_layout()
plt.savefig('/user/work/xk22684/work/fig/fig_paper_monsoon/fig_proxLST.png')
plt.show()
plt.close()


pdb.set_trace()

fig, axes = plt.subplots(nrows=6, ncols=1, figsize=(10, 12))

# === Plot 1: Main SST plot on left y-axis ===
axes[0].plot(tools.list_time, sst_arab, '-o', color='k', label='SST')
axes[0].grid()
axes[0].set_title('Arabian Sea (lat: 16.62, lon: 59.8) MJJAS model vs $\delta^{18}$O core 722', size='large')
axes[0].set_ylabel('SST ($^\circ$C)', color='k')

# === Create a secondary y-axis for isotopes ===
ax2 = axes[0].twinx()
ax2.plot(arabian_age800, arabian_iso800, '-x', color='olive', label=r'$\delta^{18}$O', alpha = 0.7)
ax2.set_ylabel(r'$\delta^{18}$O', color='olive')
ax2.invert_yaxis()  # Reverse the isotope axis (common for ?18O)

# Optional: color tick labels to match line colors
axes[0].tick_params(axis='y', labelcolor = 'k')
ax2.tick_params(axis='y',     labelcolor = 'olive')

# === Plot 2: leave as placeholder or add content ===
axes[1].plot(tools.list_time, sst_scs, '-o', color = 'black')
axes[1].grid()
axes[1].set_title('South China Sea (lat: 9.36, lon: 113.29) MJJAS model vs $\delta^{18}$O core 1143', size = 'large')
axes[1].set_ylabel('SST ($^\circ$C)', color='k')
ax2 = axes[1].twinx()
ax2.plot(South_China_age800, South_China_iso800,'-x', color = 'olive', label=r'$\delta^{18}$O', alpha = 0.7)
ax2.set_ylabel(r'$\delta^{18}$O', color = 'olive')
ax2.invert_yaxis()  
ax2.tick_params(axis='y', labelcolor = 'olive')

axes[2].plot(tools.list_time, sst_bob758, '-o', color = 'black')
axes[2].grid()
axes[2].set_title('Bay of Bengal (lat: 5.38, lon: 90.36) MJJAS model vs $\delta^{18}$O core 758', size = 'large')
axes[2].set_ylabel('SST ($^\circ$C)', color='k')
ax2 = axes[2].twinx()
ax2.plot(BoB_1_age800, BoB_1_iso800, '-x', color = 'olive', label=r'$\delta^{18}$O', alpha = 0.7)
ax2.set_ylabel(r'$\delta^{18}$O', color = 'olive')
ax2.invert_yaxis()  
ax2.tick_params(axis='y', labelcolor = 'olive')

axes[3].plot(tools.list_time, sst_bob1446, '-o', color = 'black')
axes[3].grid()
axes[3].set_title('Bay of Bengal (lat: 19.08, lon: 85.73) MJJAS model vs $\delta^{18}$O core 1446', size = 'large')
axes[3].set_ylabel('SST ($^\circ$C)', color='k')
ax2 = axes[3].twinx()
ax2.plot(BoB_2_age800, BoB_2_iso800, '-x', color = 'olive', label=r'$\delta^{18}$O', alpha = 0.7)
ax2.set_ylabel(r'$\delta^{18}$O', color = 'olive')
ax2.invert_yaxis()  
ax2.tick_params(axis='y', labelcolor = 'olive')

axes[4].plot(tools.list_time, tempe_mean, '-o', color = 'black')
axes[4].grid()
axes[4].set_title('lat : 32.50, lon : 119.17 MJJAS model vs $\delta^{18}$O speleothem from Hulu/Sanbao cave', size = 'large')
axes[4].set_ylabel('LST ($^\circ$C)', color='k')
ax2 = axes[4].twinx()
ax2.plot(speleo_age800, speleo_iso800, '-x', color = 'olive', label=r'$\delta^{18}$O', alpha = 0.15)
ax2.set_ylabel(r'$\delta^{18}$O', color = 'olive')
ax2.invert_yaxis()  
ax2.tick_params(axis='y', labelcolor = 'olive')

axes[5].plot(tools.list_time, np.asarray(precip_hulu)*86400, '-o', color = 'black')
axes[5].grid()
axes[5].set_title('lat : 32.50, lon : 119.17 MJJAS model vs $\delta^{18}$O speleothem from Hulu/Sanbao cave', size = 'large')
axes[5].set_ylabel('Precipitation \n (mm/day)', color='k')
ax2 = axes[5].twinx()
ax2.plot(speleo_age800, speleo_iso800, '-x', color = 'olive', label=r'$\delta^{18}$O', alpha = 0.15)
ax2.set_ylabel(r'$\delta^{18}$O', color = 'olive')
ax2.invert_yaxis()  
ax2.tick_params(axis='y', labelcolor = 'olive')

plt.tight_layout()
plt.savefig('/user/work/xk22684/work/fig/fig_paper_monsoon/fig_prox18o.png')
plt.show()
plt.close()
'-----------------------------------------------------------------'
pdb.set_trace()


